/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport.network.io;

import org.apache.mina.common.ByteBuffer;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQFrame;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQMethodBodyFactory;
import org.apache.qpid.framing.BodyFactory;
import org.apache.qpid.framing.ContentBodyFactory;
import org.apache.qpid.framing.ContentHeaderBodyFactory;
import org.apache.qpid.framing.HeartbeatBodyFactory;
import org.apache.qpid.framing.MethodRegistry;
import org.apache.qpid.protocol.AMQVersionAwareProtocolSession;
import org.apache.qpid.transport.Receiver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputHandler_0_9
implements Receiver<java.nio.ByteBuffer> {
    private AMQVersionAwareProtocolSession _session;
    private MethodRegistry _registry;
    private BodyFactory bodyFactory;
    private static final BodyFactory[] _bodiesSupported = new BodyFactory[127];

    public InputHandler_0_9(AMQVersionAwareProtocolSession session) {
        this._session = session;
        this._registry = this._session.getMethodRegistry();
    }

    @Override
    public void closed() {
    }

    @Override
    public void exception(Throwable t) {
        t.printStackTrace();
    }

    @Override
    public void received(java.nio.ByteBuffer buf) {
        ByteBuffer in = ByteBuffer.wrap(buf);
        try {
            byte type = in.get();
            this.bodyFactory = type == 1 ? new AMQMethodBodyFactory(this._session) : _bodiesSupported[type];
            if (this.bodyFactory == null) {
                throw new AMQFrameDecodingException(null, "Unsupported frame type: " + type, null);
            }
            int channel = in.getUnsignedShort();
            long bodySize = in.getUnsignedInt();
            if (channel < 0 || bodySize < 0L) {
                throw new AMQFrameDecodingException(null, "Undecodable frame: type = " + type + " channel = " + channel + " bodySize = " + bodySize, null);
            }
            AMQFrame frame = new AMQFrame(in, channel, bodySize, this.bodyFactory);
            byte marker = in.get();
            if ((marker & 0xFF) != 206) {
                throw new AMQFrameDecodingException(null, "End of frame marker not found. Read " + marker + " length=" + bodySize + " type=" + type, null);
            }
            try {
                frame.getBodyFrame().handle(frame.getChannel(), this._session);
            }
            catch (AMQException e) {
                e.printStackTrace();
            }
        }
        catch (AMQFrameDecodingException e) {
            e.printStackTrace();
        }
    }

    static {
        InputHandler_0_9._bodiesSupported[2] = ContentHeaderBodyFactory.getInstance();
        InputHandler_0_9._bodiesSupported[3] = ContentBodyFactory.getInstance();
        InputHandler_0_9._bodiesSupported[8] = new HeartbeatBodyFactory();
    }
}

