/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.qpid.transport.Method;
import org.apache.qpid.transport.MethodDelegate;
import org.apache.qpid.transport.Option;
import org.apache.qpid.transport.RangeSet;
import org.apache.qpid.transport.codec.Decoder;
import org.apache.qpid.transport.codec.Encoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SessionGap
extends Method {
    public static final int TYPE = 525;
    private short packing_flags = 0;
    private RangeSet commands;

    @Override
    public final int getStructType() {
        return 525;
    }

    @Override
    public final int getSizeWidth() {
        return 0;
    }

    @Override
    public final int getPackWidth() {
        return 2;
    }

    @Override
    public final boolean hasPayload() {
        return false;
    }

    @Override
    public final byte getEncodedTrack() {
        return 2;
    }

    @Override
    public final boolean isConnectionControl() {
        return false;
    }

    public SessionGap() {
    }

    public SessionGap(RangeSet commands, Option ... _options) {
        if (commands != null) {
            this.setCommands(commands);
        }
        block6: for (int i = 0; i < _options.length; ++i) {
            switch (_options[i]) {
                case SYNC: {
                    this.setSync(true);
                    continue block6;
                }
                case BATCH: {
                    this.setBatch(true);
                    continue block6;
                }
                case UNRELIABLE: {
                    this.setUnreliable(true);
                    continue block6;
                }
                case NONE: {
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("invalid option: " + (Object)((Object)_options[i]));
                }
            }
        }
    }

    @Override
    public <C> void dispatch(C context, MethodDelegate<C> delegate) {
        delegate.sessionGap(context, this);
    }

    public final boolean hasCommands() {
        return (this.packing_flags & 0x100) != 0;
    }

    public final SessionGap clearCommands() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFEFF);
        this.commands = null;
        this.dirty = true;
        return this;
    }

    public final RangeSet getCommands() {
        return this.commands;
    }

    public final SessionGap setCommands(RangeSet value) {
        this.commands = value;
        this.packing_flags = (short)(this.packing_flags | 0x100);
        this.dirty = true;
        return this;
    }

    public final SessionGap commands(RangeSet value) {
        return this.setCommands(value);
    }

    @Override
    public void write(Encoder enc) {
        enc.writeUint16(this.packing_flags);
        if ((this.packing_flags & 0x100) != 0) {
            enc.writeSequenceSet(this.commands);
        }
    }

    @Override
    public void read(Decoder dec) {
        this.packing_flags = (short)dec.readUint16();
        if ((this.packing_flags & 0x100) != 0) {
            this.commands = dec.readSequenceSet();
        }
    }

    @Override
    public Map<String, Object> getFields() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if ((this.packing_flags & 0x100) != 0) {
            result.put("commands", this.getCommands());
        }
        return result;
    }
}

