/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.qpid.transport.MessageDeliveryMode;
import org.apache.qpid.transport.MessageDeliveryPriority;
import org.apache.qpid.transport.Option;
import org.apache.qpid.transport.Struct;
import org.apache.qpid.transport.codec.Decoder;
import org.apache.qpid.transport.codec.Encoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DeliveryProperties
extends Struct {
    public static final int TYPE = 1025;
    private short packing_flags = 0;
    private MessageDeliveryPriority priority;
    private MessageDeliveryMode deliveryMode;
    private long ttl;
    private long timestamp;
    private long expiration;
    private String exchange;
    private String routingKey;
    private String resumeId;
    private long resumeTtl;

    @Override
    public final int getStructType() {
        return 1025;
    }

    @Override
    public final int getSizeWidth() {
        return 4;
    }

    @Override
    public final int getPackWidth() {
        return 2;
    }

    public final boolean hasPayload() {
        return false;
    }

    public final byte getEncodedTrack() {
        return -1;
    }

    public final boolean isConnectionControl() {
        return false;
    }

    public DeliveryProperties() {
    }

    public DeliveryProperties(MessageDeliveryPriority priority, MessageDeliveryMode deliveryMode, long ttl, long timestamp, long expiration, String exchange, String routingKey, String resumeId, long resumeTtl, Option ... _options) {
        if (priority != null) {
            this.setPriority(priority);
        }
        if (deliveryMode != null) {
            this.setDeliveryMode(deliveryMode);
        }
        this.setTtl(ttl);
        this.setTimestamp(timestamp);
        this.setExpiration(expiration);
        if (exchange != null) {
            this.setExchange(exchange);
        }
        if (routingKey != null) {
            this.setRoutingKey(routingKey);
        }
        if (resumeId != null) {
            this.setResumeId(resumeId);
        }
        this.setResumeTtl(resumeTtl);
        block6: for (int i = 0; i < _options.length; ++i) {
            switch (_options[i]) {
                case DISCARD_UNROUTABLE: {
                    this.packing_flags = (short)(this.packing_flags | 0x100);
                    continue block6;
                }
                case IMMEDIATE: {
                    this.packing_flags = (short)(this.packing_flags | 0x200);
                    continue block6;
                }
                case REDELIVERED: {
                    this.packing_flags = (short)(this.packing_flags | 0x400);
                    continue block6;
                }
                case NONE: {
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("invalid option: " + (Object)((Object)_options[i]));
                }
            }
        }
    }

    public final boolean hasDiscardUnroutable() {
        return (this.packing_flags & 0x100) != 0;
    }

    public final DeliveryProperties clearDiscardUnroutable() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFEFF);
        this.dirty = true;
        return this;
    }

    public final boolean getDiscardUnroutable() {
        return this.hasDiscardUnroutable();
    }

    public final DeliveryProperties setDiscardUnroutable(boolean value) {
        this.packing_flags = value ? (short)(this.packing_flags | 0x100) : (short)(this.packing_flags & 0xFFFFFEFF);
        this.dirty = true;
        return this;
    }

    public final DeliveryProperties discardUnroutable(boolean value) {
        return this.setDiscardUnroutable(value);
    }

    public final boolean hasImmediate() {
        return (this.packing_flags & 0x200) != 0;
    }

    public final DeliveryProperties clearImmediate() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFDFF);
        this.dirty = true;
        return this;
    }

    public final boolean getImmediate() {
        return this.hasImmediate();
    }

    public final DeliveryProperties setImmediate(boolean value) {
        this.packing_flags = value ? (short)(this.packing_flags | 0x200) : (short)(this.packing_flags & 0xFFFFFDFF);
        this.dirty = true;
        return this;
    }

    public final DeliveryProperties immediate(boolean value) {
        return this.setImmediate(value);
    }

    public final boolean hasRedelivered() {
        return (this.packing_flags & 0x400) != 0;
    }

    public final DeliveryProperties clearRedelivered() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFBFF);
        this.dirty = true;
        return this;
    }

    public final boolean getRedelivered() {
        return this.hasRedelivered();
    }

    public final DeliveryProperties setRedelivered(boolean value) {
        this.packing_flags = value ? (short)(this.packing_flags | 0x400) : (short)(this.packing_flags & 0xFFFFFBFF);
        this.dirty = true;
        return this;
    }

    public final DeliveryProperties redelivered(boolean value) {
        return this.setRedelivered(value);
    }

    public final boolean hasPriority() {
        return (this.packing_flags & 0x800) != 0;
    }

    public final DeliveryProperties clearPriority() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFF7FF);
        this.priority = null;
        this.dirty = true;
        return this;
    }

    public final MessageDeliveryPriority getPriority() {
        return this.priority;
    }

    public final DeliveryProperties setPriority(MessageDeliveryPriority value) {
        this.priority = value;
        this.packing_flags = (short)(this.packing_flags | 0x800);
        this.dirty = true;
        return this;
    }

    public final DeliveryProperties priority(MessageDeliveryPriority value) {
        return this.setPriority(value);
    }

    public final boolean hasDeliveryMode() {
        return (this.packing_flags & 0x1000) != 0;
    }

    public final DeliveryProperties clearDeliveryMode() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFEFFF);
        this.deliveryMode = null;
        this.dirty = true;
        return this;
    }

    public final MessageDeliveryMode getDeliveryMode() {
        return this.deliveryMode;
    }

    public final DeliveryProperties setDeliveryMode(MessageDeliveryMode value) {
        this.deliveryMode = value;
        this.packing_flags = (short)(this.packing_flags | 0x1000);
        this.dirty = true;
        return this;
    }

    public final DeliveryProperties deliveryMode(MessageDeliveryMode value) {
        return this.setDeliveryMode(value);
    }

    public final boolean hasTtl() {
        return (this.packing_flags & 0x2000) != 0;
    }

    public final DeliveryProperties clearTtl() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFDFFF);
        this.ttl = 0L;
        this.dirty = true;
        return this;
    }

    public final long getTtl() {
        return this.ttl;
    }

    public final DeliveryProperties setTtl(long value) {
        this.ttl = value;
        this.packing_flags = (short)(this.packing_flags | 0x2000);
        this.dirty = true;
        return this;
    }

    public final DeliveryProperties ttl(long value) {
        return this.setTtl(value);
    }

    public final boolean hasTimestamp() {
        return (this.packing_flags & 0x4000) != 0;
    }

    public final DeliveryProperties clearTimestamp() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFBFFF);
        this.timestamp = 0L;
        this.dirty = true;
        return this;
    }

    public final long getTimestamp() {
        return this.timestamp;
    }

    public final DeliveryProperties setTimestamp(long value) {
        this.timestamp = value;
        this.packing_flags = (short)(this.packing_flags | 0x4000);
        this.dirty = true;
        return this;
    }

    public final DeliveryProperties timestamp(long value) {
        return this.setTimestamp(value);
    }

    public final boolean hasExpiration() {
        return (this.packing_flags & 0x8000) != 0;
    }

    public final DeliveryProperties clearExpiration() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFF7FFF);
        this.expiration = 0L;
        this.dirty = true;
        return this;
    }

    public final long getExpiration() {
        return this.expiration;
    }

    public final DeliveryProperties setExpiration(long value) {
        this.expiration = value;
        this.packing_flags = (short)(this.packing_flags | 0x8000);
        this.dirty = true;
        return this;
    }

    public final DeliveryProperties expiration(long value) {
        return this.setExpiration(value);
    }

    public final boolean hasExchange() {
        return (this.packing_flags & 1) != 0;
    }

    public final DeliveryProperties clearExchange() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFFFE);
        this.exchange = null;
        this.dirty = true;
        return this;
    }

    public final String getExchange() {
        return this.exchange;
    }

    public final DeliveryProperties setExchange(String value) {
        this.exchange = value;
        this.packing_flags = (short)(this.packing_flags | 1);
        this.dirty = true;
        return this;
    }

    public final DeliveryProperties exchange(String value) {
        return this.setExchange(value);
    }

    public final boolean hasRoutingKey() {
        return (this.packing_flags & 2) != 0;
    }

    public final DeliveryProperties clearRoutingKey() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFFFD);
        this.routingKey = null;
        this.dirty = true;
        return this;
    }

    public final String getRoutingKey() {
        return this.routingKey;
    }

    public final DeliveryProperties setRoutingKey(String value) {
        this.routingKey = value;
        this.packing_flags = (short)(this.packing_flags | 2);
        this.dirty = true;
        return this;
    }

    public final DeliveryProperties routingKey(String value) {
        return this.setRoutingKey(value);
    }

    public final boolean hasResumeId() {
        return (this.packing_flags & 4) != 0;
    }

    public final DeliveryProperties clearResumeId() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFFFB);
        this.resumeId = null;
        this.dirty = true;
        return this;
    }

    public final String getResumeId() {
        return this.resumeId;
    }

    public final DeliveryProperties setResumeId(String value) {
        this.resumeId = value;
        this.packing_flags = (short)(this.packing_flags | 4);
        this.dirty = true;
        return this;
    }

    public final DeliveryProperties resumeId(String value) {
        return this.setResumeId(value);
    }

    public final boolean hasResumeTtl() {
        return (this.packing_flags & 8) != 0;
    }

    public final DeliveryProperties clearResumeTtl() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFFF7);
        this.resumeTtl = 0L;
        this.dirty = true;
        return this;
    }

    public final long getResumeTtl() {
        return this.resumeTtl;
    }

    public final DeliveryProperties setResumeTtl(long value) {
        this.resumeTtl = value;
        this.packing_flags = (short)(this.packing_flags | 8);
        this.dirty = true;
        return this;
    }

    public final DeliveryProperties resumeTtl(long value) {
        return this.setResumeTtl(value);
    }

    @Override
    public void write(Encoder enc) {
        enc.writeUint16(this.packing_flags);
        if ((this.packing_flags & 0x800) != 0) {
            enc.writeUint8(this.priority.getValue());
        }
        if ((this.packing_flags & 0x1000) != 0) {
            enc.writeUint8(this.deliveryMode.getValue());
        }
        if ((this.packing_flags & 0x2000) != 0) {
            enc.writeUint64(this.ttl);
        }
        if ((this.packing_flags & 0x4000) != 0) {
            enc.writeDatetime(this.timestamp);
        }
        if ((this.packing_flags & 0x8000) != 0) {
            enc.writeDatetime(this.expiration);
        }
        if ((this.packing_flags & 1) != 0) {
            enc.writeStr8(this.exchange);
        }
        if ((this.packing_flags & 2) != 0) {
            enc.writeStr8(this.routingKey);
        }
        if ((this.packing_flags & 4) != 0) {
            enc.writeStr16(this.resumeId);
        }
        if ((this.packing_flags & 8) != 0) {
            enc.writeUint64(this.resumeTtl);
        }
    }

    @Override
    public void read(Decoder dec) {
        this.packing_flags = (short)dec.readUint16();
        if ((this.packing_flags & 0x800) != 0) {
            this.priority = MessageDeliveryPriority.get(dec.readUint8());
        }
        if ((this.packing_flags & 0x1000) != 0) {
            this.deliveryMode = MessageDeliveryMode.get(dec.readUint8());
        }
        if ((this.packing_flags & 0x2000) != 0) {
            this.ttl = dec.readUint64();
        }
        if ((this.packing_flags & 0x4000) != 0) {
            this.timestamp = dec.readDatetime();
        }
        if ((this.packing_flags & 0x8000) != 0) {
            this.expiration = dec.readDatetime();
        }
        if ((this.packing_flags & 1) != 0) {
            this.exchange = dec.readStr8();
        }
        if ((this.packing_flags & 2) != 0) {
            this.routingKey = dec.readStr8();
        }
        if ((this.packing_flags & 4) != 0) {
            this.resumeId = dec.readStr16();
        }
        if ((this.packing_flags & 8) != 0) {
            this.resumeTtl = dec.readUint64();
        }
    }

    @Override
    public Map<String, Object> getFields() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if ((this.packing_flags & 0x100) != 0) {
            result.put("discardUnroutable", this.getDiscardUnroutable());
        }
        if ((this.packing_flags & 0x200) != 0) {
            result.put("immediate", this.getImmediate());
        }
        if ((this.packing_flags & 0x400) != 0) {
            result.put("redelivered", this.getRedelivered());
        }
        if ((this.packing_flags & 0x800) != 0) {
            result.put("priority", (Object)this.getPriority());
        }
        if ((this.packing_flags & 0x1000) != 0) {
            result.put("deliveryMode", (Object)this.getDeliveryMode());
        }
        if ((this.packing_flags & 0x2000) != 0) {
            result.put("ttl", this.getTtl());
        }
        if ((this.packing_flags & 0x4000) != 0) {
            result.put("timestamp", this.getTimestamp());
        }
        if ((this.packing_flags & 0x8000) != 0) {
            result.put("expiration", this.getExpiration());
        }
        if ((this.packing_flags & 1) != 0) {
            result.put("exchange", this.getExchange());
        }
        if ((this.packing_flags & 2) != 0) {
            result.put("routingKey", this.getRoutingKey());
        }
        if ((this.packing_flags & 4) != 0) {
            result.put("resumeId", this.getResumeId());
        }
        if ((this.packing_flags & 8) != 0) {
            result.put("resumeTtl", this.getResumeTtl());
        }
        return result;
    }
}

