/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.nclient.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.qpid.nclient.MessagePartListener;
import org.apache.qpid.nclient.util.ByteBufferMessage;
import org.apache.qpid.nclient.util.MessageListener;
import org.apache.qpid.transport.DeliveryProperties;
import org.apache.qpid.transport.MessageProperties;
import org.apache.qpid.transport.MessageTransfer;
import org.apache.qpid.transport.Struct;

public class MessagePartListenerAdapter
implements MessagePartListener {
    MessageListener _adaptee;
    ByteBufferMessage _currentMsg;

    public MessagePartListenerAdapter(MessageListener listener) {
        this._adaptee = listener;
    }

    public void messageTransfer(MessageTransfer xfr) {
        this._currentMsg = new ByteBufferMessage(xfr.getId());
        for (Struct st : xfr.getHeader().getStructs()) {
            if (st instanceof DeliveryProperties) {
                this._currentMsg.setDeliveryProperties((DeliveryProperties)st);
                continue;
            }
            if (!(st instanceof MessageProperties)) continue;
            this._currentMsg.setMessageProperties((MessageProperties)st);
        }
        ByteBuffer body = xfr.getBody();
        if (body == null) {
            body = ByteBuffer.allocate(0);
        }
        try {
            this._currentMsg.appendData(body);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this._adaptee.onMessage(this._currentMsg);
    }
}

