/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing.amqp_0_9;

import org.apache.mina.common.ByteBuffer;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyInstanceFactory;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.MessageGetBody;
import org.apache.qpid.framing.MethodDispatcher;
import org.apache.qpid.framing.amqp_0_9.AMQMethodBody_0_9;
import org.apache.qpid.framing.amqp_0_9.MethodDispatcher_0_9;

public class MessageGetBodyImpl
extends AMQMethodBody_0_9
implements MessageGetBody {
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory(){

        public AMQMethodBody newInstance(ByteBuffer in, long size) throws AMQFrameDecodingException {
            return new MessageGetBodyImpl(in);
        }
    };
    public static final int CLASS_ID = 120;
    public static final int METHOD_ID = 40;
    private final int _ticket;
    private final AMQShortString _queue;
    private final AMQShortString _destination;
    private final byte _bitfield0;

    public static AMQMethodBodyInstanceFactory getFactory() {
        return FACTORY_INSTANCE;
    }

    public MessageGetBodyImpl(ByteBuffer buffer) throws AMQFrameDecodingException {
        this._ticket = this.readUnsignedShort(buffer);
        this._queue = this.readAMQShortString(buffer);
        this._destination = this.readAMQShortString(buffer);
        this._bitfield0 = this.readBitfield(buffer);
    }

    public MessageGetBodyImpl(int ticket, AMQShortString queue, AMQShortString destination, boolean noAck) {
        this._ticket = ticket;
        this._queue = queue;
        this._destination = destination;
        byte bitfield0 = 0;
        if (noAck) {
            bitfield0 = (byte)(bitfield0 | 1);
        }
        this._bitfield0 = bitfield0;
    }

    public int getClazz() {
        return 120;
    }

    public int getMethod() {
        return 40;
    }

    public final int getTicket() {
        return this._ticket;
    }

    public final AMQShortString getQueue() {
        return this._queue;
    }

    public final AMQShortString getDestination() {
        return this._destination;
    }

    public final boolean getNoAck() {
        return (this._bitfield0 & 1) != 0;
    }

    protected int getBodySize() {
        int size = 3;
        size += this.getSizeOf(this._queue);
        return size += this.getSizeOf(this._destination);
    }

    public void writeMethodPayload(ByteBuffer buffer) {
        this.writeUnsignedShort(buffer, this._ticket);
        this.writeAMQShortString(buffer, this._queue);
        this.writeAMQShortString(buffer, this._destination);
        this.writeBitfield(buffer, this._bitfield0);
    }

    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException {
        return ((MethodDispatcher_0_9)dispatcher).dispatchMessageGet(this, channelId);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("[MessageGetBodyImpl: ");
        buf.append("ticket=");
        buf.append(this.getTicket());
        buf.append(", ");
        buf.append("queue=");
        buf.append(this.getQueue());
        buf.append(", ");
        buf.append("destination=");
        buf.append(this.getDestination());
        buf.append(", ");
        buf.append("noAck=");
        buf.append(this.getNoAck());
        buf.append("]");
        return buf.toString();
    }
}

