/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing.amqp_0_9;

import java.util.Arrays;
import org.apache.mina.common.ByteBuffer;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyInstanceFactory;
import org.apache.qpid.framing.ConnectionSecureBody;
import org.apache.qpid.framing.MethodDispatcher;
import org.apache.qpid.framing.amqp_0_9.AMQMethodBody_0_9;
import org.apache.qpid.framing.amqp_0_9.MethodDispatcher_0_9;

public class ConnectionSecureBodyImpl
extends AMQMethodBody_0_9
implements ConnectionSecureBody {
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory(){

        public AMQMethodBody newInstance(ByteBuffer in, long size) throws AMQFrameDecodingException {
            return new ConnectionSecureBodyImpl(in);
        }
    };
    public static final int CLASS_ID = 10;
    public static final int METHOD_ID = 20;
    private final byte[] _challenge;

    public static AMQMethodBodyInstanceFactory getFactory() {
        return FACTORY_INSTANCE;
    }

    public ConnectionSecureBodyImpl(ByteBuffer buffer) throws AMQFrameDecodingException {
        this._challenge = this.readBytes(buffer);
    }

    public ConnectionSecureBodyImpl(byte[] challenge) {
        this._challenge = challenge;
    }

    public int getClazz() {
        return 10;
    }

    public int getMethod() {
        return 20;
    }

    public final byte[] getChallenge() {
        return this._challenge;
    }

    protected int getBodySize() {
        int size = 0;
        return size += this.getSizeOf(this._challenge);
    }

    public void writeMethodPayload(ByteBuffer buffer) {
        this.writeBytes(buffer, this._challenge);
    }

    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException {
        return ((MethodDispatcher_0_9)dispatcher).dispatchConnectionSecure(this, channelId);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("[ConnectionSecureBodyImpl: ");
        buf.append("challenge=");
        buf.append(this.getChallenge() == null ? "null" : Arrays.toString(this.getChallenge()));
        buf.append("]");
        return buf.toString();
    }
}

