/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing;

import org.apache.mina.common.ByteBuffer;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.BasicContentHeaderProperties;
import org.apache.qpid.framing.ContentHeaderProperties;

public class ContentHeaderPropertiesFactory {
    private static final ContentHeaderPropertiesFactory _instance = new ContentHeaderPropertiesFactory();

    public static ContentHeaderPropertiesFactory getInstance() {
        return _instance;
    }

    private ContentHeaderPropertiesFactory() {
    }

    public ContentHeaderProperties createContentHeaderProperties(int classId, int propertyFlags, ByteBuffer buffer, int size) throws AMQFrameDecodingException {
        if (classId != 60) {
            throw new AMQFrameDecodingException(null, "Unsupport content header class id: " + classId, null);
        }
        BasicContentHeaderProperties properties = new BasicContentHeaderProperties();
        properties.populatePropertiesFromBuffer(buffer, propertyFlags, size);
        return properties;
    }
}

