/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing;

import java.util.Collections;
import java.util.Set;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;
import org.apache.mina.filter.codec.demux.MessageEncoder;
import org.apache.qpid.framing.AMQDataBlock;
import org.apache.qpid.framing.EncodableAMQDataBlock;
import org.apache.qpid.framing.EncodingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AMQDataBlockEncoder
implements MessageEncoder {
    private static final Logger _logger = LoggerFactory.getLogger(AMQDataBlockEncoder.class);
    private final Set _messageTypes = Collections.singleton(EncodableAMQDataBlock.class);

    public void encode(IoSession session, Object message, ProtocolEncoderOutput out) throws Exception {
        AMQDataBlock frame = (AMQDataBlock)message;
        ByteBuffer buffer = frame.toByteBuffer();
        if (_logger.isDebugEnabled()) {
            _logger.debug("Encoded frame byte-buffer is '" + EncodingUtils.convertToHexString(buffer) + "'");
        }
        out.write(buffer);
    }

    public Set getMessageTypes() {
        return this._messageTypes;
    }
}

