/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.codec;

import java.util.ArrayList;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.SimpleByteBufferAllocator;
import org.apache.mina.filter.codec.CumulativeProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.apache.qpid.framing.AMQDataBlock;
import org.apache.qpid.framing.AMQDataBlockDecoder;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQMethodBodyFactory;
import org.apache.qpid.framing.AMQProtocolVersionException;
import org.apache.qpid.framing.ProtocolInitiation;
import org.apache.qpid.protocol.AMQVersionAwareProtocolSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AMQDecoder
extends CumulativeProtocolDecoder {
    private static final String BUFFER = AMQDecoder.class.getName() + ".Buffer";
    private AMQDataBlockDecoder _dataBlockDecoder = new AMQDataBlockDecoder();
    private ProtocolInitiation.Decoder _piDecoder = new ProtocolInitiation.Decoder();
    private boolean _expectProtocolInitiation;
    private boolean firstDecode = true;
    private AMQMethodBodyFactory _bodyFactory;
    private ByteBuffer _remainingBuf;
    private static final SimpleByteBufferAllocator SIMPLE_BYTE_BUFFER_ALLOCATOR = new SimpleByteBufferAllocator();

    public AMQDecoder(boolean expectProtocolInitiation, AMQVersionAwareProtocolSession session) {
        this._expectProtocolInitiation = expectProtocolInitiation;
        this._bodyFactory = new AMQMethodBodyFactory(session);
    }

    @Override
    protected boolean doDecode(IoSession session, ByteBuffer in, ProtocolDecoderOutput out) throws Exception {
        boolean decoded = this._expectProtocolInitiation || this.firstDecode && in.remaining() > 0 && in.get(in.position()) == 65 ? this.doDecodePI(session, in, out) : this.doDecodeDataBlock(session, in, out);
        if (this.firstDecode && decoded) {
            this.firstDecode = false;
        }
        return decoded;
    }

    protected boolean doDecodeDataBlock(IoSession session, ByteBuffer in, ProtocolDecoderOutput out) throws Exception {
        int pos = in.position();
        boolean enoughData = this._dataBlockDecoder.decodable(in.buf());
        in.position(pos);
        if (!enoughData) {
            return false;
        }
        this._dataBlockDecoder.decode(session, in, out);
        return true;
    }

    private boolean doDecodePI(IoSession session, ByteBuffer in, ProtocolDecoderOutput out) throws Exception {
        boolean enoughData = this._piDecoder.decodable(in.buf());
        if (!enoughData) {
            return false;
        }
        ProtocolInitiation pi = new ProtocolInitiation(in.buf());
        out.write(pi);
        return true;
    }

    public void setExpectProtocolInitiation(boolean expectProtocolInitiation) {
        this._expectProtocolInitiation = expectProtocolInitiation;
    }

    @Override
    public void decode(IoSession session, ByteBuffer in, ProtocolDecoderOutput out) throws Exception {
        ByteBuffer buf = (ByteBuffer)session.getAttribute(BUFFER);
        if (buf != null) {
            buf.put(in);
            buf.flip();
        } else {
            buf = in;
        }
        do {
            int oldPos = buf.position();
            boolean decoded = this.doDecode(session, buf, out);
            if (!decoded) break;
            if (buf.position() != oldPos) continue;
            throw new IllegalStateException("doDecode() can't return true when buffer is not consumed.");
        } while (buf.hasRemaining());
        if (buf.hasRemaining()) {
            this.storeRemainingInSession(buf, session);
        } else {
            this.removeSessionBuffer(session);
        }
    }

    @Override
    public void dispose(IoSession session) throws Exception {
        this.removeSessionBuffer(session);
    }

    private void removeSessionBuffer(IoSession session) {
        ByteBuffer buf = (ByteBuffer)session.getAttribute(BUFFER);
        if (buf != null) {
            buf.release();
            session.removeAttribute(BUFFER);
        }
    }

    private void storeRemainingInSession(ByteBuffer buf, IoSession session) {
        ByteBuffer remainingBuf = SIMPLE_BYTE_BUFFER_ALLOCATOR.allocate(buf.remaining(), false);
        remainingBuf.setAutoExpand(true);
        remainingBuf.put(buf);
        session.setAttribute(BUFFER, remainingBuf);
    }

    public ArrayList<AMQDataBlock> decodeBuffer(java.nio.ByteBuffer buf) throws AMQFrameDecodingException, AMQProtocolVersionException {
        ByteBuffer msg;
        ArrayList<AMQDataBlock> dataBlocks = new ArrayList<AMQDataBlock>();
        if (this._remainingBuf != null) {
            this._remainingBuf.put(buf);
            this._remainingBuf.flip();
            msg = this._remainingBuf;
        } else {
            msg = ByteBuffer.wrap(buf);
        }
        if (this._expectProtocolInitiation || this.firstDecode && msg.remaining() > 0 && msg.get(msg.position()) == 65) {
            if (this._piDecoder.decodable(msg.buf())) {
                dataBlocks.add(new ProtocolInitiation(msg.buf()));
            }
        } else {
            boolean enoughData = true;
            while (enoughData) {
                int pos = msg.position();
                enoughData = this._dataBlockDecoder.decodable(msg);
                msg.position(pos);
                if (enoughData) {
                    dataBlocks.add(this._dataBlockDecoder.createAndPopulateFrame(this._bodyFactory, msg));
                    continue;
                }
                this._remainingBuf = SIMPLE_BYTE_BUFFER_ALLOCATOR.allocate(msg.remaining(), false);
                this._remainingBuf.setAutoExpand(true);
                this._remainingBuf.put(msg);
            }
        }
        if (this.firstDecode && dataBlocks.size() > 0) {
            this.firstDecode = false;
        }
        return dataBlocks;
    }
}

