/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.transport;

import java.io.IOException;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.mina.common.IoConnector;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.transport.socket.nio.ExistingSocketConnector;
import org.apache.mina.transport.socket.nio.MultiThreadSocketConnector;
import org.apache.mina.transport.socket.nio.SocketConnector;
import org.apache.mina.transport.vmpipe.VmPipeAcceptor;
import org.apache.mina.transport.vmpipe.VmPipeAddress;
import org.apache.qpid.client.transport.AMQNoTransportForProtocolException;
import org.apache.qpid.client.transport.AMQTransportConnectionException;
import org.apache.qpid.client.transport.ITransportConnection;
import org.apache.qpid.client.transport.SocketTransportConnection;
import org.apache.qpid.client.transport.VmPipeTransportConnection;
import org.apache.qpid.client.vmbroker.AMQVMBrokerCreationException;
import org.apache.qpid.jms.BrokerDetails;
import org.apache.qpid.protocol.ProtocolEngineFactory;
import org.apache.qpid.thread.QpidThreadExecutor;
import org.apache.qpid.transport.network.mina.MINANetworkDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportConnection {
    private static ITransportConnection _instance;
    private static final Map _inVmPipeAddress;
    private static VmPipeAcceptor _acceptor;
    private static int _currentInstance;
    private static int _currentVMPort;
    private static final int TCP = 0;
    private static final int VM = 1;
    private static final int SOCKET = 2;
    private static Logger _logger;
    private static final String DEFAULT_QPID_SERVER = "org.apache.qpid.server.protocol.AMQProtocolEngineFactory";
    private static Map<String, Socket> _openSocketRegister;

    public static void registerOpenSocket(String socketID, Socket openSocket) {
        _openSocketRegister.put(socketID, openSocket);
    }

    public static Socket removeOpenSocket(String socketID) {
        return _openSocketRegister.remove(socketID);
    }

    public static synchronized ITransportConnection getInstance(final BrokerDetails details) throws AMQTransportConnectionException {
        int transport = TransportConnection.getTransport(details.getTransport());
        if (transport == -1) {
            throw new AMQNoTransportForProtocolException(details, null, null);
        }
        switch (transport) {
            case 2: {
                return new SocketTransportConnection(new SocketTransportConnection.SocketConnectorFactory(){

                    public IoConnector newSocketConnector() {
                        ExistingSocketConnector connector = new ExistingSocketConnector(1, new QpidThreadExecutor());
                        Socket socket = TransportConnection.removeOpenSocket(details.getHost());
                        if (socket == null) {
                            throw new IllegalArgumentException("Active Socket must be provided for broker with 'socket://<SocketID>' transport:" + details);
                        }
                        _logger.info("Using existing Socket:" + socket);
                        connector.setOpenSocket(socket);
                        return connector;
                    }
                });
            }
            case 0: {
                return new SocketTransportConnection(new SocketTransportConnection.SocketConnectorFactory(){

                    public IoConnector newSocketConnector() {
                        SocketConnector result;
                        if (Boolean.getBoolean("qpidnio")) {
                            _logger.warn("Using Qpid MultiThreaded NIO - " + (System.getProperties().containsKey("qpidnio") ? "Qpid NIO is new default" : "Sysproperty 'qpidnio' is set"));
                            result = new MultiThreadSocketConnector(1, new QpidThreadExecutor());
                        } else {
                            _logger.info("Using Mina NIO");
                            result = new SocketConnector(1, new QpidThreadExecutor());
                        }
                        result.setWorkerTimeout(0);
                        return result;
                    }
                });
            }
            case 1: {
                return TransportConnection.getVMTransport(details, Boolean.getBoolean("amqj.AutoCreateVMBroker"));
            }
        }
        throw new AMQNoTransportForProtocolException(details, "Transport not recognised:" + transport, null);
    }

    private static int getTransport(String transport) {
        if (transport.equals("socket")) {
            return 2;
        }
        if (transport.equals("tcp")) {
            return 0;
        }
        if (transport.equals("vm")) {
            return 1;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ITransportConnection getVMTransport(BrokerDetails details, boolean AutoCreate) throws AMQVMBrokerCreationException {
        int port = details.getPort();
        Map map = _inVmPipeAddress;
        synchronized (map) {
            if (!_inVmPipeAddress.containsKey(port)) {
                if (AutoCreate) {
                    _logger.warn("Auto Creating InVM Broker on port:" + port);
                    TransportConnection.createVMBroker(port);
                } else {
                    throw new AMQVMBrokerCreationException(null, port, "VM Broker on port " + port + " does not exist. Auto create disabled.", null);
                }
            }
        }
        return new VmPipeTransportConnection(port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createVMBroker(int port) throws AMQVMBrokerCreationException {
        Object object = TransportConnection.class;
        synchronized (TransportConnection.class) {
            if (_acceptor == null) {
                _acceptor = new VmPipeAcceptor();
                IoServiceConfig config = _acceptor.getDefaultConfig();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            object = _inVmPipeAddress;
            synchronized (object) {
                if (!_inVmPipeAddress.containsKey(port)) {
                    _logger.info("Creating InVM Qpid.AMQP listening on port " + port);
                    IoHandlerAdapter provider = null;
                    try {
                        VmPipeAddress pipe = new VmPipeAddress(port);
                        provider = TransportConnection.createBrokerInstance(port);
                        _acceptor.bind(pipe, provider);
                        _inVmPipeAddress.put(port, pipe);
                        _logger.info("Created InVM Qpid.AMQP listening on port " + port);
                    }
                    catch (IOException e) {
                        _logger.error("Got IOException.", (Throwable)e);
                        try {
                            VmPipeAddress pipe = new VmPipeAddress(port);
                            try {
                                _acceptor.unbind(pipe);
                            }
                            catch (Exception ignore) {
                                // empty catch block
                            }
                            if (provider == null) {
                                provider = TransportConnection.createBrokerInstance(port);
                            }
                            _acceptor.bind(pipe, provider);
                            _inVmPipeAddress.put(port, pipe);
                            _logger.info("Created InVM Qpid.AMQP listening on port " + port);
                        }
                        catch (IOException justUseFirstException) {
                            String because = e.getCause() == null ? e.toString() : e.getCause().toString();
                            throw new AMQVMBrokerCreationException(null, port, because + " Stopped binding of InVM Qpid.AMQP", e);
                        }
                    }
                } else {
                    _logger.info("InVM Qpid.AMQP on port " + port + " already exits.");
                }
            }
            return;
        }
    }

    private static IoHandlerAdapter createBrokerInstance(int port) throws AMQVMBrokerCreationException {
        MINANetworkDriver provider;
        String protocolProviderClass = System.getProperty("amqj.protocolprovider.class", DEFAULT_QPID_SERVER);
        _logger.info("Creating Qpid protocol provider: " + protocolProviderClass);
        try {
            Class[] cnstr = new Class[]{Integer.class};
            Object[] params = new Object[]{port};
            provider = new MINANetworkDriver();
            ProtocolEngineFactory engineFactory = (ProtocolEngineFactory)Class.forName(protocolProviderClass).getConstructor(cnstr).newInstance(params);
            provider.setProtocolEngineFactory(engineFactory, true);
            _logger.info("Created VMBroker Instance:" + port);
        }
        catch (Exception e) {
            _logger.info("Unable to create InVM Qpid.AMQP on port " + port + ". Because: " + e.getCause());
            String because = e.getCause() == null ? e.toString() : e.getCause().toString();
            AMQVMBrokerCreationException amqbce = new AMQVMBrokerCreationException(null, port, because + " Stopped InVM Qpid.AMQP creation", e);
            throw amqbce;
        }
        return provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void killAllVMBrokers() {
        _logger.info("Killing all VM Brokers");
        Class<TransportConnection> clazz = TransportConnection.class;
        synchronized (TransportConnection.class) {
            if (_acceptor != null) {
                _acceptor.unbindAll();
            }
            Map map = _inVmPipeAddress;
            synchronized (map) {
                _inVmPipeAddress.clear();
            }
            _acceptor = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            _currentInstance = -1;
            _currentVMPort = -1;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void killVMBroker(int port) {
        Map map = _inVmPipeAddress;
        synchronized (map) {
            VmPipeAddress pipe = (VmPipeAddress)_inVmPipeAddress.get(port);
            if (pipe != null) {
                _logger.info("Killing VM Broker:" + port);
                _inVmPipeAddress.remove(port);
                _acceptor.unbind(pipe);
            }
        }
    }

    static {
        _inVmPipeAddress = new HashMap();
        _currentInstance = -1;
        _currentVMPort = -1;
        _logger = LoggerFactory.getLogger(TransportConnection.class);
        _openSocketRegister = new ConcurrentHashMap<String, Socket>();
    }
}

