/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.message;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jms.JMSException;
import org.apache.qpid.AMQException;
import org.apache.qpid.client.message.AMQMessageDelegateFactory;
import org.apache.qpid.client.message.AMQPEncodedMapMessageFactory;
import org.apache.qpid.client.message.AbstractJMSMessage;
import org.apache.qpid.client.message.JMSBytesMessageFactory;
import org.apache.qpid.client.message.JMSMapMessageFactory;
import org.apache.qpid.client.message.JMSObjectMessageFactory;
import org.apache.qpid.client.message.JMSStreamMessageFactory;
import org.apache.qpid.client.message.JMSTextMessageFactory;
import org.apache.qpid.client.message.MessageFactory;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.BasicContentHeaderProperties;
import org.apache.qpid.framing.ContentHeaderBody;
import org.apache.qpid.transport.DeliveryProperties;
import org.apache.qpid.transport.MessageProperties;
import org.apache.qpid.transport.MessageTransfer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageFactoryRegistry {
    protected final Logger _logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, MessageFactory> _mimeStringToFactoryMap = new HashMap<String, MessageFactory>();
    private final Map<AMQShortString, MessageFactory> _mimeShortStringToFactoryMap = new HashMap<AMQShortString, MessageFactory>();
    private final MessageFactory _default = new JMSBytesMessageFactory();

    public static MessageFactoryRegistry newDefaultRegistry() {
        MessageFactoryRegistry mf = new MessageFactoryRegistry();
        mf.registerFactory("jms/map-message", new JMSMapMessageFactory());
        mf.registerFactory("text/plain", new JMSTextMessageFactory());
        mf.registerFactory("text/xml", new JMSTextMessageFactory());
        mf.registerFactory("application/octet-stream", new JMSBytesMessageFactory());
        mf.registerFactory("application/java-object-stream", new JMSObjectMessageFactory());
        mf.registerFactory("jms/stream-message", new JMSStreamMessageFactory());
        mf.registerFactory("amqp/map", new AMQPEncodedMapMessageFactory());
        mf.registerFactory(null, mf._default);
        return mf;
    }

    public void registerFactory(String mimeType, MessageFactory mf) {
        if (mf == null) {
            throw new IllegalArgumentException("Message factory must not be null");
        }
        this._mimeStringToFactoryMap.put(mimeType, mf);
        this._mimeShortStringToFactoryMap.put(new AMQShortString(mimeType), mf);
    }

    public MessageFactory deregisterFactory(String mimeType) {
        this._mimeShortStringToFactoryMap.remove(new AMQShortString(mimeType));
        return this._mimeStringToFactoryMap.remove(mimeType);
    }

    public AbstractJMSMessage createMessage(long deliveryTag, boolean redelivered, AMQShortString exchange, AMQShortString routingKey, ContentHeaderBody contentHeader, List bodies) throws AMQException, JMSException {
        BasicContentHeaderProperties properties = (BasicContentHeaderProperties)contentHeader.properties;
        AMQShortString contentTypeShortString = properties.getContentType();
        contentTypeShortString = contentTypeShortString == null ? new AMQShortString("application/octet-stream") : contentTypeShortString;
        MessageFactory mf = this._mimeShortStringToFactoryMap.get(contentTypeShortString);
        if (mf == null) {
            mf = this._default;
        }
        return mf.createMessage(deliveryTag, redelivered, contentHeader, exchange, routingKey, bodies);
    }

    public AbstractJMSMessage createMessage(MessageTransfer transfer) throws AMQException, JMSException {
        MessageProperties mprop = transfer.getHeader().get(MessageProperties.class);
        String messageType = "";
        if (mprop == null || mprop.getContentType() == null) {
            this._logger.debug("no message type specified, building a byte message");
            messageType = "application/octet-stream";
        } else {
            messageType = mprop.getContentType();
        }
        MessageFactory mf = this._mimeStringToFactoryMap.get(messageType);
        if (mf == null) {
            mf = this._default;
        }
        boolean redelivered = false;
        DeliveryProperties deliverProps = transfer.getHeader().get(DeliveryProperties.class);
        if (deliverProps != null) {
            redelivered = deliverProps.getRedelivered();
        }
        return mf.createMessage(transfer.getId(), redelivered, mprop == null ? new MessageProperties() : mprop, deliverProps == null ? new DeliveryProperties() : deliverProps, transfer.getBody());
    }

    public AbstractJMSMessage createMessage(AMQMessageDelegateFactory delegateFactory, String mimeType) throws AMQException, JMSException {
        if (mimeType == null) {
            throw new IllegalArgumentException("Mime type must not be null");
        }
        MessageFactory mf = this._mimeStringToFactoryMap.get(mimeType);
        if (mf == null) {
            mf = this._default;
        }
        return mf.createMessage(delegateFactory);
    }
}

