/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.message;

import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;
import org.apache.mina.common.ByteBuffer;
import org.apache.qpid.AMQException;
import org.apache.qpid.client.message.AMQMessageDelegate;
import org.apache.qpid.client.message.AMQMessageDelegateFactory;
import org.apache.qpid.client.message.AbstractBytesMessage;

public abstract class AbstractBytesTypedMessage
extends AbstractBytesMessage {
    protected static final byte BOOLEAN_TYPE = 1;
    protected static final byte BYTE_TYPE = 2;
    protected static final byte BYTEARRAY_TYPE = 3;
    protected static final byte SHORT_TYPE = 4;
    protected static final byte CHAR_TYPE = 5;
    protected static final byte INT_TYPE = 6;
    protected static final byte LONG_TYPE = 7;
    protected static final byte FLOAT_TYPE = 8;
    protected static final byte DOUBLE_TYPE = 9;
    protected static final byte STRING_TYPE = 10;
    protected static final byte NULL_STRING_TYPE = 11;
    private int _byteArrayRemaining = -1;

    AbstractBytesTypedMessage(AMQMessageDelegateFactory delegateFactory) {
        this(delegateFactory, null);
    }

    AbstractBytesTypedMessage(AMQMessageDelegateFactory delegateFactory, ByteBuffer data) {
        super(delegateFactory, data);
    }

    AbstractBytesTypedMessage(AMQMessageDelegate delegate, ByteBuffer data) throws AMQException {
        super(delegate, data);
    }

    protected byte readWireType() throws MessageFormatException, MessageEOFException, MessageNotReadableException {
        this.checkReadable();
        this.checkAvailable(1);
        return this._data.get();
    }

    protected void writeTypeDiscriminator(byte type) throws MessageNotWriteableException {
        this.checkWritable();
        this._data.put(type);
        this._changedData = true;
    }

    protected boolean readBoolean() throws JMSException {
        int position = this._data.position();
        byte wireType = this.readWireType();
        try {
            boolean result;
            switch (wireType) {
                case 1: {
                    this.checkAvailable(1);
                    result = this.readBooleanImpl();
                    break;
                }
                case 10: {
                    this.checkAvailable(1);
                    result = Boolean.parseBoolean(this.readStringImpl());
                    break;
                }
                default: {
                    this._data.position(position);
                    throw new MessageFormatException("Unable to convert " + wireType + " to a boolean");
                }
            }
            return result;
        }
        catch (RuntimeException e) {
            this._data.position(position);
            throw e;
        }
    }

    private boolean readBooleanImpl() {
        return this._data.get() != 0;
    }

    protected byte readByte() throws JMSException {
        byte result;
        int position = this._data.position();
        byte wireType = this.readWireType();
        try {
            switch (wireType) {
                case 2: {
                    this.checkAvailable(1);
                    result = this.readByteImpl();
                    break;
                }
                case 10: {
                    this.checkAvailable(1);
                    result = Byte.parseByte(this.readStringImpl());
                    break;
                }
                default: {
                    this._data.position(position);
                    throw new MessageFormatException("Unable to convert " + wireType + " to a byte");
                }
            }
        }
        catch (RuntimeException e) {
            this._data.position(position);
            throw e;
        }
        return result;
    }

    private byte readByteImpl() {
        return this._data.get();
    }

    protected short readShort() throws JMSException {
        short result;
        int position = this._data.position();
        byte wireType = this.readWireType();
        try {
            switch (wireType) {
                case 4: {
                    this.checkAvailable(2);
                    result = this.readShortImpl();
                    break;
                }
                case 10: {
                    this.checkAvailable(1);
                    result = Short.parseShort(this.readStringImpl());
                    break;
                }
                case 2: {
                    this.checkAvailable(1);
                    result = this.readByteImpl();
                    break;
                }
                default: {
                    this._data.position(position);
                    throw new MessageFormatException("Unable to convert " + wireType + " to a short");
                }
            }
        }
        catch (RuntimeException e) {
            this._data.position(position);
            throw e;
        }
        return result;
    }

    private short readShortImpl() {
        return this._data.getShort();
    }

    protected char readChar() throws JMSException {
        int position = this._data.position();
        byte wireType = this.readWireType();
        try {
            if (wireType == 11) {
                throw new NullPointerException();
            }
            if (wireType != 5) {
                this._data.position(position);
                throw new MessageFormatException("Unable to convert " + wireType + " to a char");
            }
            this.checkAvailable(2);
            return this.readCharImpl();
        }
        catch (RuntimeException e) {
            this._data.position(position);
            throw e;
        }
    }

    private char readCharImpl() {
        return this._data.getChar();
    }

    protected int readInt() throws JMSException {
        int position = this._data.position();
        byte wireType = this.readWireType();
        try {
            int result;
            switch (wireType) {
                case 6: {
                    this.checkAvailable(4);
                    result = this.readIntImpl();
                    break;
                }
                case 4: {
                    this.checkAvailable(2);
                    result = this.readShortImpl();
                    break;
                }
                case 10: {
                    this.checkAvailable(1);
                    result = Integer.parseInt(this.readStringImpl());
                    break;
                }
                case 2: {
                    this.checkAvailable(1);
                    result = this.readByteImpl();
                    break;
                }
                default: {
                    this._data.position(position);
                    throw new MessageFormatException("Unable to convert " + wireType + " to an int");
                }
            }
            return result;
        }
        catch (RuntimeException e) {
            this._data.position(position);
            throw e;
        }
    }

    protected int readIntImpl() {
        return this._data.getInt();
    }

    protected long readLong() throws JMSException {
        int position = this._data.position();
        byte wireType = this.readWireType();
        try {
            long result;
            switch (wireType) {
                case 7: {
                    this.checkAvailable(8);
                    result = this.readLongImpl();
                    break;
                }
                case 6: {
                    this.checkAvailable(4);
                    result = this.readIntImpl();
                    break;
                }
                case 4: {
                    this.checkAvailable(2);
                    result = this.readShortImpl();
                    break;
                }
                case 10: {
                    this.checkAvailable(1);
                    result = Long.parseLong(this.readStringImpl());
                    break;
                }
                case 2: {
                    this.checkAvailable(1);
                    result = this.readByteImpl();
                    break;
                }
                default: {
                    this._data.position(position);
                    throw new MessageFormatException("Unable to convert " + wireType + " to a long");
                }
            }
            return result;
        }
        catch (RuntimeException e) {
            this._data.position(position);
            throw e;
        }
    }

    private long readLongImpl() {
        return this._data.getLong();
    }

    protected float readFloat() throws JMSException {
        int position = this._data.position();
        byte wireType = this.readWireType();
        try {
            float result;
            switch (wireType) {
                case 8: {
                    this.checkAvailable(4);
                    result = this.readFloatImpl();
                    break;
                }
                case 10: {
                    this.checkAvailable(1);
                    result = Float.parseFloat(this.readStringImpl());
                    break;
                }
                default: {
                    this._data.position(position);
                    throw new MessageFormatException("Unable to convert " + wireType + " to a float");
                }
            }
            return result;
        }
        catch (RuntimeException e) {
            this._data.position(position);
            throw e;
        }
    }

    private float readFloatImpl() {
        return this._data.getFloat();
    }

    protected double readDouble() throws JMSException {
        int position = this._data.position();
        byte wireType = this.readWireType();
        try {
            double result;
            switch (wireType) {
                case 9: {
                    this.checkAvailable(8);
                    result = this.readDoubleImpl();
                    break;
                }
                case 8: {
                    this.checkAvailable(4);
                    result = this.readFloatImpl();
                    break;
                }
                case 10: {
                    this.checkAvailable(1);
                    result = Double.parseDouble(this.readStringImpl());
                    break;
                }
                default: {
                    this._data.position(position);
                    throw new MessageFormatException("Unable to convert " + wireType + " to a double");
                }
            }
            return result;
        }
        catch (RuntimeException e) {
            this._data.position(position);
            throw e;
        }
    }

    private double readDoubleImpl() {
        return this._data.getDouble();
    }

    protected String readString() throws JMSException {
        int position = this._data.position();
        byte wireType = this.readWireType();
        try {
            String result2;
            switch (wireType) {
                case 10: {
                    this.checkAvailable(1);
                    result2 = this.readStringImpl();
                    break;
                }
                case 11: {
                    Object result2 = null;
                    throw new NullPointerException("data is null");
                }
                case 1: {
                    this.checkAvailable(1);
                    result2 = String.valueOf(this.readBooleanImpl());
                    break;
                }
                case 7: {
                    this.checkAvailable(8);
                    result2 = String.valueOf(this.readLongImpl());
                    break;
                }
                case 6: {
                    this.checkAvailable(4);
                    result2 = String.valueOf(this.readIntImpl());
                    break;
                }
                case 4: {
                    this.checkAvailable(2);
                    result2 = String.valueOf(this.readShortImpl());
                    break;
                }
                case 2: {
                    this.checkAvailable(1);
                    result2 = String.valueOf(this.readByteImpl());
                    break;
                }
                case 8: {
                    this.checkAvailable(4);
                    result2 = String.valueOf(this.readFloatImpl());
                    break;
                }
                case 9: {
                    this.checkAvailable(8);
                    result2 = String.valueOf(this.readDoubleImpl());
                    break;
                }
                case 5: {
                    this.checkAvailable(2);
                    result2 = String.valueOf(this.readCharImpl());
                    break;
                }
                default: {
                    this._data.position(position);
                    throw new MessageFormatException("Unable to convert " + wireType + " to a String");
                }
            }
            return result2;
        }
        catch (RuntimeException e) {
            this._data.position(position);
            throw e;
        }
    }

    protected String readStringImpl() throws JMSException {
        try {
            return this._data.getString(Charset.forName("UTF-8").newDecoder());
        }
        catch (CharacterCodingException e) {
            JMSException jmse = new JMSException("Error decoding byte stream as a UTF8 string: " + e);
            jmse.setLinkedException(e);
            jmse.initCause(e);
            throw jmse;
        }
    }

    protected int readBytes(byte[] bytes) throws JMSException {
        if (bytes == null) {
            throw new IllegalArgumentException("byte array must not be null");
        }
        this.checkReadable();
        if (this._byteArrayRemaining == -1) {
            this.checkAvailable(1);
            byte wireType = this.readWireType();
            if (wireType != 3) {
                throw new MessageFormatException("Unable to convert " + wireType + " to a byte array");
            }
            this.checkAvailable(4);
            int size = this._data.getInt();
            if (size == -1) {
                return -1;
            }
            if (size > this._data.remaining()) {
                throw new MessageEOFException("Byte array has stated length " + size + " but message only contains " + this._data.remaining() + " bytes");
            }
            this._byteArrayRemaining = size;
        } else if (this._byteArrayRemaining == 0) {
            this._byteArrayRemaining = -1;
            return -1;
        }
        int returnedSize = this.readBytesImpl(bytes);
        if (returnedSize < bytes.length) {
            this._byteArrayRemaining = -1;
        }
        return returnedSize;
    }

    private int readBytesImpl(byte[] bytes) {
        int count = this._byteArrayRemaining >= bytes.length ? bytes.length : this._byteArrayRemaining;
        this._byteArrayRemaining -= count;
        if (count == 0) {
            return 0;
        }
        this._data.get(bytes, 0, count);
        return count;
    }

    protected Object readObject() throws JMSException {
        int position = this._data.position();
        byte wireType = this.readWireType();
        Object result = null;
        try {
            switch (wireType) {
                case 1: {
                    this.checkAvailable(1);
                    result = this.readBooleanImpl();
                    break;
                }
                case 2: {
                    this.checkAvailable(1);
                    result = this.readByteImpl();
                    break;
                }
                case 3: {
                    this.checkAvailable(4);
                    int size = this._data.getInt();
                    if (size == -1) {
                        result = null;
                        break;
                    }
                    this._byteArrayRemaining = size;
                    byte[] bytesResult = new byte[size];
                    this.readBytesImpl(bytesResult);
                    result = bytesResult;
                    break;
                }
                case 4: {
                    this.checkAvailable(2);
                    result = this.readShortImpl();
                    break;
                }
                case 5: {
                    this.checkAvailable(2);
                    result = Character.valueOf(this.readCharImpl());
                    break;
                }
                case 6: {
                    this.checkAvailable(4);
                    result = this.readIntImpl();
                    break;
                }
                case 7: {
                    this.checkAvailable(8);
                    result = this.readLongImpl();
                    break;
                }
                case 8: {
                    this.checkAvailable(4);
                    result = Float.valueOf(this.readFloatImpl());
                    break;
                }
                case 9: {
                    this.checkAvailable(8);
                    result = this.readDoubleImpl();
                    break;
                }
                case 11: {
                    result = null;
                    break;
                }
                case 10: {
                    this.checkAvailable(1);
                    result = this.readStringImpl();
                }
            }
            return result;
        }
        catch (RuntimeException e) {
            this._data.position(position);
            throw e;
        }
    }

    protected void writeBoolean(boolean b) throws JMSException {
        this.writeTypeDiscriminator((byte)1);
        this._data.put(b ? (byte)1 : 0);
    }

    protected void writeByte(byte b) throws JMSException {
        this.writeTypeDiscriminator((byte)2);
        this._data.put(b);
    }

    protected void writeShort(short i) throws JMSException {
        this.writeTypeDiscriminator((byte)4);
        this._data.putShort(i);
    }

    protected void writeChar(char c) throws JMSException {
        this.writeTypeDiscriminator((byte)5);
        this._data.putChar(c);
    }

    protected void writeInt(int i) throws JMSException {
        this.writeTypeDiscriminator((byte)6);
        this.writeIntImpl(i);
    }

    protected void writeIntImpl(int i) {
        this._data.putInt(i);
    }

    protected void writeLong(long l) throws JMSException {
        this.writeTypeDiscriminator((byte)7);
        this._data.putLong(l);
    }

    protected void writeFloat(float v) throws JMSException {
        this.writeTypeDiscriminator((byte)8);
        this._data.putFloat(v);
    }

    protected void writeDouble(double v) throws JMSException {
        this.writeTypeDiscriminator((byte)9);
        this._data.putDouble(v);
    }

    protected void writeString(String string) throws JMSException {
        if (string == null) {
            this.writeTypeDiscriminator((byte)11);
        } else {
            this.writeTypeDiscriminator((byte)10);
            try {
                this.writeStringImpl(string);
            }
            catch (CharacterCodingException e) {
                JMSException jmse = new JMSException("Unable to encode string: " + e);
                jmse.setLinkedException(e);
                jmse.initCause(e);
                throw jmse;
            }
        }
    }

    protected void writeStringImpl(String string) throws CharacterCodingException {
        this._data.putString(string, Charset.forName("UTF-8").newEncoder());
        this._data.put((byte)0);
    }

    protected void writeBytes(byte[] bytes) throws JMSException {
        this.writeBytes(bytes, 0, bytes == null ? 0 : bytes.length);
    }

    protected void writeBytes(byte[] bytes, int offset, int length) throws JMSException {
        this.writeTypeDiscriminator((byte)3);
        if (bytes == null) {
            this._data.putInt(-1);
        } else {
            this._data.putInt(length);
            this._data.put(bytes, offset, length);
        }
    }

    protected void writeObject(Object object) throws JMSException {
        this.checkWritable();
        Class clazz = object == null ? String.class : object.getClass();
        if (clazz == Byte.class) {
            this.writeByte((Byte)object);
        } else if (clazz == Boolean.class) {
            this.writeBoolean((Boolean)object);
        } else if (clazz == byte[].class) {
            this.writeBytes((byte[])object);
        } else if (clazz == Short.class) {
            this.writeShort((Short)object);
        } else if (clazz == Character.class) {
            this.writeChar(((Character)object).charValue());
        } else if (clazz == Integer.class) {
            this.writeInt((Integer)object);
        } else if (clazz == Long.class) {
            this.writeLong((Long)object);
        } else if (clazz == Float.class) {
            this.writeFloat(((Float)object).floatValue());
        } else if (clazz == Double.class) {
            this.writeDouble((Double)object);
        } else if (clazz == String.class) {
            this.writeString((String)object);
        } else {
            throw new MessageFormatException("Only primitives plus byte arrays and String are valid types");
        }
    }
}

