/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client;

import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import org.apache.qpid.AMQException;
import org.apache.qpid.client.AMQDestination;
import org.apache.qpid.client.AMQSession;
import org.apache.qpid.client.BasicMessageConsumer;
import org.apache.qpid.client.Closeable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TopicSubscriberAdaptor<C extends BasicMessageConsumer>
implements TopicSubscriber {
    private final Topic _topic;
    private final C _consumer;
    private final boolean _noLocal;

    TopicSubscriberAdaptor(Topic topic, C consumer, boolean noLocal) {
        this._topic = topic;
        this._consumer = consumer;
        this._noLocal = noLocal;
    }

    TopicSubscriberAdaptor(Topic topic, C consumer) {
        this(topic, consumer, ((BasicMessageConsumer)consumer).isNoLocal());
    }

    @Override
    public Topic getTopic() throws JMSException {
        this.checkPreConditions();
        return this._topic;
    }

    @Override
    public boolean getNoLocal() throws JMSException {
        this.checkPreConditions();
        return this._noLocal;
    }

    @Override
    public String getMessageSelector() throws JMSException {
        this.checkPreConditions();
        return ((BasicMessageConsumer)this._consumer).getMessageSelector();
    }

    @Override
    public MessageListener getMessageListener() throws JMSException {
        this.checkPreConditions();
        return ((BasicMessageConsumer)this._consumer).getMessageListener();
    }

    @Override
    public void setMessageListener(MessageListener messageListener) throws JMSException {
        this.checkPreConditions();
        ((BasicMessageConsumer)this._consumer).setMessageListener(messageListener);
    }

    @Override
    public Message receive() throws JMSException {
        this.checkPreConditions();
        return ((BasicMessageConsumer)this._consumer).receive();
    }

    @Override
    public Message receive(long l) throws JMSException {
        return ((BasicMessageConsumer)this._consumer).receive(l);
    }

    @Override
    public Message receiveNoWait() throws JMSException {
        this.checkPreConditions();
        return ((BasicMessageConsumer)this._consumer).receiveNoWait();
    }

    @Override
    public void close() throws JMSException {
        ((BasicMessageConsumer)this._consumer).close();
    }

    private void checkPreConditions() throws IllegalStateException {
        C msgConsumer = this._consumer;
        if (((Closeable)msgConsumer).isClosed()) {
            throw new IllegalStateException("Consumer is closed");
        }
        if (this._topic == null) {
            throw new UnsupportedOperationException("Topic is null");
        }
        AMQSession session = ((BasicMessageConsumer)msgConsumer).getSession();
        if (session == null || session.isClosed()) {
            throw new IllegalStateException("Invalid Session");
        }
    }

    C getMessageConsumer() {
        return this._consumer;
    }

    public void addBindingKey(Topic topic, String bindingKey) throws AMQException {
        ((BasicMessageConsumer)this._consumer).addBindingKey((AMQDestination)((Object)topic), bindingKey);
    }
}

