/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client;

import java.io.UnsupportedEncodingException;
import java.util.UUID;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import org.apache.qpid.AMQException;
import org.apache.qpid.client.AMQConnection;
import org.apache.qpid.client.AMQDestination;
import org.apache.qpid.client.AMQSession;
import org.apache.qpid.client.AMQSessionDirtyException;
import org.apache.qpid.client.AMQUndefinedDestination;
import org.apache.qpid.client.Closeable;
import org.apache.qpid.client.JMSAMQException;
import org.apache.qpid.client.TemporaryDestination;
import org.apache.qpid.client.message.AbstractJMSMessage;
import org.apache.qpid.client.message.MessageConverter;
import org.apache.qpid.client.protocol.AMQProtocolHandler;
import org.apache.qpid.framing.ContentBody;
import org.apache.qpid.jms.MessageProducer;
import org.apache.qpid.util.UUIDGen;
import org.apache.qpid.util.UUIDs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasicMessageProducer
extends Closeable
implements MessageProducer {
    protected final Logger _logger = LoggerFactory.getLogger(this.getClass());
    private AMQConnection _connection;
    protected boolean _disableTimestamps;
    private int _messagePriority = 4;
    private long _timeToLive;
    private int _deliveryMode = 2;
    protected AMQDestination _destination;
    private String _encoding;
    private String _mimeType;
    protected AMQProtocolHandler _protocolHandler;
    private boolean _transacted;
    protected int _channelId;
    private long _producerId;
    protected AMQSession _session;
    private final boolean _immediate;
    private final boolean _mandatory;
    private final boolean _waitUntilSent;
    private boolean _disableMessageId;
    private UUIDGen _messageIdGenerator = UUIDs.newGenerator();
    protected String _userID;
    private static final ContentBody[] NO_CONTENT_BODIES = new ContentBody[0];
    protected PublishMode publishMode = PublishMode.ASYNC_PUBLISH_ALL;

    protected BasicMessageProducer(AMQConnection connection, AMQDestination destination, boolean transacted, int channelId, AMQSession session, AMQProtocolHandler protocolHandler, long producerId, boolean immediate, boolean mandatory, boolean waitUntilSent) throws AMQException {
        this._connection = connection;
        this._destination = destination;
        this._transacted = transacted;
        this._protocolHandler = protocolHandler;
        this._channelId = channelId;
        this._session = session;
        this._producerId = producerId;
        if (destination != null && !(destination instanceof AMQUndefinedDestination)) {
            this.declareDestination(destination);
        }
        this._immediate = immediate;
        this._mandatory = mandatory;
        this._waitUntilSent = waitUntilSent;
        this._userID = connection.getUsername();
        this.setPublishMode();
    }

    void setPublishMode() {
        String syncPub = this._connection.getSyncPublish();
        if (syncPub.equals("persistent") || this._connection.getSyncPersistence()) {
            this.publishMode = PublishMode.SYNC_PUBLISH_PERSISTENT;
        } else if (syncPub.equals("all")) {
            this.publishMode = PublishMode.SYNC_PUBLISH_ALL;
        }
        this._logger.info("MessageProducer " + this.toString() + " using publish mode : " + (Object)((Object)this.publishMode));
    }

    void resubscribe() throws AMQException {
        if (this._destination != null && !(this._destination instanceof AMQUndefinedDestination)) {
            this.declareDestination(this._destination);
        }
    }

    abstract void declareDestination(AMQDestination var1) throws AMQException;

    public void setDisableMessageID(boolean b) throws JMSException {
        this.checkPreConditions();
        this.checkNotClosed();
        this._disableMessageId = b;
    }

    public boolean getDisableMessageID() throws JMSException {
        this.checkNotClosed();
        return this._disableMessageId;
    }

    public void setDisableMessageTimestamp(boolean b) throws JMSException {
        this.checkPreConditions();
        this._disableTimestamps = b;
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        this.checkNotClosed();
        return this._disableTimestamps;
    }

    public void setDeliveryMode(int i) throws JMSException {
        this.checkPreConditions();
        if (i != 1 && i != 2) {
            throw new JMSException("DeliveryMode must be either NON_PERSISTENT or PERSISTENT. Value of " + i + " is illegal");
        }
        this._deliveryMode = i;
    }

    public int getDeliveryMode() throws JMSException {
        this.checkNotClosed();
        return this._deliveryMode;
    }

    public void setPriority(int i) throws JMSException {
        this.checkPreConditions();
        if (i < 0 || i > 9) {
            throw new IllegalArgumentException("Priority of " + i + " is illegal. Value must be in range 0 to 9");
        }
        this._messagePriority = i;
    }

    public int getPriority() throws JMSException {
        this.checkNotClosed();
        return this._messagePriority;
    }

    public void setTimeToLive(long l) throws JMSException {
        this.checkPreConditions();
        if (l < 0L) {
            throw new IllegalArgumentException("Time to live must be non-negative - supplied value was " + l);
        }
        this._timeToLive = l;
    }

    public long getTimeToLive() throws JMSException {
        this.checkNotClosed();
        return this._timeToLive;
    }

    public Destination getDestination() throws JMSException {
        this.checkNotClosed();
        return this._destination;
    }

    public void close() {
        this._closed.set(true);
        this._session.deregisterProducer(this._producerId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Message message) throws JMSException {
        this.checkPreConditions();
        this.checkInitialDestination();
        Object object = this._connection.getFailoverMutex();
        synchronized (object) {
            this.sendImpl(this._destination, message, this._deliveryMode, this._messagePriority, this._timeToLive, this._mandatory, this._immediate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Message message, int deliveryMode) throws JMSException {
        this.checkPreConditions();
        this.checkInitialDestination();
        Object object = this._connection.getFailoverMutex();
        synchronized (object) {
            this.sendImpl(this._destination, message, deliveryMode, this._messagePriority, this._timeToLive, this._mandatory, this._immediate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Message message, int deliveryMode, boolean immediate) throws JMSException {
        this.checkPreConditions();
        this.checkInitialDestination();
        Object object = this._connection.getFailoverMutex();
        synchronized (object) {
            this.sendImpl(this._destination, message, deliveryMode, this._messagePriority, this._timeToLive, this._mandatory, immediate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.checkPreConditions();
        this.checkInitialDestination();
        Object object = this._connection.getFailoverMutex();
        synchronized (object) {
            this.sendImpl(this._destination, message, deliveryMode, priority, timeToLive, this._mandatory, this._immediate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Destination destination, Message message) throws JMSException {
        this.checkPreConditions();
        this.checkDestination(destination);
        Object object = this._connection.getFailoverMutex();
        synchronized (object) {
            this.validateDestination(destination);
            this.sendImpl((AMQDestination)destination, message, this._deliveryMode, this._messagePriority, this._timeToLive, this._mandatory, this._immediate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.checkPreConditions();
        this.checkDestination(destination);
        Object object = this._connection.getFailoverMutex();
        synchronized (object) {
            this.validateDestination(destination);
            this.sendImpl((AMQDestination)destination, message, deliveryMode, priority, timeToLive, this._mandatory, this._immediate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive, boolean mandatory) throws JMSException {
        this.checkPreConditions();
        this.checkDestination(destination);
        Object object = this._connection.getFailoverMutex();
        synchronized (object) {
            this.validateDestination(destination);
            this.sendImpl((AMQDestination)destination, message, deliveryMode, priority, timeToLive, mandatory, this._immediate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive, boolean mandatory, boolean immediate) throws JMSException {
        this.checkPreConditions();
        this.checkDestination(destination);
        Object object = this._connection.getFailoverMutex();
        synchronized (object) {
            this.validateDestination(destination);
            this.sendImpl((AMQDestination)destination, message, deliveryMode, priority, timeToLive, mandatory, immediate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive, boolean mandatory, boolean immediate, boolean waitUntilSent) throws JMSException {
        this.checkPreConditions();
        this.checkDestination(destination);
        Object object = this._connection.getFailoverMutex();
        synchronized (object) {
            this.validateDestination(destination);
            this.sendImpl((AMQDestination)destination, message, deliveryMode, priority, timeToLive, mandatory, immediate, waitUntilSent);
        }
    }

    private AbstractJMSMessage convertToNativeMessage(Message message) throws JMSException {
        if (message instanceof AbstractJMSMessage) {
            return (AbstractJMSMessage)message;
        }
        AbstractJMSMessage newMessage = message instanceof BytesMessage ? new MessageConverter(this._session, (BytesMessage)message).getConvertedMessage() : (message instanceof MapMessage ? new MessageConverter(this._session, (MapMessage)message).getConvertedMessage() : (message instanceof ObjectMessage ? new MessageConverter(this._session, (ObjectMessage)message).getConvertedMessage() : (message instanceof TextMessage ? new MessageConverter(this._session, (TextMessage)message).getConvertedMessage() : (message instanceof StreamMessage ? new MessageConverter(this._session, (StreamMessage)message).getConvertedMessage() : new MessageConverter(this._session, message).getConvertedMessage()))));
        if (newMessage != null) {
            return newMessage;
        }
        throw new JMSException("Unable to send message, due to class conversion error: " + message.getClass().getName());
    }

    private void validateDestination(Destination destination) throws JMSException {
        if (!(destination instanceof AMQDestination)) {
            throw new JMSException("Unsupported destination class: " + (destination != null ? destination.getClass() : null));
        }
        AMQDestination amqDestination = (AMQDestination)destination;
        if (!amqDestination.isExchangeExistsChecked()) {
            try {
                this.declareDestination(amqDestination);
            }
            catch (Exception e) {
                JMSException ex = new JMSException("Error validating destination");
                ex.initCause(e);
                ex.setLinkedException(e);
                throw ex;
            }
            amqDestination.setExchangeExistsChecked(true);
        }
    }

    protected void sendImpl(AMQDestination destination, Message message, int deliveryMode, int priority, long timeToLive, boolean mandatory, boolean immediate) throws JMSException {
        this.sendImpl(destination, message, deliveryMode, priority, timeToLive, mandatory, immediate, this._waitUntilSent);
    }

    protected void sendImpl(AMQDestination destination, Message origMessage, int deliveryMode, int priority, long timeToLive, boolean mandatory, boolean immediate, boolean wait) throws JMSException {
        this.checkTemporaryDestination(destination);
        origMessage.setJMSDestination(destination);
        AbstractJMSMessage message = this.convertToNativeMessage(origMessage);
        if (this._transacted && this._session.hasFailedOver() && this._session.isDirty()) {
            throw new JMSAMQException("Failover has occurred and session is dirty so unable to send.", new AMQSessionDirtyException("Failover has occurred and session is dirty so unable to send."));
        }
        UUID messageId = null;
        if (this._disableMessageId) {
            message.setJMSMessageID((UUID)null);
        } else {
            messageId = this._messageIdGenerator.generate();
            message.setJMSMessageID(messageId);
        }
        this.sendMessage(destination, origMessage, message, messageId, deliveryMode, priority, timeToLive, mandatory, immediate, wait);
        if (message != origMessage) {
            this._logger.debug("Updating original message");
            origMessage.setJMSPriority(message.getJMSPriority());
            origMessage.setJMSTimestamp(message.getJMSTimestamp());
            this._logger.debug("Setting JMSExpiration:" + message.getJMSExpiration());
            origMessage.setJMSExpiration(message.getJMSExpiration());
            origMessage.setJMSMessageID(message.getJMSMessageID());
        }
        if (this._transacted) {
            this._session.markDirty();
        }
    }

    abstract void sendMessage(AMQDestination var1, Message var2, AbstractJMSMessage var3, UUID var4, int var5, int var6, long var7, boolean var9, boolean var10, boolean var11) throws JMSException;

    private void checkTemporaryDestination(AMQDestination destination) throws JMSException {
        if (destination instanceof TemporaryDestination) {
            this._logger.debug("destination is temporary destination");
            TemporaryDestination tempDest = (TemporaryDestination)((Object)destination);
            if (tempDest.getSession().isClosed()) {
                this._logger.debug("session is closed");
                throw new JMSException("Session for temporary destination has been closed");
            }
            if (tempDest.isDeleted()) {
                this._logger.debug("destination is deleted");
                throw new JMSException("Cannot send to a deleted temporary destination");
            }
        }
    }

    public void setMimeType(String mimeType) throws JMSException {
        this.checkNotClosed();
        this._mimeType = mimeType;
    }

    public void setEncoding(String encoding) throws JMSException, UnsupportedEncodingException {
        this.checkNotClosed();
        this._encoding = encoding;
    }

    private void checkPreConditions() throws IllegalStateException, JMSException {
        this.checkNotClosed();
        if (this._session == null || this._session.isClosed()) {
            throw new IllegalStateException("Invalid Session");
        }
        if (this._session.getAMQConnection().isClosed()) {
            throw new IllegalStateException("Connection closed");
        }
    }

    private void checkInitialDestination() {
        if (this._destination == null) {
            throw new UnsupportedOperationException("Destination is null");
        }
    }

    private void checkDestination(Destination suppliedDestination) throws InvalidDestinationException {
        if (this._destination != null && suppliedDestination != null) {
            throw new UnsupportedOperationException("This message producer was created with a Destination, therefore you cannot use an unidentified Destination");
        }
        if (suppliedDestination == null) {
            throw new InvalidDestinationException("Supplied Destination was invalid");
        }
    }

    public AMQSession getSession() {
        return this._session;
    }

    public boolean isBound(AMQDestination destination) throws JMSException {
        return this._session.isQueueBound(destination.getExchangeName(), null, destination.getRoutingKey());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum PublishMode {
        ASYNC_PUBLISH_ALL,
        SYNC_PUBLISH_PERSISTENT,
        SYNC_PUBLISH_ALL;

    }
}

