/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.nio.channels.UnresolvedAddressException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import org.apache.qpid.AMQConnectionFailureException;
import org.apache.qpid.AMQDisconnectedException;
import org.apache.qpid.AMQException;
import org.apache.qpid.AMQProtocolException;
import org.apache.qpid.AMQUnresolvedAddressException;
import org.apache.qpid.client.AMQBrokerDetails;
import org.apache.qpid.client.AMQConnectionDelegate;
import org.apache.qpid.client.AMQConnectionDelegate_0_10;
import org.apache.qpid.client.AMQConnectionDelegate_0_9;
import org.apache.qpid.client.AMQConnectionDelegate_8_0;
import org.apache.qpid.client.AMQConnectionDelegate_9_1;
import org.apache.qpid.client.AMQConnectionFactory;
import org.apache.qpid.client.AMQConnectionURL;
import org.apache.qpid.client.AMQQueueSessionAdaptor;
import org.apache.qpid.client.AMQSession;
import org.apache.qpid.client.AMQTopicSessionAdaptor;
import org.apache.qpid.client.ChannelToSessionMap;
import org.apache.qpid.client.Closeable;
import org.apache.qpid.client.JMSAMQException;
import org.apache.qpid.client.QpidConnectionMetaData;
import org.apache.qpid.client.SSLConfiguration;
import org.apache.qpid.client.failover.FailoverException;
import org.apache.qpid.client.failover.FailoverProtectedOperation;
import org.apache.qpid.client.protocol.AMQProtocolHandler;
import org.apache.qpid.exchange.ExchangeDefaults;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.BasicQosBody;
import org.apache.qpid.framing.BasicQosOkBody;
import org.apache.qpid.framing.ChannelOpenBody;
import org.apache.qpid.framing.ChannelOpenOkBody;
import org.apache.qpid.framing.ProtocolVersion;
import org.apache.qpid.framing.TxSelectBody;
import org.apache.qpid.framing.TxSelectOkBody;
import org.apache.qpid.jms.BrokerDetails;
import org.apache.qpid.jms.Connection;
import org.apache.qpid.jms.ConnectionListener;
import org.apache.qpid.jms.ConnectionURL;
import org.apache.qpid.jms.FailoverPolicy;
import org.apache.qpid.jms.Session;
import org.apache.qpid.protocol.AMQConstant;
import org.apache.qpid.url.URLSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AMQConnection
extends Closeable
implements Connection,
QueueConnection,
TopicConnection,
Referenceable {
    private static final Logger _logger = LoggerFactory.getLogger(AMQConnection.class);
    private final Object _failoverMutex = new Object();
    private final Object _sessionCreationLock = new Object();
    private long _maximumChannelCount;
    private long _maximumFrameSize;
    protected AMQProtocolHandler _protocolHandler;
    private final ChannelToSessionMap _sessions = new ChannelToSessionMap();
    private String _clientName;
    private String _username;
    private String _password;
    private String _virtualHost;
    protected ExceptionListener _exceptionListener;
    private ConnectionListener _connectionListener;
    private ConnectionURL _connectionURL;
    protected volatile boolean _started;
    protected FailoverPolicy _failoverPolicy;
    protected boolean _connected;
    private QpidConnectionMetaData _connectionMetaData;
    private SSLConfiguration _sslConfiguration;
    private AMQShortString _defaultTopicExchangeName = ExchangeDefaults.TOPIC_EXCHANGE_NAME;
    private AMQShortString _defaultQueueExchangeName = ExchangeDefaults.DIRECT_EXCHANGE_NAME;
    private AMQShortString _temporaryTopicExchangeName = ExchangeDefaults.TOPIC_EXCHANGE_NAME;
    private AMQShortString _temporaryQueueExchangeName = ExchangeDefaults.DIRECT_EXCHANGE_NAME;
    private final ExecutorService _taskPool = Executors.newCachedThreadPool();
    private static final long DEFAULT_TIMEOUT = 30000L;
    protected AMQConnectionDelegate _delegate;
    private int _maxPrefetch;
    private boolean _syncPersistence;
    private boolean _syncAck;
    private String _syncPublish = "";
    private boolean _useLegacyMapMessageFormat;

    public AMQConnection(String broker, String username, String password, String clientName, String virtualHost) throws AMQException, URLSyntaxException {
        this(new AMQConnectionURL("amqp://" + username + ":" + password + "@" + (clientName == null ? "" : clientName) + "/" + virtualHost + "?brokerlist='" + AMQBrokerDetails.checkTransport(broker) + "'"), null);
    }

    public AMQConnection(String broker, String username, String password, String clientName, String virtualHost, SSLConfiguration sslConfig) throws AMQException, URLSyntaxException {
        this(new AMQConnectionURL("amqp://" + username + ":" + password + "@" + (clientName == null ? "" : clientName) + "/" + virtualHost + "?brokerlist='" + AMQBrokerDetails.checkTransport(broker) + "'"), sslConfig);
    }

    public AMQConnection(String host, int port, String username, String password, String clientName, String virtualHost) throws AMQException, URLSyntaxException {
        this(host, port, false, username, password, clientName, virtualHost, null);
    }

    public AMQConnection(String host, int port, String username, String password, String clientName, String virtualHost, SSLConfiguration sslConfig) throws AMQException, URLSyntaxException {
        this(host, port, false, username, password, clientName, virtualHost, sslConfig);
    }

    public AMQConnection(String host, int port, boolean useSSL, String username, String password, String clientName, String virtualHost, SSLConfiguration sslConfig) throws AMQException, URLSyntaxException {
        this(new AMQConnectionURL(useSSL ? "amqp://" + username + ":" + password + "@" + (clientName == null ? "" : clientName) + virtualHost + "?brokerlist='tcp://" + host + ":" + port + "'" + "," + "ssl" + "='true'" : "amqp://" + username + ":" + password + "@" + (clientName == null ? "" : clientName) + virtualHost + "?brokerlist='tcp://" + host + ":" + port + "'" + "," + "ssl" + "='false'"), sslConfig);
    }

    public AMQConnection(String connection) throws AMQException, URLSyntaxException {
        this(new AMQConnectionURL(connection), null);
    }

    public AMQConnection(String connection, SSLConfiguration sslConfig) throws AMQException, URLSyntaxException {
        this(new AMQConnectionURL(connection), sslConfig);
    }

    public AMQConnection(ConnectionURL connectionURL, SSLConfiguration sslConfig) throws AMQException {
        this._maxPrefetch = connectionURL.getOption("maxprefetch") != null ? Integer.parseInt(connectionURL.getOption("maxprefetch")) : Integer.parseInt(System.getProperties().getProperty("max_prefetch", "500"));
        if (connectionURL.getOption("sync_persistence") != null) {
            this._syncPersistence = Boolean.parseBoolean(connectionURL.getOption("sync_persistence"));
            _logger.warn("sync_persistence is a deprecated property, please use sync_publish={persistent|all} instead");
        } else {
            this._syncPersistence = Boolean.getBoolean("sync_persistence");
            if (this._syncPersistence) {
                _logger.warn("sync_persistence is a deprecated property, please use sync_publish={persistent|all} instead");
            }
        }
        this._syncAck = connectionURL.getOption("sync_ack") != null ? Boolean.parseBoolean(connectionURL.getOption("sync_ack")) : Boolean.getBoolean("sync_ack");
        this._syncPublish = connectionURL.getOption("sync_publish") != null ? connectionURL.getOption("sync_publish") : System.getProperty("sync_publish", this._syncPublish);
        this._useLegacyMapMessageFormat = connectionURL.getOption("use_legacy_map_msg_format") != null ? Boolean.parseBoolean(connectionURL.getOption("use_legacy_map_msg_format")) : Boolean.getBoolean("qpid.use_legacy_map_message");
        String amqpVersion = System.getProperty("qpid.amqp.version", "0-10");
        _logger.debug("AMQP version " + amqpVersion);
        this._failoverPolicy = new FailoverPolicy(connectionURL, this);
        BrokerDetails brokerDetails = this._failoverPolicy.getCurrentBrokerDetails();
        this._delegate = brokerDetails.getTransport().equals("vm") || "0-8".equals(amqpVersion) ? new AMQConnectionDelegate_8_0(this) : ("0-9".equals(amqpVersion) ? new AMQConnectionDelegate_0_9(this) : ("0-91".equals(amqpVersion) || "0-9-1".equals(amqpVersion) ? new AMQConnectionDelegate_9_1(this) : new AMQConnectionDelegate_0_10(this)));
        if (_logger.isInfoEnabled()) {
            _logger.info("Connection:" + connectionURL);
        }
        this._sslConfiguration = sslConfig;
        if (connectionURL == null) {
            throw new IllegalArgumentException("Connection must be specified");
        }
        this._connectionURL = connectionURL;
        this._clientName = connectionURL.getClientName();
        this._username = connectionURL.getUsername();
        this._password = connectionURL.getPassword();
        this.setVirtualHost(connectionURL.getVirtualHost());
        if (connectionURL.getDefaultQueueExchangeName() != null) {
            this._defaultQueueExchangeName = connectionURL.getDefaultQueueExchangeName();
        }
        if (connectionURL.getDefaultTopicExchangeName() != null) {
            this._defaultTopicExchangeName = connectionURL.getDefaultTopicExchangeName();
        }
        if (connectionURL.getTemporaryQueueExchangeName() != null) {
            this._temporaryQueueExchangeName = connectionURL.getTemporaryQueueExchangeName();
        }
        if (connectionURL.getTemporaryTopicExchangeName() != null) {
            this._temporaryTopicExchangeName = connectionURL.getTemporaryTopicExchangeName();
        }
        this._protocolHandler = new AMQProtocolHandler(this);
        _logger.info("Connecting with ProtocolHandler Version:" + this._protocolHandler.getProtocolVersion());
        this._connected = false;
        boolean retryAllowed = true;
        Exception connectionException = null;
        while (!this._connected && retryAllowed && brokerDetails != null) {
            ProtocolVersion pe = null;
            try {
                pe = this.makeBrokerConnection(brokerDetails);
            }
            catch (Exception e) {
                if (_logger.isInfoEnabled()) {
                    _logger.info("Unable to connect to broker at " + this._failoverPolicy.getCurrentBrokerDetails(), (Throwable)e);
                }
                connectionException = e;
            }
            if (pe != null) {
                this.initDelegate(pe);
                continue;
            }
            if (this._connected) continue;
            retryAllowed = this._failoverPolicy.failoverAllowed();
            brokerDetails = this._failoverPolicy.getNextBrokerDetails();
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("Are we connected:" + this._connected);
        }
        if (!this._connected) {
            if (_logger.isDebugEnabled()) {
                _logger.debug("Last attempted ProtocolHandler Version:" + this._protocolHandler.getProtocolVersion());
            }
            String message = null;
            if (connectionException != null) {
                message = connectionException.getCause() != null ? connectionException.getCause().getMessage() : connectionException.getMessage();
            }
            if (message == null || message.equals("")) {
                message = message == null ? "Unable to Connect" : "Unable to Connect:" + connectionException.getClass();
            }
            for (Throwable th = connectionException; th != null; th = th.getCause()) {
                if (!(th instanceof UnresolvedAddressException) && !(th instanceof UnknownHostException)) continue;
                throw new AMQUnresolvedAddressException(message, ((Object)this._failoverPolicy.getCurrentBrokerDetails()).toString(), (Throwable)connectionException);
            }
            throw new AMQConnectionFailureException(message, connectionException);
        }
        _logger.info("Connected with ProtocolHandler Version:" + this._protocolHandler.getProtocolVersion());
        this._sessions.setMaxChannelID(this._delegate.getMaxChannelID());
        this._sessions.setMinChannelID(this._delegate.getMinChannelID());
        this._connectionMetaData = new QpidConnectionMetaData(this);
    }

    protected boolean checkException(Throwable thrown) {
        Throwable cause = thrown.getCause();
        if (cause == null) {
            cause = thrown;
        }
        return cause instanceof ConnectException || cause instanceof UnresolvedAddressException;
    }

    private void initDelegate(ProtocolVersion pe) throws AMQProtocolException {
        try {
            String delegateClassName = String.format("org.apache.qpid.client.AMQConnectionDelegate_%s_%s", pe.getMajorVersion(), pe.getMinorVersion());
            _logger.info("Looking up delegate '" + delegateClassName + "' Based on PE:" + pe);
            Class<?> c = Class.forName(delegateClassName);
            Class[] partypes = new Class[]{AMQConnection.class};
            this._delegate = (AMQConnectionDelegate)c.getConstructor(partypes).newInstance(this);
            this._protocolHandler.getProtocolSession().setProtocolVersion(this._delegate.getProtocolVersion());
        }
        catch (ClassNotFoundException e) {
            throw new AMQProtocolException(AMQConstant.UNSUPPORTED_CLIENT_PROTOCOL_ERROR, String.format("Protocol: %s.%s is rquired by the broker but is not currently supported by this client library implementation", pe.getMajorVersion(), pe.getMinorVersion()), e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("unable to locate constructor for delegate", e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("error instantiating delegate", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("error accessing delegate", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("error invoking delegate", e);
        }
    }

    protected AMQConnection(String username, String password, String clientName, String virtualHost) {
        this._clientName = clientName;
        this._username = username;
        this._password = password;
        this.setVirtualHost(virtualHost);
    }

    private void setVirtualHost(String virtualHost) {
        if (virtualHost != null && virtualHost.startsWith("/")) {
            virtualHost = virtualHost.substring(1);
        }
        this._virtualHost = virtualHost;
    }

    public boolean attemptReconnection(String host, int port) {
        AMQBrokerDetails bd = new AMQBrokerDetails(host, port, this._sslConfiguration);
        this._failoverPolicy.setBroker(bd);
        try {
            this.makeBrokerConnection(bd);
            return true;
        }
        catch (Exception e) {
            if (_logger.isInfoEnabled()) {
                _logger.info("Unable to connect to broker at " + bd);
            }
            this.attemptReconnection();
            return false;
        }
    }

    public boolean attemptReconnection() {
        BrokerDetails broker = null;
        while (this._failoverPolicy.failoverAllowed() && (broker = this._failoverPolicy.getNextBrokerDetails()) != null) {
            try {
                this.makeBrokerConnection(broker);
                return true;
            }
            catch (Exception e) {
                if (!(e instanceof AMQException)) {
                    if (!_logger.isInfoEnabled()) continue;
                    _logger.info("Unable to connect to broker at " + this._failoverPolicy.getCurrentBrokerDetails(), (Throwable)e);
                    continue;
                }
                if (!_logger.isInfoEnabled()) continue;
                _logger.info(e.getMessage() + ":Unable to connect to broker at " + this._failoverPolicy.getCurrentBrokerDetails());
            }
        }
        return false;
    }

    public ProtocolVersion makeBrokerConnection(BrokerDetails brokerDetail) throws IOException, AMQException {
        return this._delegate.makeBrokerConnection(brokerDetail);
    }

    public <T, E extends Exception> T executeRetrySupport(FailoverProtectedOperation<T, E> operation) throws E {
        return this._delegate.executeRetrySupport(operation);
    }

    public BrokerDetails getActiveBrokerDetails() {
        return this._failoverPolicy.getCurrentBrokerDetails();
    }

    public boolean failoverAllowed() {
        if (!this._connected) {
            return false;
        }
        return this._failoverPolicy.failoverAllowed();
    }

    @Override
    public Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        return this.createSession(transacted, acknowledgeMode, this._maxPrefetch);
    }

    @Override
    public Session createSession(boolean transacted, int acknowledgeMode, int prefetch) throws JMSException {
        return this.createSession(transacted, acknowledgeMode, prefetch, prefetch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Session createSession(boolean transacted, int acknowledgeMode, int prefetchHigh, int prefetchLow) throws JMSException {
        Object object = this._sessionCreationLock;
        synchronized (object) {
            this.checkNotClosed();
            return this._delegate.createSession(transacted, acknowledgeMode, prefetchHigh, prefetchLow);
        }
    }

    private void createChannelOverWire(int channelId, int prefetchHigh, int prefetchLow, boolean transacted) throws AMQException, FailoverException {
        ChannelOpenBody channelOpenBody = this.getProtocolHandler().getMethodRegistry().createChannelOpenBody(null);
        this._protocolHandler.syncWrite(channelOpenBody.generateFrame(channelId), ChannelOpenOkBody.class);
        BasicQosBody basicQosBody = this.getProtocolHandler().getMethodRegistry().createBasicQosBody(0L, prefetchHigh, false);
        this._protocolHandler.syncWrite(basicQosBody.generateFrame(channelId), BasicQosOkBody.class);
        if (transacted) {
            if (_logger.isDebugEnabled()) {
                _logger.debug("Issuing TxSelect for " + channelId);
            }
            TxSelectBody body = this.getProtocolHandler().getMethodRegistry().createTxSelectBody();
            this._protocolHandler.syncWrite(body.generateFrame(channelId), TxSelectOkBody.class);
        }
    }

    private void reopenChannel(int channelId, int prefetchHigh, int prefetchLow, boolean transacted) throws AMQException, FailoverException {
        try {
            this.createChannelOverWire(channelId, prefetchHigh, prefetchLow, transacted);
        }
        catch (AMQException e) {
            this.deregisterSession(channelId);
            throw new AMQException(null, "Error reopening channel " + channelId + " after failover: " + e, e);
        }
    }

    public void setFailoverPolicy(FailoverPolicy policy) {
        this._failoverPolicy = policy;
    }

    public FailoverPolicy getFailoverPolicy() {
        return this._failoverPolicy;
    }

    @Override
    public QueueSession createQueueSession(boolean transacted, int acknowledgeMode) throws JMSException {
        return new AMQQueueSessionAdaptor(this.createSession(transacted, acknowledgeMode));
    }

    @Override
    public TopicSession createTopicSession(boolean transacted, int acknowledgeMode) throws JMSException {
        return new AMQTopicSessionAdaptor(this.createSession(transacted, acknowledgeMode));
    }

    public boolean channelLimitReached() {
        return (long)this._sessions.size() >= this._maximumChannelCount;
    }

    @Override
    public String getClientID() throws JMSException {
        this.checkNotClosed();
        return this._clientName;
    }

    @Override
    public void setClientID(String clientID) throws JMSException {
        this.checkNotClosed();
        if (!Boolean.getBoolean("ignore_setclientID")) {
            throw new IllegalStateException("Client name cannot be changed after being set");
        }
        _logger.info("Operation setClientID is ignored using ID: " + this.getClientID());
    }

    @Override
    public ConnectionMetaData getMetaData() throws JMSException {
        this.checkNotClosed();
        return this._connectionMetaData;
    }

    @Override
    public ExceptionListener getExceptionListener() throws JMSException {
        this.checkNotClosed();
        return this._exceptionListener;
    }

    @Override
    public void setExceptionListener(ExceptionListener listener) throws JMSException {
        this.checkNotClosed();
        this._exceptionListener = listener;
    }

    @Override
    public void start() throws JMSException {
        this.checkNotClosed();
        if (!this._started) {
            this._started = true;
            for (AMQSession s : this._sessions.values()) {
                try {
                    s.start();
                }
                catch (AMQException e) {
                    throw new JMSAMQException(e);
                }
            }
        }
    }

    @Override
    public void stop() throws JMSException {
        this.checkNotClosed();
        if (this._started) {
            Iterator<AMQSession> i = this._sessions.values().iterator();
            while (i.hasNext()) {
                try {
                    i.next().stop();
                }
                catch (AMQException e) {
                    throw new JMSAMQException(e);
                }
            }
            this._started = false;
        }
    }

    @Override
    public void close() throws JMSException {
        this.close(30000L);
    }

    public void close(long timeout) throws JMSException {
        this.close(new ArrayList<AMQSession>(this._sessions.values()), timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(List<AMQSession> sessions, long timeout) throws JMSException {
        if (!this._closed.getAndSet(true)) {
            this._closing.set(true);
            try {
                this.doClose(sessions, timeout);
            }
            finally {
                this._closing.set(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doClose(List<AMQSession> sessions, long timeout) throws JMSException {
        Object object = this._sessionCreationLock;
        synchronized (object) {
            if (!sessions.isEmpty()) {
                AMQSession session = sessions.remove(0);
                Object object2 = session.getMessageDeliveryLock();
                synchronized (object2) {
                    this.doClose(sessions, timeout);
                }
            }
            Object object3 = this.getFailoverMutex();
            synchronized (object3) {
                try {
                    long startCloseTime = System.currentTimeMillis();
                    this.closeAllSessions(null, timeout, startCloseTime);
                    this._taskPool.shutdown();
                    if (!this._taskPool.isTerminated()) {
                        try {
                            long taskPoolTimeout = this.adjustTimeout(timeout, startCloseTime);
                            this._taskPool.awaitTermination(taskPoolTimeout, TimeUnit.MILLISECONDS);
                        }
                        catch (InterruptedException e) {
                            _logger.info("Interrupted while shutting down connection thread pool.");
                        }
                    }
                    timeout = this.adjustTimeout(timeout, startCloseTime);
                    this._delegate.closeConnection(timeout);
                    if (!this._taskPool.isTerminated()) {
                        List<Runnable> tasks = this._taskPool.shutdownNow();
                        for (Runnable r : tasks) {
                            _logger.warn("Connection close forced taskpool to prevent execution:" + r);
                        }
                    }
                }
                catch (AMQException e) {
                    _logger.error("error:", (Throwable)e);
                    JMSException jmse = new JMSException("Error closing connection: " + e);
                    jmse.setLinkedException(e);
                    jmse.initCause(e);
                    throw jmse;
                }
            }
        }
    }

    private long adjustTimeout(long timeout, long startTime) {
        long now = System.currentTimeMillis();
        if ((timeout -= now - startTime) < 0L) {
            timeout = 0L;
        }
        return timeout;
    }

    private void markAllSessionsClosed() {
        LinkedList<AMQSession> sessionCopy = new LinkedList<AMQSession>(this._sessions.values());
        for (AMQSession session : sessionCopy) {
            session.markClosed();
        }
        this._sessions.clear();
    }

    private void closeAllSessions(Throwable cause, long timeout, long starttime) throws JMSException {
        LinkedList<AMQSession> sessionCopy = new LinkedList<AMQSession>(this._sessions.values());
        Iterator it = sessionCopy.iterator();
        JMSException sessionException = null;
        while (it.hasNext()) {
            AMQSession session = (AMQSession)it.next();
            if (cause != null) {
                session.closed(cause);
                continue;
            }
            try {
                if (starttime != -1L) {
                    timeout = this.adjustTimeout(timeout, starttime);
                }
                session.close(timeout);
            }
            catch (JMSException e) {
                _logger.error("Error closing session: " + e);
                sessionException = e;
            }
        }
        this._sessions.clear();
        if (sessionException != null) {
            throw sessionException;
        }
    }

    @Override
    public ConnectionConsumer createConnectionConsumer(Destination destination, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        this.checkNotClosed();
        return null;
    }

    @Override
    public ConnectionConsumer createConnectionConsumer(Queue queue, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        this.checkNotClosed();
        return null;
    }

    @Override
    public ConnectionConsumer createConnectionConsumer(Topic topic, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        this.checkNotClosed();
        return null;
    }

    @Override
    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        this.checkNotClosed();
        return null;
    }

    @Override
    public long getMaximumChannelCount() throws JMSException {
        this.checkNotClosed();
        return this._maximumChannelCount;
    }

    @Override
    public void setConnectionListener(ConnectionListener listener) {
        this._connectionListener = listener;
    }

    @Override
    public ConnectionListener getConnectionListener() {
        return this._connectionListener;
    }

    public void setMaximumChannelCount(long maximumChannelCount) {
        this._maximumChannelCount = maximumChannelCount;
    }

    public void setMaximumFrameSize(long frameMax) {
        this._maximumFrameSize = frameMax;
    }

    public long getMaximumFrameSize() {
        return this._maximumFrameSize;
    }

    public ChannelToSessionMap getSessions() {
        return this._sessions;
    }

    public String getUsername() {
        return this._username;
    }

    public void setUsername(String id) {
        this._username = id;
    }

    public String getPassword() {
        return this._password;
    }

    public String getVirtualHost() {
        return this._virtualHost;
    }

    public AMQProtocolHandler getProtocolHandler() {
        return this._protocolHandler;
    }

    public boolean started() {
        return this._started;
    }

    public void bytesSent(long writtenBytes) {
        if (this._connectionListener != null) {
            this._connectionListener.bytesSent(writtenBytes);
        }
    }

    public void bytesReceived(long receivedBytes) {
        if (this._connectionListener != null) {
            this._connectionListener.bytesReceived(receivedBytes);
        }
    }

    public boolean firePreFailover(boolean redirect) {
        boolean proceed = true;
        if (this._connectionListener != null) {
            proceed = this._connectionListener.preFailover(redirect);
        }
        return proceed;
    }

    public boolean firePreResubscribe() throws JMSException {
        if (this._connectionListener != null) {
            boolean resubscribe = this._connectionListener.preResubscribe();
            if (!resubscribe) {
                this.markAllSessionsClosed();
            }
            return resubscribe;
        }
        return true;
    }

    public void fireFailoverComplete() {
        if (this._connectionListener != null) {
            this._connectionListener.failoverComplete();
        }
    }

    public final Object getFailoverMutex() {
        return this._failoverMutex;
    }

    public void failoverPrep() {
        this._delegate.failoverPrep();
    }

    public void resubscribeSessions() throws JMSException, AMQException, FailoverException {
        this._delegate.resubscribeSessions();
    }

    public void blockUntilNotFailingOver() throws InterruptedException {
        this._protocolHandler.blockUntilNotFailingOver();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exceptionReceived(Throwable cause) {
        JMSException je;
        if (_logger.isDebugEnabled()) {
            _logger.debug("exceptionReceived done by:" + Thread.currentThread().getName(), cause);
        }
        if (cause instanceof JMSException) {
            je = (JMSException)cause;
        } else {
            AMQConstant code = null;
            if (cause instanceof AMQException) {
                code = ((AMQException)cause).getErrorCode();
            }
            if (code != null) {
                je = new JMSException(Integer.toString(code.getCode()), "Exception thrown against " + this.toString() + ": " + cause);
            } else {
                Exception last;
                if (cause instanceof AMQDisconnectedException && (last = this._protocolHandler.getStateManager().getLastException()) != null) {
                    _logger.info("StateManager had an exception for us to use a cause of our Disconnected Exception");
                    cause = last;
                }
                je = new JMSException("Exception thrown against " + this.toString() + ": " + cause);
            }
            if (cause instanceof Exception) {
                je.setLinkedException((Exception)cause);
            }
            je.initCause(cause);
        }
        boolean closer = false;
        if (cause instanceof IOException || cause instanceof AMQDisconnectedException) {
            this._closing.set(false);
            closer = !this._closed.getAndSet(true);
            this._protocolHandler.getProtocolSession().notifyError(je);
        }
        Object object = this.getFailoverMutex();
        synchronized (object) {
            if (this.hardError(cause)) {
                closer = !this._closed.getAndSet(true) || closer;
                _logger.info("Closing AMQConnection due to :" + cause);
            } else {
                _logger.info("Not a hard-error connection not closing: " + cause);
            }
            if (this._exceptionListener != null) {
                this._exceptionListener.onException(je);
            } else {
                _logger.error("Throwable Received but no listener set: " + cause);
            }
            if (closer) {
                try {
                    this.closeAllSessions(cause, -1L, -1L);
                }
                catch (JMSException e) {
                    _logger.error("Error closing all sessions: " + e, (Throwable)e);
                }
            }
        }
    }

    private boolean hardError(Throwable cause) {
        if (cause instanceof AMQException) {
            return ((AMQException)cause).isHardError();
        }
        return true;
    }

    void registerSession(int channelId, AMQSession session) {
        this._sessions.put(channelId, session);
    }

    public void deregisterSession(int channelId) {
        this._sessions.remove(channelId);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("AMQConnection:\n");
        if (this._failoverPolicy.getCurrentBrokerDetails() == null) {
            buf.append("No active broker connection");
        } else {
            BrokerDetails bd = this._failoverPolicy.getCurrentBrokerDetails();
            buf.append("Host: ").append(String.valueOf(bd.getHost()));
            buf.append("\nPort: ").append(String.valueOf(bd.getPort()));
        }
        buf.append("\nVirtual Host: ").append(String.valueOf(this._virtualHost));
        buf.append("\nClient ID: ").append(String.valueOf(this._clientName));
        buf.append("\nActive session count: ").append(this._sessions == null ? 0 : this._sessions.size());
        return buf.toString();
    }

    public String toURL() {
        return this._connectionURL.toString();
    }

    @Override
    public Reference getReference() throws NamingException {
        return new Reference(AMQConnection.class.getName(), new StringRefAddr(AMQConnection.class.getName(), this.toURL()), AMQConnectionFactory.class.getName(), null);
    }

    public SSLConfiguration getSSLConfiguration() {
        return this._sslConfiguration;
    }

    public AMQShortString getDefaultTopicExchangeName() {
        return this._defaultTopicExchangeName;
    }

    public void setDefaultTopicExchangeName(AMQShortString defaultTopicExchangeName) {
        this._defaultTopicExchangeName = defaultTopicExchangeName;
    }

    public AMQShortString getDefaultQueueExchangeName() {
        return this._defaultQueueExchangeName;
    }

    public void setDefaultQueueExchangeName(AMQShortString defaultQueueExchangeName) {
        this._defaultQueueExchangeName = defaultQueueExchangeName;
    }

    public AMQShortString getTemporaryTopicExchangeName() {
        return this._temporaryTopicExchangeName;
    }

    public AMQShortString getTemporaryQueueExchangeName() {
        return this._temporaryQueueExchangeName;
    }

    public void setTemporaryTopicExchangeName(AMQShortString temporaryTopicExchangeName) {
        this._temporaryTopicExchangeName = temporaryTopicExchangeName;
    }

    public void setTemporaryQueueExchangeName(AMQShortString temporaryQueueExchangeName) {
        this._temporaryQueueExchangeName = temporaryQueueExchangeName;
    }

    public void performConnectionTask(Runnable task) {
        this._taskPool.execute(task);
    }

    public AMQSession getSession(int channelId) {
        return this._sessions.get(channelId);
    }

    public ProtocolVersion getProtocolVersion() {
        return this._delegate.getProtocolVersion();
    }

    public boolean isFailingOver() {
        return this._protocolHandler.getFailoverLatch() != null;
    }

    public long getMaxPrefetch() {
        return this._maxPrefetch;
    }

    public boolean getSyncPersistence() {
        return this._syncPersistence;
    }

    public boolean getSyncAck() {
        return this._syncAck;
    }

    public String getSyncPublish() {
        return this._syncPublish;
    }

    public int getNextChannelID() {
        return this._sessions.getNextChannelId();
    }

    public boolean isUseLegacyMapMessageFormat() {
        return this._useLegacyMapMessageFormat;
    }
}

