/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.qpid.client.SSLConfiguration;
import org.apache.qpid.jms.BrokerDetails;
import org.apache.qpid.url.URLHelper;
import org.apache.qpid.url.URLSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AMQBrokerDetails
implements BrokerDetails {
    private String _host;
    private int _port;
    private String _transport;
    private Map<String, String> _options = new HashMap<String, String>();
    private SSLConfiguration _sslConfiguration;

    public AMQBrokerDetails() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AMQBrokerDetails(String url) throws URLSyntaxException {
        try {
            URI connection = new URI(url);
            String transport = connection.getScheme();
            if (transport != null) {
                if (!(transport.equalsIgnoreCase("vm") || transport.equalsIgnoreCase("tcp") || transport.equalsIgnoreCase("socket"))) {
                    if (transport.equalsIgnoreCase("localhost")) {
                        connection = new URI("tcp://" + url);
                        transport = connection.getScheme();
                    } else {
                        if (url.charAt(transport.length()) != ':' || url.charAt(transport.length() + 1) == '/') throw URLHelper.parseError(0, transport.length(), "Unknown transport", url);
                        connection = new URI("tcp://" + url);
                        transport = connection.getScheme();
                    }
                } else if (url.indexOf("//") == -1) {
                    throw new URLSyntaxException(url, "Missing '//' after the transport In broker URL", transport.length() + 1, 1);
                }
            } else {
                connection = new URI("tcp://" + url);
                transport = connection.getScheme();
            }
            if (transport == null) {
                throw URLHelper.parseError(-1, "Unknown transport in broker URL:'" + url + "' Format: " + "<transport>://<hostname>[:<port Default=\"5672\">][?<option>='<value>'[,<option>='<value>']]", "");
            }
            this.setTransport(transport);
            String host = connection.getHost();
            if (host == null) {
                host = "";
                String auth = connection.getAuthority();
                if (auth != null) {
                    host = auth.contains(":") ? auth.substring(0, auth.indexOf(":")) : auth;
                }
            }
            this.setHost(host);
            int port = connection.getPort();
            if (port == -1) {
                String auth = connection.getAuthority();
                if (auth != null && auth.contains(":")) {
                    int start;
                    int end = start = auth.indexOf(":") + 1;
                    boolean looking = true;
                    boolean found = false;
                    if (start == auth.length()) {
                        throw URLHelper.parseError(connection.toString().indexOf(auth) + end - 1, connection.toString().indexOf(auth) + end, "Port number must be specified", connection.toString());
                    }
                    while (looking) {
                        try {
                            Integer.parseInt(auth.substring(start, ++end));
                            if (end < auth.length()) continue;
                            looking = false;
                            found = true;
                        }
                        catch (NumberFormatException nfe) {
                            looking = false;
                        }
                    }
                    if (!found) throw URLHelper.parseError(connection.toString().indexOf(connection.getAuthority()) + end - 1, "Illegal character in port number", connection.toString());
                    this.setPort(Integer.parseInt(auth.substring(start, end)));
                } else {
                    this.setPort(5672);
                }
            } else if (!this._transport.equalsIgnoreCase("socket")) {
                this.setPort(port);
            }
            String queryString = connection.getQuery();
            URLHelper.parseOptions(this._options, queryString);
            return;
        }
        catch (URISyntaxException uris) {
            if (!(uris instanceof URLSyntaxException)) throw URLHelper.parseError(uris.getIndex(), uris.getReason(), uris.getInput());
            throw (URLSyntaxException)uris;
        }
    }

    public AMQBrokerDetails(String host, int port, SSLConfiguration sslConfiguration) {
        this._host = host;
        this._port = port;
        this._sslConfiguration = sslConfiguration;
    }

    @Override
    public String getHost() {
        return this._host;
    }

    @Override
    public void setHost(String _host) {
        this._host = _host;
    }

    @Override
    public int getPort() {
        return this._port;
    }

    @Override
    public void setPort(int _port) {
        this._port = _port;
    }

    @Override
    public String getTransport() {
        return this._transport;
    }

    @Override
    public void setTransport(String _transport) {
        this._transport = _transport;
    }

    @Override
    public String getProperty(String key) {
        return this._options.get(key);
    }

    @Override
    public void setProperty(String key, String value) {
        this._options.put(key, value);
    }

    @Override
    public long getTimeout() {
        if (this._options.containsKey("connecttimeout")) {
            try {
                return Long.parseLong(this._options.get("connecttimeout"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 30000L;
    }

    @Override
    public boolean getBooleanProperty(String propName) {
        if (this._options.containsKey(propName)) {
            return Boolean.parseBoolean(this._options.get(propName));
        }
        return false;
    }

    @Override
    public void setTimeout(long timeout) {
        this.setProperty("connecttimeout", Long.toString(timeout));
    }

    @Override
    public SSLConfiguration getSSLConfiguration() {
        return this._sslConfiguration;
    }

    @Override
    public void setSSLConfiguration(SSLConfiguration sslConfig) {
        this._sslConfiguration = sslConfig;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this._transport);
        sb.append("://");
        if (!this._transport.equalsIgnoreCase("vm")) {
            sb.append(this._host);
        }
        if (!this._transport.equalsIgnoreCase("socket")) {
            sb.append(':');
            sb.append(this._port);
        }
        sb.append(this.printOptionsURL());
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof BrokerDetails)) {
            return false;
        }
        BrokerDetails bd = (BrokerDetails)o;
        return this._host.equalsIgnoreCase(bd.getHost()) && this._port == bd.getPort() && this._transport.equalsIgnoreCase(bd.getTransport()) && this.compareSSLConfigurations(bd.getSSLConfiguration());
    }

    public int hashCode() {
        int result = this._host != null ? this._host.hashCode() : 0;
        result = 31 * result + this._port;
        result = 31 * result + (this._transport != null ? this._transport.hashCode() : 0);
        return result;
    }

    private String printOptionsURL() {
        StringBuffer optionsURL = new StringBuffer();
        optionsURL.append('?');
        if (!this._options.isEmpty()) {
            for (String key : this._options.keySet()) {
                optionsURL.append(key);
                optionsURL.append("='");
                optionsURL.append(this._options.get(key));
                optionsURL.append("'");
                optionsURL.append('&');
            }
        }
        optionsURL.deleteCharAt(optionsURL.length() - 1);
        return optionsURL.toString();
    }

    private boolean compareSSLConfigurations(SSLConfiguration other) {
        boolean retval = false;
        if (this._sslConfiguration == null && other == null) {
            retval = true;
        } else if (this._sslConfiguration != null && other != null) {
            retval = true;
        }
        return retval;
    }

    public static String checkTransport(String broker) {
        if (!broker.contains("://")) {
            return "tcp://" + broker;
        }
        return broker;
    }

    @Override
    public Map<String, String> getProperties() {
        return this._options;
    }

    @Override
    public void setProperties(Map<String, String> props) {
        this._options = props;
    }
}

