/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.qpid.transport.Connection;
import org.apache.qpid.transport.DeliveryProperties;
import org.apache.qpid.transport.Future;
import org.apache.qpid.transport.Header;
import org.apache.qpid.transport.MessageAcceptMode;
import org.apache.qpid.transport.MessageAcquireMode;
import org.apache.qpid.transport.MessageProperties;
import org.apache.qpid.transport.MessageTransfer;
import org.apache.qpid.transport.Option;
import org.apache.qpid.transport.QueueQueryResult;
import org.apache.qpid.transport.Session;
import org.apache.qpid.transport.SessionException;
import org.apache.qpid.transport.SessionListener;

class ToyClient
implements SessionListener {
    ToyClient() {
    }

    public void opened(Session ssn) {
    }

    public void resumed(Session ssn) {
    }

    public void exception(Session ssn, SessionException exc) {
        exc.printStackTrace();
    }

    public void message(Session ssn, MessageTransfer xfr) {
        System.out.println("msg: " + xfr);
    }

    public void closed(Session ssn) {
    }

    public static final void main(String[] args) {
        Connection conn = new Connection();
        conn.connect("0.0.0.0", 5672, null, "guest", "guest", false);
        Session ssn = conn.createSession();
        ssn.setSessionListener(new ToyClient());
        ssn.queueDeclare("asdf", null, null, new Option[0]);
        ssn.sync();
        LinkedHashMap<String, List<String>> nested = new LinkedHashMap<String, List<String>>();
        nested.put("list", Arrays.asList("one", "two", "three"));
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("str", "this is a string");
        map.put("+int", 3);
        map.put("-int", -3);
        map.put("maxint", Integer.MAX_VALUE);
        map.put("minint", Integer.MIN_VALUE);
        map.put("+short", (short)1);
        map.put("-short", (short)-1);
        map.put("maxshort", (short)Short.MAX_VALUE);
        map.put("minshort", (short)Short.MIN_VALUE);
        map.put("float", Float.valueOf(3.3f));
        map.put("double", 4.9);
        map.put("char", Character.valueOf('c'));
        map.put("table", nested);
        map.put("list", Arrays.asList(1, 2, 3));
        map.put("binary", new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10});
        ssn.messageTransfer("asdf", MessageAcceptMode.EXPLICIT, MessageAcquireMode.PRE_ACQUIRED, new Header(new DeliveryProperties(), new MessageProperties().setApplicationHeaders(map)), "this is the data", new Option[0]);
        ssn.messageTransfer("fdsa", MessageAcceptMode.EXPLICIT, MessageAcquireMode.PRE_ACQUIRED, null, "this should be rejected", new Option[0]);
        ssn.sync();
        Future<QueueQueryResult> future = ssn.queueQuery("asdf", new Option[0]);
        System.out.println(future.get().getQueue());
        ssn.sync();
        ssn.close();
        conn.close();
    }
}

