/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid;

import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQFrame;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.MethodRegistry;
import org.apache.qpid.framing.ProtocolVersion;
import org.apache.qpid.protocol.AMQConstant;

public class AMQChannelException
extends AMQException {
    private final int _classId;
    private final int _methodId;
    private final byte major;
    private final byte minor;

    public AMQChannelException(AMQConstant errorCode, String msg, int classId, int methodId, byte major, byte minor, Throwable cause) {
        super(errorCode, msg, cause);
        this._classId = classId;
        this._methodId = methodId;
        this.major = major;
        this.minor = minor;
    }

    public AMQFrame getCloseFrame(int channel) {
        MethodRegistry reg = MethodRegistry.getMethodRegistry(new ProtocolVersion(this.major, this.minor));
        return new AMQFrame(channel, reg.createChannelCloseBody(this.getErrorCode() == null ? AMQConstant.INTERNAL_ERROR.getCode() : this.getErrorCode().getCode(), new AMQShortString(this.getMessage()), this._classId, this._methodId));
    }
}

