/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.vmpipe.support;

import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.support.AbstractIoFilterChain;
import org.apache.mina.transport.vmpipe.support.VmPipeSessionImpl;
import org.apache.mina.util.Queue;

public class VmPipeFilterChain
extends AbstractIoFilterChain {
    public VmPipeFilterChain(IoSession session) {
        super(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireMessageReceived(IoSession session, Object message) {
        VmPipeSessionImpl s = (VmPipeSessionImpl)session;
        Object object = s.lock;
        synchronized (object) {
            if (!s.getTrafficMask().isReadable()) {
                Queue queue = s.pendingDataQueue;
                synchronized (queue) {
                    s.pendingDataQueue.push(message);
                }
            } else {
                int byteCount = 1;
                if (message instanceof ByteBuffer) {
                    byteCount = ((ByteBuffer)message).remaining();
                }
                s.increaseReadBytes(byteCount);
                super.fireMessageReceived(s, message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWrite(IoSession session, IoFilter.WriteRequest writeRequest) {
        VmPipeSessionImpl s = (VmPipeSessionImpl)session;
        Object object = s.lock;
        synchronized (object) {
            if (s.isConnected()) {
                if (!s.getTrafficMask().isWritable()) {
                    Queue queue = s.pendingDataQueue;
                    synchronized (queue) {
                        s.pendingDataQueue.push(writeRequest);
                    }
                } else {
                    Object message = writeRequest.getMessage();
                    int byteCount = 1;
                    Object messageCopy = message;
                    if (message instanceof ByteBuffer) {
                        ByteBuffer rb = (ByteBuffer)message;
                        rb.mark();
                        byteCount = rb.remaining();
                        ByteBuffer wb = ByteBuffer.allocate(rb.remaining());
                        wb.put(rb);
                        wb.flip();
                        rb.reset();
                        messageCopy = wb;
                    }
                    s.increaseWrittenBytes(byteCount);
                    s.increaseWrittenMessages();
                    s.getFilterChain().fireMessageSent(s, writeRequest);
                    s.getRemoteSession().getFilterChain().fireMessageReceived(s.getRemoteSession(), messageCopy);
                }
            } else {
                writeRequest.getFuture().setWritten(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doClose(IoSession session) {
        VmPipeSessionImpl s = (VmPipeSessionImpl)session;
        Object object = s.lock;
        synchronized (object) {
            if (!session.getCloseFuture().isClosed()) {
                s.getServiceListeners().fireSessionDestroyed(s);
                s.getRemoteSession().close();
            }
        }
    }
}

