/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.socket.nio;

import edu.emory.mathcs.backport.java.util.concurrent.Executor;
import edu.emory.mathcs.backport.java.util.concurrent.locks.ReentrantLock;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.ExceptionMonitor;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.WriteTimeoutException;
import org.apache.mina.transport.socket.nio.MultiThreadSocketSessionImpl;
import org.apache.mina.transport.socket.nio.SocketIoProcessor;
import org.apache.mina.transport.socket.nio.SocketSessionImpl;
import org.apache.mina.util.IdentityHashSet;
import org.apache.mina.util.NamePreservingRunnable;
import org.apache.mina.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MultiThreadSocketIoProcessor
extends SocketIoProcessor {
    Logger _logger = LoggerFactory.getLogger(MultiThreadSocketIoProcessor.class);
    Logger _loggerRead = LoggerFactory.getLogger((String)(MultiThreadSocketIoProcessor.class + ".Reader"));
    Logger _loggerWrite = LoggerFactory.getLogger((String)(MultiThreadSocketIoProcessor.class + ".Writer"));
    private static final long SELECTOR_TIMEOUT = 1000L;
    private int MAX_READ_BYTES_PER_SESSION = 524288;
    private int MAX_FLUSH_BYTES_PER_SESSION = 524288;
    private final Object readLock = new Object();
    private final Object writeLock = new Object();
    private final String threadName;
    private final Executor executor;
    private ReentrantLock trafficMaskUpdateLock = new ReentrantLock();
    private volatile Selector selector;
    private volatile Selector writeSelector;
    private final Queue newSessions = new Queue();
    private final Queue removingSessions = new Queue();
    private final BlockingQueue flushingSessions = new LinkedBlockingQueue();
    private final IdentityHashSet flushingSessionsSet = new IdentityHashSet();
    private final Queue trafficControllingSessions = new Queue();
    private ReadWorker readWorker;
    private WriteWorker writeWorker;
    private long lastIdleReadCheckTime = System.currentTimeMillis();
    private long lastIdleWriteCheckTime = System.currentTimeMillis();

    MultiThreadSocketIoProcessor(String threadName, Executor executor) {
        super(threadName, executor);
        this.threadName = threadName;
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addNew(SocketSessionImpl session) throws IOException {
        Queue queue = this.newSessions;
        synchronized (queue) {
            this.newSessions.push(session);
        }
        this.startupWorker();
        this.selector.wakeup();
        this.writeSelector.wakeup();
    }

    void remove(SocketSessionImpl session) throws IOException {
        this.scheduleRemove(session);
        this.startupWorker();
        this.selector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startupWorker() throws IOException {
        Object object = this.readLock;
        synchronized (object) {
            if (this.readWorker == null) {
                this.selector = Selector.open();
                this.readWorker = new ReadWorker();
                this.executor.execute(new NamePreservingRunnable(this.readWorker));
            }
        }
        object = this.writeLock;
        synchronized (object) {
            if (this.writeWorker == null) {
                this.writeSelector = Selector.open();
                this.writeWorker = new WriteWorker();
                this.executor.execute(new NamePreservingRunnable(this.writeWorker));
            }
        }
    }

    void flush(SocketSessionImpl session) {
        this.scheduleFlush(session);
        Selector selector = this.writeSelector;
        if (selector != null) {
            selector.wakeup();
        }
    }

    void updateTrafficMask(SocketSessionImpl session) {
        this.scheduleTrafficControl(session);
        Selector selector = this.selector;
        if (selector != null) {
            selector.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleRemove(SocketSessionImpl session) {
        Queue queue = this.removingSessions;
        synchronized (queue) {
            this.removingSessions.push(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleFlush(SocketSessionImpl session) {
        IdentityHashSet identityHashSet = this.flushingSessionsSet;
        synchronized (identityHashSet) {
            if (this.flushingSessionsSet.add(session)) {
                this.flushingSessions.offer(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleTrafficControl(SocketSessionImpl session) {
        Queue queue = this.trafficControllingSessions;
        synchronized (queue) {
            this.trafficControllingSessions.push(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAddNewReader() throws InterruptedException {
        if (this.newSessions.isEmpty()) {
            return;
        }
        while (true) {
            MultiThreadSocketSessionImpl session;
            Queue queue = this.newSessions;
            synchronized (queue) {
                session = (MultiThreadSocketSessionImpl)this.newSessions.peek();
            }
            if (session == null) break;
            SocketChannel ch = session.getChannel();
            try {
                ch.configureBlocking(false);
                session.setSelectionKey(ch.register(this.selector, 1, session));
                session.awaitRegistration();
                this.sessionCreated(session);
            }
            catch (IOException e) {
                session.getFilterChain().fireExceptionCaught(session, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAddNewWrite() throws InterruptedException {
        if (this.newSessions.isEmpty()) {
            return;
        }
        while (true) {
            MultiThreadSocketSessionImpl session;
            Queue queue = this.newSessions;
            synchronized (queue) {
                session = (MultiThreadSocketSessionImpl)this.newSessions.peek();
            }
            if (session == null) break;
            SocketChannel ch = session.getChannel();
            try {
                ch.configureBlocking(false);
                IdentityHashSet identityHashSet = this.flushingSessionsSet;
                synchronized (identityHashSet) {
                    this.flushingSessionsSet.add(session);
                }
                session.setWriteSelectionKey(ch.register(this.writeSelector, 4, session));
                session.awaitRegistration();
                this.sessionCreated(session);
            }
            catch (IOException e) {
                session.getFilterChain().fireExceptionCaught(session, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sessionCreated(SocketSessionImpl sessionParam) throws InterruptedException {
        MultiThreadSocketSessionImpl session = (MultiThreadSocketSessionImpl)sessionParam;
        Queue queue = this.newSessions;
        synchronized (queue) {
            if (!session.created()) {
                this._logger.debug("Popping new session");
                this.newSessions.pop();
                session.getServiceListeners().fireSessionCreated(session);
                session.doneCreation();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void doRemove() {
        if (this.removingSessions.isEmpty()) {
            return;
        }
        while (true) {
            Queue queue = this.removingSessions;
            // MONITORENTER : queue
            MultiThreadSocketSessionImpl session = (MultiThreadSocketSessionImpl)this.removingSessions.pop();
            // MONITOREXIT : queue
            if (session == null) {
                return;
            }
            SocketChannel ch = session.getChannel();
            SelectionKey key = session.getReadSelectionKey();
            SelectionKey writeKey = session.getWriteSelectionKey();
            if (key == null || writeKey == null) {
                this.scheduleRemove(session);
                return;
            }
            if (!key.isValid() || !writeKey.isValid()) continue;
            try {
                Object object = this.readLock;
                // MONITORENTER : object
                key.cancel();
                // MONITOREXIT : object
                object = this.writeLock;
                // MONITORENTER : object
                writeKey.cancel();
                // MONITOREXIT : object
                ch.close();
                continue;
            }
            catch (IOException e) {
                session.getFilterChain().fireExceptionCaught(session, e);
                continue;
            }
            finally {
                this.releaseWriteBuffers(session);
                session.getServiceListeners().fireSessionDestroyed(session);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRead(Set selectedKeys) {
        for (SelectionKey key : selectedKeys) {
            MultiThreadSocketSessionImpl session = (MultiThreadSocketSessionImpl)key.attachment();
            Object object = this.readLock;
            synchronized (object) {
                if (key.isValid() && key.isReadable() && session.getTrafficMask().isReadable()) {
                    this.read(session);
                }
            }
        }
        selectedKeys.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processWrite(Set selectedKeys) {
        for (SelectionKey key : selectedKeys) {
            SocketSessionImpl session = (SocketSessionImpl)key.attachment();
            Object object = this.writeLock;
            synchronized (object) {
                if (key.isValid() && key.isWritable() && session.getTrafficMask().isWritable()) {
                    key.interestOps(key.interestOps() & 0xFFFFFFFB);
                    IdentityHashSet identityHashSet = this.flushingSessionsSet;
                    synchronized (identityHashSet) {
                        this.flushingSessions.offer(session);
                    }
                }
            }
        }
        selectedKeys.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read(SocketSessionImpl session) {
        int totalReadBytes = 0;
        while (totalReadBytes <= this.MAX_READ_BYTES_PER_SESSION) {
            ByteBuffer buf = ByteBuffer.allocate(session.getReadBufferSize());
            SocketChannel ch = session.getChannel();
            try {
                int ret;
                buf.clear();
                int readBytes = 0;
                try {
                    while ((ret = ch.read(buf.buf())) > 0) {
                        readBytes += ret;
                        totalReadBytes += ret;
                    }
                }
                finally {
                    buf.flip();
                }
                if (readBytes > 0) {
                    session.increaseReadBytes(readBytes);
                    session.getFilterChain().fireMessageReceived(session, buf);
                    buf = null;
                }
                if (ret > 0) continue;
                if (ret == 0) {
                    if (readBytes != session.getReadBufferSize()) break;
                    continue;
                }
                this.scheduleRemove(session);
                break;
            }
            catch (Throwable e) {
                if (e instanceof IOException) {
                    this.scheduleRemove(session);
                }
                session.getFilterChain().fireExceptionCaught(session, e);
                return;
            }
            finally {
                if (buf == null) continue;
                buf.release();
            }
        }
    }

    private void notifyReadIdleness() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastIdleReadCheckTime >= 1000L) {
            this.lastIdleReadCheckTime = currentTime;
            Set<SelectionKey> keys = this.selector.keys();
            if (keys != null) {
                for (SelectionKey key : keys) {
                    SocketSessionImpl session = (SocketSessionImpl)key.attachment();
                    this.notifyReadIdleness(session, currentTime);
                }
            }
        }
    }

    private void notifyWriteIdleness() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastIdleWriteCheckTime >= 1000L) {
            this.lastIdleWriteCheckTime = currentTime;
            Set<SelectionKey> keys = this.writeSelector.keys();
            if (keys != null) {
                for (SelectionKey key : keys) {
                    SocketSessionImpl session = (SocketSessionImpl)key.attachment();
                    this.notifyWriteIdleness(session, currentTime);
                }
            }
        }
    }

    private void notifyReadIdleness(SocketSessionImpl session, long currentTime) {
        this.notifyIdleness0(session, currentTime, session.getIdleTimeInMillis(IdleStatus.BOTH_IDLE), IdleStatus.BOTH_IDLE, Math.max(session.getLastIoTime(), session.getLastIdleTime(IdleStatus.BOTH_IDLE)));
        this.notifyIdleness0(session, currentTime, session.getIdleTimeInMillis(IdleStatus.READER_IDLE), IdleStatus.READER_IDLE, Math.max(session.getLastReadTime(), session.getLastIdleTime(IdleStatus.READER_IDLE)));
        this.notifyWriteTimeout(session, currentTime, session.getWriteTimeoutInMillis(), session.getLastWriteTime());
    }

    private void notifyWriteIdleness(SocketSessionImpl session, long currentTime) {
        this.notifyIdleness0(session, currentTime, session.getIdleTimeInMillis(IdleStatus.BOTH_IDLE), IdleStatus.BOTH_IDLE, Math.max(session.getLastIoTime(), session.getLastIdleTime(IdleStatus.BOTH_IDLE)));
        this.notifyIdleness0(session, currentTime, session.getIdleTimeInMillis(IdleStatus.WRITER_IDLE), IdleStatus.WRITER_IDLE, Math.max(session.getLastWriteTime(), session.getLastIdleTime(IdleStatus.WRITER_IDLE)));
        this.notifyWriteTimeout(session, currentTime, session.getWriteTimeoutInMillis(), session.getLastWriteTime());
    }

    private void notifyIdleness0(SocketSessionImpl session, long currentTime, long idleTime, IdleStatus status, long lastIoTime) {
        if (idleTime > 0L && lastIoTime != 0L && currentTime - lastIoTime >= idleTime) {
            session.increaseIdleCount(status);
            session.getFilterChain().fireSessionIdle(session, status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyWriteTimeout(SocketSessionImpl session, long currentTime, long writeTimeout, long lastIoTime) {
        MultiThreadSocketSessionImpl sesh = (MultiThreadSocketSessionImpl)session;
        SelectionKey key = sesh.getWriteSelectionKey();
        Object object = this.writeLock;
        synchronized (object) {
            if (writeTimeout > 0L && currentTime - lastIoTime >= writeTimeout && key != null && key.isValid() && (key.interestOps() & 4) != 0) {
                session.getFilterChain().fireExceptionCaught(session, new WriteTimeoutException());
            }
        }
    }

    private SocketSessionImpl getNextFlushingSession() {
        return (SocketSessionImpl)this.flushingSessions.poll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseSession(SocketSessionImpl session) {
        Queue queue = session.getWriteRequestQueue();
        synchronized (queue) {
            IdentityHashSet identityHashSet = this.flushingSessionsSet;
            synchronized (identityHashSet) {
                if (session.getScheduledWriteRequests() > 0) {
                    if (this._loggerWrite.isDebugEnabled()) {
                        // empty if block
                    }
                    this.flushingSessions.offer(session);
                } else {
                    if (this._loggerWrite.isDebugEnabled()) {
                        // empty if block
                    }
                    this.flushingSessionsSet.remove(session);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseWriteBuffers(SocketSessionImpl session) {
        Queue writeRequestQueue;
        Queue queue = writeRequestQueue = session.getWriteRequestQueue();
        synchronized (queue) {
            IoFilter.WriteRequest req;
            while ((req = (IoFilter.WriteRequest)writeRequestQueue.pop()) != null) {
                try {
                    ((ByteBuffer)req.getMessage()).release();
                }
                catch (IllegalStateException e) {
                    session.getFilterChain().fireExceptionCaught(session, e);
                }
                finally {
                    req.getFuture().setWritten(false);
                }
            }
        }
    }

    private void doFlush() {
        MultiThreadSocketSessionImpl session;
        while ((session = (MultiThreadSocketSessionImpl)this.getNextFlushingSession()) != null) {
            if (!session.isConnected()) {
                this.releaseWriteBuffers(session);
                this.releaseSession(session);
                continue;
            }
            SelectionKey key = session.getWriteSelectionKey();
            if (key == null) {
                this.scheduleFlush(session);
                this.releaseSession(session);
                continue;
            }
            if (!key.isValid()) {
                this.releaseSession(session);
                continue;
            }
            try {
                if (!this.doFlush(session)) continue;
                this.releaseSession(session);
            }
            catch (IOException e) {
                this.releaseSession(session);
                this.scheduleRemove(session);
                session.getFilterChain().fireExceptionCaught(session, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doFlush(SocketSessionImpl sessionParam) throws IOException {
        block18: {
            MultiThreadSocketSessionImpl session = (MultiThreadSocketSessionImpl)sessionParam;
            SelectionKey key = session.getWriteSelectionKey();
            Object object = this.writeLock;
            synchronized (object) {
                key.interestOps(key.interestOps() & 0xFFFFFFFB);
            }
            SocketChannel ch = session.getChannel();
            Queue writeRequestQueue = session.getWriteRequestQueue();
            long totalFlushedBytes = 0L;
            while (true) {
                IoFilter.WriteRequest req;
                Queue queue = writeRequestQueue;
                synchronized (queue) {
                    req = (IoFilter.WriteRequest)writeRequestQueue.first();
                }
                if (req == null) break block18;
                ByteBuffer buf = (ByteBuffer)req.getMessage();
                if (buf.remaining() == 0) {
                    Queue queue2 = writeRequestQueue;
                    synchronized (queue2) {
                        writeRequestQueue.pop();
                    }
                    session.increaseWrittenMessages();
                    buf.reset();
                    session.getFilterChain().fireMessageSent(session, req);
                    continue;
                }
                int writtenBytes = 0;
                if (key.isWritable()) {
                    writtenBytes = ch.write(buf.buf());
                    totalFlushedBytes += (long)writtenBytes;
                }
                if (writtenBytes > 0) {
                    session.increaseWrittenBytes(writtenBytes);
                }
                if (buf.hasRemaining() || totalFlushedBytes <= (long)this.MAX_FLUSH_BYTES_PER_SESSION) break;
            }
            Object object2 = this.writeLock;
            synchronized (object2) {
                key.interestOps(key.interestOps() | 4);
            }
            if (this._loggerWrite.isDebugEnabled()) {
                // empty if block
            }
            return false;
        }
        if (this._loggerWrite.isDebugEnabled()) {
            // empty if block
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdateTrafficMask() {
        block18: {
            if (this.trafficControllingSessions.isEmpty() || this.trafficMaskUpdateLock.isLocked()) {
                return;
            }
            this.trafficMaskUpdateLock.lock();
            while (true) {
                Queue writeRequestQueue;
                int mask;
                int ops;
                SelectionKey key;
                MultiThreadSocketSessionImpl session;
                while (true) {
                    if ((session = (MultiThreadSocketSessionImpl)this.trafficControllingSessions.pop()) == null) {
                        break block18;
                    }
                    key = session.getReadSelectionKey();
                    if (key == null) {
                        this.scheduleTrafficControl(session);
                        break block18;
                    }
                    if (!key.isValid()) continue;
                    ops = 1;
                    mask = session.getTrafficMask().getInterestOps();
                    Object object = this.readLock;
                    synchronized (object) {
                        key.interestOps(ops & mask);
                    }
                    key = session.getWriteSelectionKey();
                    if (key != null && key.isValid()) break;
                }
                Queue queue = writeRequestQueue = session.getWriteRequestQueue();
                synchronized (queue) {
                    if (!writeRequestQueue.isEmpty()) {
                        ops = 4;
                        Object object = this.writeLock;
                        synchronized (object) {
                            key.interestOps(ops & mask);
                        }
                    }
                }
            }
            finally {
                this.trafficMaskUpdateLock.unlock();
            }
        }
    }

    private class ReadWorker
    implements Runnable {
        private ReadWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Thread.currentThread().setName(MultiThreadSocketIoProcessor.this.threadName + "Reader");
            while (true) {
                try {
                    do {
                        int nKeys = MultiThreadSocketIoProcessor.this.selector.select(1000L);
                        MultiThreadSocketIoProcessor.this.doAddNewReader();
                        MultiThreadSocketIoProcessor.this.doUpdateTrafficMask();
                        if (nKeys > 0) {
                            MultiThreadSocketIoProcessor.this.processRead(MultiThreadSocketIoProcessor.this.selector.selectedKeys());
                        }
                        MultiThreadSocketIoProcessor.this.doRemove();
                        MultiThreadSocketIoProcessor.this.notifyReadIdleness();
                    } while (!MultiThreadSocketIoProcessor.this.selector.keys().isEmpty());
                    Object object = MultiThreadSocketIoProcessor.this.readLock;
                    synchronized (object) {
                        if (MultiThreadSocketIoProcessor.this.selector.keys().isEmpty() && MultiThreadSocketIoProcessor.this.newSessions.isEmpty()) {
                            MultiThreadSocketIoProcessor.this.readWorker = null;
                            try {
                                MultiThreadSocketIoProcessor.this.selector.close();
                            }
                            catch (IOException e) {
                                ExceptionMonitor.getInstance().exceptionCaught(e);
                            }
                            finally {
                                MultiThreadSocketIoProcessor.this.selector = null;
                            }
                            break;
                        }
                        continue;
                    }
                }
                catch (Throwable t) {
                    ExceptionMonitor.getInstance().exceptionCaught(t);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e1) {
                        ExceptionMonitor.getInstance().exceptionCaught(e1);
                    }
                    continue;
                }
                break;
            }
        }
    }

    private class WriteWorker
    implements Runnable {
        private WriteWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Thread.currentThread().setName(MultiThreadSocketIoProcessor.this.threadName + "Writer");
            while (true) {
                try {
                    do {
                        int nKeys = MultiThreadSocketIoProcessor.this.writeSelector.select(1000L);
                        MultiThreadSocketIoProcessor.this.doAddNewWrite();
                        MultiThreadSocketIoProcessor.this.doUpdateTrafficMask();
                        if (nKeys > 0) {
                            MultiThreadSocketIoProcessor.this.processWrite(MultiThreadSocketIoProcessor.this.writeSelector.selectedKeys());
                        }
                        MultiThreadSocketIoProcessor.this.doRemove();
                        MultiThreadSocketIoProcessor.this.notifyWriteIdleness();
                        if (MultiThreadSocketIoProcessor.this.flushingSessionsSet.size() <= 0) continue;
                        MultiThreadSocketIoProcessor.this.doFlush();
                    } while (!MultiThreadSocketIoProcessor.this.writeSelector.keys().isEmpty());
                    Object object = MultiThreadSocketIoProcessor.this.writeLock;
                    synchronized (object) {
                        if (MultiThreadSocketIoProcessor.this.writeSelector.keys().isEmpty() && MultiThreadSocketIoProcessor.this.newSessions.isEmpty()) {
                            MultiThreadSocketIoProcessor.this.writeWorker = null;
                            try {
                                MultiThreadSocketIoProcessor.this.writeSelector.close();
                            }
                            catch (IOException e) {
                                ExceptionMonitor.getInstance().exceptionCaught(e);
                            }
                            finally {
                                MultiThreadSocketIoProcessor.this.writeSelector = null;
                            }
                            break;
                        }
                        continue;
                    }
                }
                catch (Throwable t) {
                    ExceptionMonitor.getInstance().exceptionCaught(t);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e1) {
                        ExceptionMonitor.getInstance().exceptionCaught(e1);
                    }
                    continue;
                }
                break;
            }
        }
    }
}

