/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.common.support;

import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.apache.mina.common.IoAcceptorConfig;
import org.apache.mina.common.IoConnector;
import org.apache.mina.common.IoFuture;
import org.apache.mina.common.IoFutureListener;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoService;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.IoServiceListener;
import org.apache.mina.common.IoSession;
import org.apache.mina.util.IdentityHashSet;

public class IoServiceListenerSupport {
    private final List listeners = new ArrayList();
    private final Set managedServiceAddresses = new HashSet();
    private final Map managedSessions = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(IoServiceListener listener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(IoServiceListener listener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    public Set getManagedServiceAddresses() {
        return Collections.unmodifiableSet(this.managedServiceAddresses);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isManaged(SocketAddress serviceAddress) {
        Set set = this.managedServiceAddresses;
        synchronized (set) {
            return this.managedServiceAddresses.contains(serviceAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getManagedSessions(SocketAddress serviceAddress) {
        Set sessions;
        Object object = this.managedSessions;
        synchronized (object) {
            sessions = (Set)this.managedSessions.get(serviceAddress);
            if (sessions == null) {
                sessions = new IdentityHashSet();
            }
        }
        object = sessions;
        synchronized (object) {
            return new IdentityHashSet(sessions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireServiceActivated(IoService service, SocketAddress serviceAddress, IoHandler handler, IoServiceConfig config) {
        Collection collection = this.managedServiceAddresses;
        synchronized (collection) {
            if (!this.managedServiceAddresses.add(serviceAddress)) {
                return;
            }
        }
        collection = this.listeners;
        synchronized (collection) {
            Iterator i = this.listeners.iterator();
            while (i.hasNext()) {
                ((IoServiceListener)i.next()).serviceActivated(service, serviceAddress, handler, config);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void fireServiceDeactivated(IoService service, SocketAddress serviceAddress, IoHandler handler, IoServiceConfig config) {
        Collection collection = this.managedServiceAddresses;
        synchronized (collection) {
            if (!this.managedServiceAddresses.remove(serviceAddress)) {
                return;
            }
        }
        try {
            collection = this.listeners;
            synchronized (collection) {
                Iterator i = this.listeners.iterator();
                while (i.hasNext()) {
                    ((IoServiceListener)i.next()).serviceDeactivated(service, serviceAddress, handler, config);
                }
            }
        }
        finally {
            this.disconnectSessions(serviceAddress, config);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireSessionCreated(IoSession session) {
        Set sessions;
        SocketAddress serviceAddress = session.getServiceAddress();
        boolean firstSession = false;
        Object object = this.managedSessions;
        synchronized (object) {
            sessions = (Set)this.managedSessions.get(serviceAddress);
            if (sessions == null) {
                sessions = new IdentityHashSet();
                this.managedSessions.put(serviceAddress, sessions);
                firstSession = true;
            }
        }
        object = sessions;
        synchronized (object) {
            if (!sessions.add(session)) {
                return;
            }
        }
        if (session.getService() instanceof IoConnector && firstSession) {
            this.fireServiceActivated(session.getService(), session.getServiceAddress(), session.getHandler(), session.getServiceConfig());
        }
        session.getFilterChain().fireSessionCreated(session);
        session.getFilterChain().fireSessionOpened(session);
        object = this.listeners;
        synchronized (object) {
            Iterator i = this.listeners.iterator();
            while (i.hasNext()) {
                ((IoServiceListener)i.next()).sessionCreated(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireSessionDestroyed(IoSession session) {
        SocketAddress serviceAddress = session.getServiceAddress();
        boolean lastSession = false;
        Object object = this.managedSessions;
        synchronized (object) {
            Set sessions = (Set)this.managedSessions.get(serviceAddress);
            if (sessions == null) {
                return;
            }
            Set set = sessions;
            synchronized (set) {
                sessions.remove(session);
                if (sessions.isEmpty()) {
                    this.managedSessions.remove(serviceAddress);
                    lastSession = true;
                }
            }
        }
        session.getFilterChain().fireSessionClosed(session);
        try {
            object = this.listeners;
            synchronized (object) {
                Iterator i = this.listeners.iterator();
                while (i.hasNext()) {
                    ((IoServiceListener)i.next()).sessionDestroyed(session);
                }
            }
        }
        finally {
            if (session.getService() instanceof IoConnector && lastSession) {
                this.fireServiceDeactivated(session.getService(), session.getServiceAddress(), session.getHandler(), session.getServiceConfig());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnectSessions(SocketAddress serviceAddress, IoServiceConfig config) {
        IdentityHashSet sessionsCopy;
        Set sessions;
        if (!(config instanceof IoAcceptorConfig)) {
            return;
        }
        if (!((IoAcceptorConfig)config).isDisconnectOnUnbind()) {
            return;
        }
        Map map = this.managedSessions;
        synchronized (map) {
            sessions = (Set)this.managedSessions.get(serviceAddress);
        }
        if (sessions == null) {
            return;
        }
        Set set = sessions;
        synchronized (set) {
            sessionsCopy = new IdentityHashSet(sessions);
        }
        final CountDownLatch latch = new CountDownLatch(sessionsCopy.size());
        Iterator i = sessionsCopy.iterator();
        while (i.hasNext()) {
            ((IoSession)i.next()).close().addListener(new IoFutureListener(){

                public void operationComplete(IoFuture future) {
                    latch.countDown();
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
    }
}

