/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.common;

import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.ByteBufferAllocator;

public class FixedSizeByteBufferAllocator
implements ByteBufferAllocator {
    private static final int MINIMUM_CAPACITY = 1;

    public ByteBuffer allocate(int capacity, boolean direct) {
        java.nio.ByteBuffer nioBuffer = direct ? java.nio.ByteBuffer.allocateDirect(capacity) : java.nio.ByteBuffer.allocate(capacity);
        return new FixedSizeByteBuffer(nioBuffer);
    }

    public ByteBuffer wrap(java.nio.ByteBuffer nioBuffer) {
        return new FixedSizeByteBuffer(nioBuffer);
    }

    public void dispose() {
    }

    private static final class FixedSizeByteBuffer
    extends ByteBuffer {
        private java.nio.ByteBuffer buf;
        private int mark = -1;

        protected FixedSizeByteBuffer(java.nio.ByteBuffer buf) {
            this.buf = buf;
            buf.order(ByteOrder.BIG_ENDIAN);
        }

        public synchronized void acquire() {
        }

        public void release() {
        }

        public java.nio.ByteBuffer buf() {
            return this.buf;
        }

        public boolean isPooled() {
            return false;
        }

        public void setPooled(boolean pooled) {
        }

        public ByteBuffer duplicate() {
            return new FixedSizeByteBuffer(this.buf.duplicate());
        }

        public ByteBuffer slice() {
            return new FixedSizeByteBuffer(this.buf.slice());
        }

        public ByteBuffer asReadOnlyBuffer() {
            return new FixedSizeByteBuffer(this.buf.asReadOnlyBuffer());
        }

        public byte[] array() {
            return this.buf.array();
        }

        public int arrayOffset() {
            return this.buf.arrayOffset();
        }

        public boolean isDirect() {
            return this.buf.isDirect();
        }

        public boolean isReadOnly() {
            return this.buf.isReadOnly();
        }

        public int capacity() {
            return this.buf.capacity();
        }

        public ByteBuffer capacity(int newCapacity) {
            if (newCapacity > this.capacity()) {
                throw new IllegalArgumentException();
            }
            return this;
        }

        public boolean isAutoExpand() {
            return false;
        }

        public ByteBuffer setAutoExpand(boolean autoExpand) {
            if (autoExpand) {
                throw new IllegalArgumentException();
            }
            return this;
        }

        public ByteBuffer expand(int pos, int expectedRemaining) {
            int end = pos + expectedRemaining;
            if (end > this.capacity()) {
                this.capacity(end);
            }
            if (end > this.limit()) {
                this.buf.limit(end);
            }
            return this;
        }

        public int position() {
            return this.buf.position();
        }

        public ByteBuffer position(int newPosition) {
            this.buf.position(newPosition);
            if (this.mark > newPosition) {
                this.mark = -1;
            }
            return this;
        }

        public int limit() {
            return this.buf.limit();
        }

        public ByteBuffer limit(int newLimit) {
            this.buf.limit(newLimit);
            if (this.mark > newLimit) {
                this.mark = -1;
            }
            return this;
        }

        public ByteBuffer mark() {
            this.buf.mark();
            this.mark = this.position();
            return this;
        }

        public int markValue() {
            return this.mark;
        }

        public ByteBuffer reset() {
            this.buf.reset();
            return this;
        }

        public ByteBuffer clear() {
            this.buf.clear();
            this.mark = -1;
            return this;
        }

        public ByteBuffer flip() {
            this.buf.flip();
            this.mark = -1;
            return this;
        }

        public ByteBuffer rewind() {
            this.buf.rewind();
            this.mark = -1;
            return this;
        }

        public byte get() {
            return this.buf.get();
        }

        public ByteBuffer put(byte b) {
            this.buf.put(b);
            return this;
        }

        public byte get(int index) {
            return this.buf.get(index);
        }

        public ByteBuffer put(int index, byte b) {
            this.buf.put(index, b);
            return this;
        }

        public ByteBuffer get(byte[] dst, int offset, int length) {
            this.buf.get(dst, offset, length);
            return this;
        }

        public ByteBuffer put(java.nio.ByteBuffer src) {
            this.buf.put(src);
            return this;
        }

        public ByteBuffer put(byte[] src, int offset, int length) {
            this.buf.put(src, offset, length);
            return this;
        }

        public ByteBuffer compact() {
            this.buf.compact();
            this.mark = -1;
            return this;
        }

        public ByteOrder order() {
            return this.buf.order();
        }

        public ByteBuffer order(ByteOrder bo) {
            this.buf.order(bo);
            return this;
        }

        public char getChar() {
            return this.buf.getChar();
        }

        public ByteBuffer putChar(char value) {
            this.buf.putChar(value);
            return this;
        }

        public char getChar(int index) {
            return this.buf.getChar(index);
        }

        public ByteBuffer putChar(int index, char value) {
            this.buf.putChar(index, value);
            return this;
        }

        public CharBuffer asCharBuffer() {
            return this.buf.asCharBuffer();
        }

        public short getShort() {
            return this.buf.getShort();
        }

        public ByteBuffer putShort(short value) {
            this.buf.putShort(value);
            return this;
        }

        public short getShort(int index) {
            return this.buf.getShort(index);
        }

        public ByteBuffer putShort(int index, short value) {
            this.buf.putShort(index, value);
            return this;
        }

        public ShortBuffer asShortBuffer() {
            return this.buf.asShortBuffer();
        }

        public int getInt() {
            return this.buf.getInt();
        }

        public ByteBuffer putInt(int value) {
            this.buf.putInt(value);
            return this;
        }

        public int getInt(int index) {
            return this.buf.getInt(index);
        }

        public ByteBuffer putInt(int index, int value) {
            this.buf.putInt(index, value);
            return this;
        }

        public IntBuffer asIntBuffer() {
            return this.buf.asIntBuffer();
        }

        public long getLong() {
            return this.buf.getLong();
        }

        public ByteBuffer putLong(long value) {
            this.buf.putLong(value);
            return this;
        }

        public long getLong(int index) {
            return this.buf.getLong(index);
        }

        public ByteBuffer putLong(int index, long value) {
            this.buf.putLong(index, value);
            return this;
        }

        public LongBuffer asLongBuffer() {
            return this.buf.asLongBuffer();
        }

        public float getFloat() {
            return this.buf.getFloat();
        }

        public ByteBuffer putFloat(float value) {
            this.buf.putFloat(value);
            return this;
        }

        public float getFloat(int index) {
            return this.buf.getFloat(index);
        }

        public ByteBuffer putFloat(int index, float value) {
            this.buf.putFloat(index, value);
            return this;
        }

        public FloatBuffer asFloatBuffer() {
            return this.buf.asFloatBuffer();
        }

        public double getDouble() {
            return this.buf.getDouble();
        }

        public ByteBuffer putDouble(double value) {
            this.buf.putDouble(value);
            return this;
        }

        public double getDouble(int index) {
            return this.buf.getDouble(index);
        }

        public ByteBuffer putDouble(int index, double value) {
            this.buf.putDouble(index, value);
            return this;
        }

        public DoubleBuffer asDoubleBuffer() {
            return this.buf.asDoubleBuffer();
        }
    }
}

