/*
 * Decompiled with CFR 0.152.
 */
package org.jflux.impl.encode.avro;

import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.jflux.api.core.Adapter;
import org.jflux.api.core.config.Configuration;
import org.jflux.api.core.config.DefaultConfiguration;

public class SerializationConfigUtils {
    public static final String CONF_MESSAGE_CLASS = "serializationMessageClass";
    public static final String CONF_OUTPUT_CLASS = "serializationRecordClass";
    public static final String CONF_CONTENT_TYPE = "serializationContentType";
    public static final String CONF_ENCODING_ADAPTER = "serializationSenderEncoderAdapter";
    public static final String CONF_DECODING_ADAPTER = "serializationReceiverDecoderAdapter";
    public static final String CONF_AVRO_RECORD_SCHEMA = "avroRecordSchema";
    public static final String CONF_AVRO_ENCODING_TYPE = "avroEncodingType";
    public static final int ENCODING_BINARY = 0;
    public static final int ENCODING_JSON = 1;
    public static final int DEF_AVRO_ENCODING_TYPE = 0;

    private static <Msg, Rec> DefaultConfiguration<String> buildBaseConfig(Class<Msg> messageClass, Class<Rec> recordClass, Adapter<Msg, Rec> encoder, Adapter<Rec, Msg> decoder, String contentType) {
        DefaultConfiguration conf = new DefaultConfiguration();
        conf.addProperty(Class.class, (Object)CONF_MESSAGE_CLASS, messageClass);
        conf.addProperty(Class.class, (Object)CONF_OUTPUT_CLASS, recordClass);
        conf.addProperty(Adapter.class, (Object)CONF_ENCODING_ADAPTER, encoder);
        conf.addProperty(Adapter.class, (Object)CONF_DECODING_ADAPTER, decoder);
        conf.addProperty(String.class, (Object)CONF_CONTENT_TYPE, (Object)contentType);
        return conf;
    }

    public static <Msg, Rec> Configuration<String> buildSerializationConfig(Class<Msg> messageClass, Class<Rec> recordClass, Adapter<Msg, Rec> encoder, Adapter<Rec, Msg> decoder, String contentType) {
        return SerializationConfigUtils.buildBaseConfig(messageClass, recordClass, encoder, decoder, contentType);
    }

    public static <Msg, Rec extends IndexedRecord> Configuration<String> buildAvroSerializationConfig(Class<Msg> messageClass, Class<Rec> recordClass, Adapter<Msg, Rec> encoder, Adapter<Rec, Msg> decoder, String contentType, Schema recordSchema, int encoding) {
        DefaultConfiguration<String> conf = SerializationConfigUtils.buildBaseConfig(messageClass, recordClass, encoder, decoder, contentType);
        conf.addProperty(Schema.class, (Object)CONF_AVRO_RECORD_SCHEMA, (Object)recordSchema);
        conf.addProperty(Integer.class, (Object)CONF_AVRO_ENCODING_TYPE, (Object)encoding);
        return conf;
    }
}

