/*
 * Decompiled with CFR 0.152.
 */
package org.jflux.impl.encode.avro;

import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.specific.SpecificRecordBase;
import org.jflux.api.core.Adapter;
import org.jflux.api.encode.EncodeRequest;

public class AvroEncoder<T extends IndexedRecord, S extends OutputStream>
implements Adapter<EncodeRequest<T, S>, S> {
    private static final Logger theLogger = Logger.getLogger(AvroEncoder.class.getName());
    private DatumWriter<T> myWriter;
    private EncoderFactory myEncoderFactory;
    private boolean myJsonFlag;
    private Schema mySchema;

    public static <R extends SpecificRecordBase, S extends OutputStream> Adapter<EncodeRequest<R, S>, S> buildSpecificBinaryEncoder(Class<R> clazz) {
        return new AvroEncoder<R, S>(clazz, null, false);
    }

    public static <R extends IndexedRecord, S extends OutputStream> Adapter<EncodeRequest<R, S>, S> buildBinaryEncoder(Class<R> clazz, Schema schema) {
        return new AvroEncoder<R, S>(clazz, schema, false);
    }

    public static <R extends IndexedRecord, S extends OutputStream> Adapter<EncodeRequest<R, S>, S> buildBinaryEncoder(Class<S> streamType, Class<R> clazz, Schema schema) {
        return new AvroEncoder<R, S>(clazz, schema, false);
    }

    public static <R extends IndexedRecord, S extends OutputStream> Adapter<EncodeRequest<R, S>, S> buildJsonEncoder(Class<R> clazz, Schema schema) {
        return new AvroEncoder<R, S>(clazz, schema, true);
    }

    public AvroEncoder(Class<T> clazz, Schema schema, boolean json) {
        if (clazz == null && schema == null || json && schema == null) {
            throw new NullPointerException();
        }
        this.myEncoderFactory = EncoderFactory.get();
        this.myWriter = clazz != null && SpecificRecordBase.class.isAssignableFrom(clazz) ? new SpecificDatumWriter<T>(clazz) : new GenericDatumWriter<T>(schema);
        this.myJsonFlag = json;
        this.mySchema = schema;
    }

    public AvroEncoder(Schema schema, boolean specific, boolean json) {
        if (schema == null) {
            throw new NullPointerException();
        }
        this.myEncoderFactory = EncoderFactory.get();
        this.myWriter = specific ? new SpecificDatumWriter(schema) : new GenericDatumWriter(schema);
        this.myJsonFlag = json;
        this.mySchema = schema;
    }

    public void setType(Class<T> clazz, Schema schema) {
        if (clazz == null && schema == null || this.myJsonFlag && schema == null) {
            this.myWriter = null;
            return;
        }
        this.mySchema = schema;
        this.myWriter = clazz != null && SpecificRecordBase.class.isAssignableFrom(clazz) ? new SpecificDatumWriter<T>(clazz) : new GenericDatumWriter<T>(this.mySchema);
    }

    public S adapt(EncodeRequest<T, S> a) {
        if (a == null || a.getValue() == null || a.getStream() == null || this.myWriter == null) {
            return null;
        }
        try {
            OutputStream out = (OutputStream)a.getStream();
            Encoder e = this.myJsonFlag ? this.myEncoderFactory.jsonEncoder(this.mySchema, out) : this.myEncoderFactory.binaryEncoder(out, null);
            this.myWriter.write(a.getValue(), e);
            e.flush();
            return (S)out;
        }
        catch (IOException ex) {
            theLogger.log(Level.WARNING, "Error writing Avro record to OutputStream.", ex);
            return null;
        }
    }
}

