/*
 * Decompiled with CFR 0.152.
 */
package org.jflux.impl.encode.avro;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificRecordBase;
import org.jflux.api.core.Adapter;

public class AvroDecoder<S extends InputStream, T extends IndexedRecord>
implements Adapter<S, T> {
    private static final Logger theLogger = Logger.getLogger(AvroDecoder.class.getName());
    private DatumReader<T> myReader;
    private DecoderFactory myDecoderFactory;
    private boolean myJsonFlag;
    private Schema mySchema;

    public static <R extends SpecificRecordBase> AvroDecoder<ByteArrayInputStream, R> buildByteStreamDecoder(Class<R> outputClass) {
        return new AvroDecoder(outputClass, null, false);
    }

    public static <S extends InputStream, R extends SpecificRecordBase> AvroDecoder<S, R> buildSpecificBinaryDecoder(Class<R> outputClass) {
        return new AvroDecoder<S, R>(outputClass, null, false);
    }

    public static <S extends InputStream, R extends IndexedRecord> AvroDecoder<S, R> buildBinaryDecoder(Class<R> outputClass, Schema schema) {
        return new AvroDecoder<S, R>(outputClass, schema, false);
    }

    public static <S extends InputStream, R extends IndexedRecord> AvroDecoder<S, R> buildJsonDecoder(Class<S> inputClass, Class<R> outputClass, Schema schema) {
        return new AvroDecoder<S, R>(outputClass, schema, true);
    }

    AvroDecoder(Class<T> clazz, Schema schema, boolean json) {
        if (clazz == null && schema == null) {
            throw new NullPointerException();
        }
        if (json && schema == null) {
            throw new NullPointerException();
        }
        this.myReader = clazz != null && SpecificRecordBase.class.isAssignableFrom(clazz) ? new SpecificDatumReader<T>(clazz) : new GenericDatumReader<T>(schema);
        this.myDecoderFactory = DecoderFactory.get();
        this.myJsonFlag = json;
        this.mySchema = schema;
    }

    public T adapt(S a) {
        if (a == null) {
            return null;
        }
        try {
            Decoder decoder = this.myJsonFlag ? this.myDecoderFactory.jsonDecoder(this.mySchema, (InputStream)a) : this.myDecoderFactory.binaryDecoder((InputStream)a, null);
            return (T)((IndexedRecord)this.myReader.read(null, decoder));
        }
        catch (IOException ex) {
            theLogger.log(Level.WARNING, "There was an error decoding the stream.", ex);
            return null;
        }
    }
}

