/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.favorites;

import java.awt.datatransfer.Transferable;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.favorites.Actions;
import org.netbeans.modules.favorites.Tab;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.actions.DeleteAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.ChangeableDataFilter;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.loaders.LoaderTransfer;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.datatransfer.PasteType;

public final class FavoritesNode
extends FilterNode
implements Index {
    private static Node node;

    private FavoritesNode(Node node) {
        super(node, (Children)new Chldrn(node, false));
    }

    public PasteType getDropType(Transferable t, int action, int index) {
        if (index != -1) {
            return null;
        }
        DataObject[] dos = LoaderTransfer.getDataObjects((Transferable)t, (int)7);
        if (dos == null) {
            return null;
        }
        for (DataObject dataObject : dos) {
            if (Actions.Add.isAllowed(dataObject)) continue;
            return null;
        }
        return new FavoritesPasteType(dos);
    }

    public <T extends Node.Cookie> T getCookie(Class<T> cl) {
        if (cl == Index.class) {
            return (T)((Node.Cookie)cl.cast((Object)this));
        }
        return (T)super.getCookie(cl);
    }

    public int getNodesCount() {
        Index ind = (Index)this.getOriginal().getCookie(Index.class);
        if (ind != null) {
            return ind.getNodesCount();
        }
        return 0;
    }

    public Node[] getNodes() {
        Index ind = (Index)this.getOriginal().getCookie(Index.class);
        if (ind != null) {
            return ind.getNodes();
        }
        return new Node[0];
    }

    public int indexOf(Node node) {
        Index ind = (Index)this.getOriginal().getCookie(Index.class);
        if (ind != null) {
            if (node instanceof ProjectFilterNode) {
                ProjectFilterNode fn = (ProjectFilterNode)node;
                int i = ind.indexOf(fn.getOriginal());
                return i;
            }
            int i = ind.indexOf(node);
            return i;
        }
        return -1;
    }

    public void reorder() {
        Index ind = (Index)this.getOriginal().getCookie(Index.class);
        if (ind != null) {
            ind.reorder();
        }
    }

    public void reorder(int[] perm) {
        Index ind = (Index)this.getOriginal().getCookie(Index.class);
        if (ind != null) {
            ind.reorder(perm);
        }
    }

    public void move(int x, int y) {
        Index ind = (Index)this.getOriginal().getCookie(Index.class);
        if (ind != null) {
            ind.move(x, y);
        }
    }

    public void exchange(int x, int y) {
        Index ind = (Index)this.getOriginal().getCookie(Index.class);
        if (ind != null) {
            ind.exchange(x, y);
        }
    }

    public void moveUp(int x) {
        Index ind = (Index)this.getOriginal().getCookie(Index.class);
        if (ind != null) {
            ind.moveUp(x);
        }
    }

    public void moveDown(int x) {
        Index ind = (Index)this.getOriginal().getCookie(Index.class);
        if (ind != null) {
            ind.moveDown(x);
        }
    }

    public void addChangeListener(ChangeListener chl) {
        Index ind = (Index)this.getOriginal().getCookie(Index.class);
        if (ind != null) {
            ind.addChangeListener(chl);
        }
    }

    public void removeChangeListener(ChangeListener chl) {
        Index ind = (Index)this.getOriginal().getCookie(Index.class);
        if (ind != null) {
            ind.removeChangeListener(chl);
        }
    }

    public boolean canCopy() {
        return false;
    }

    public boolean canCut() {
        return false;
    }

    public boolean canRename() {
        return false;
    }

    public static DataFolder getFolder() {
        try {
            FileObject fo = FileUtil.createFolder((FileObject)FileUtil.getConfigRoot(), (String)"Favorites");
            DataFolder folder = DataFolder.findFolder((FileObject)fo);
            return folder;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return DataFolder.findFolder((FileObject)FileUtil.getConfigRoot());
        }
    }

    public static synchronized Node getNode() {
        if (node == null) {
            node = new FavoritesNode(FavoritesNode.getFolder().getNodeDelegate());
        }
        return node;
    }

    public static URL getHome() throws FileStateInvalidException, MalformedURLException {
        String s = System.getProperty("user.home");
        File home = new File(s);
        home = FileUtil.normalizeFile((File)home);
        return home.toURI().toURL();
    }

    static File fileForNode(Node n) {
        DataObject obj = (DataObject)n.getCookie(DataObject.class);
        if (obj == null) {
            return null;
        }
        return FileUtil.toFile((FileObject)obj.getPrimaryFile());
    }

    public Node.Handle getHandle() {
        return new RootHandle();
    }

    public Action[] getActions(boolean context) {
        return new Action[]{Actions.addOnFavoritesNode()};
    }

    private static class Chldrn
    extends FilterNode.Children {
        private boolean hideHidden;

        public Chldrn(Node node, boolean hideHidden) {
            super(node);
            this.hideHidden = hideHidden;
        }

        protected Node[] createNodes(Node node) {
            Object ch = FilterNode.Children.LEAF;
            DataObject obj = (DataObject)node.getLookup().lookup(DataObject.class);
            if (this.hideHidden && obj != null && !VisibilityQuery.getDefault().isVisible(obj.getPrimaryFile())) {
                return null;
            }
            DataFolder folder = (DataFolder)node.getLookup().lookup(DataFolder.class);
            ch = folder != null ? new Chldrn((Node)new FilterNode(node, folder.createNodeChildren((DataFilter)new VisQ())), true) : (node.isLeaf() ? Children.LEAF : new Chldrn(node, true));
            return new Node[]{new ProjectFilterNode(node, (Children)ch)};
        }
    }

    private static class FavoritesPasteType
    extends PasteType {
        private final DataObject[] dos;

        private FavoritesPasteType(DataObject[] dos) {
            this.dos = dos;
        }

        public Transferable paste() throws IOException {
            Tab.RP.post(new Runnable(){

                @Override
                public void run() {
                    Actions.Add.addToFavorites(Arrays.asList(FavoritesPasteType.this.dos));
                }
            });
            return null;
        }
    }

    private static class ProjectFilterNode
    extends FilterNode {
        public ProjectFilterNode(Node node, Children children) {
            super(node, children);
        }

        public void setName(String name) {
            DataFolder favoritesFolder = FavoritesNode.getFolder();
            DataObject[] children = favoritesFolder.getChildren();
            super.setName(name);
            try {
                favoritesFolder.setOrder(children);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        public String getDisplayName() {
            if (FavoritesNode.getNode().equals((Object)this.getParentNode())) {
                DataShadow ds = (DataShadow)this.getCookie(DataShadow.class);
                if (ds != null) {
                    String name = ds.getName();
                    String path = FileUtil.getFileDisplayName((FileObject)ds.getOriginal().getPrimaryFile());
                    return NbBundle.getMessage(FavoritesNode.class, (String)"CTL_DisplayNameTemplate", (Object)name, (Object)path);
                }
                return super.getDisplayName();
            }
            return super.getDisplayName();
        }

        public String getHtmlDisplayName() {
            if (FavoritesNode.getNode().equals((Object)this.getParentNode())) {
                DataShadow ds = (DataShadow)this.getCookie(DataShadow.class);
                if (ds != null) {
                    String name = ds.getName();
                    String path = FileUtil.getFileDisplayName((FileObject)ds.getOriginal().getPrimaryFile());
                    return NbBundle.getMessage(FavoritesNode.class, (String)"CTL_DisplayNameTemplateHtml", (Object)name, (Object)path);
                }
                return super.getDisplayName();
            }
            return this.getOriginal().getHtmlDisplayName();
        }

        protected Node getOriginal() {
            return super.getOriginal();
        }

        public boolean canDestroy() {
            boolean canDestroy = super.canDestroy();
            DataShadow link = (DataShadow)this.getCookie(DataShadow.class);
            if (canDestroy && this.isDeleteOriginal(link)) {
                canDestroy = link.getOriginal().isDeleteAllowed();
            }
            return canDestroy;
        }

        public void destroy() throws IOException {
            if (this.canDestroy()) {
                DataShadow link = (DataShadow)this.getCookie(DataShadow.class);
                DataObject original = this.isDeleteOriginal(link) ? link.getOriginal() : null;
                super.destroy();
                if (original != null) {
                    original.delete();
                }
            }
        }

        private boolean isDeleteOriginal(DataShadow link) {
            return false;
        }

        public Action[] getActions(boolean context) {
            File file;
            FileObject fo;
            Action[] arr = super.getActions(context);
            boolean isRoot = false;
            DataObject dataObject = (DataObject)this.getCookie(DataObject.class);
            if (dataObject != null && (fo = dataObject.getPrimaryFile()) != null && (file = FileUtil.toFile((FileObject)fo)) != null && file.getParent() == null) {
                isRoot = true;
            }
            if (isRoot) {
                return this.createActionsForRoot(arr);
            }
            if (FavoritesNode.getNode().equals((Object)this.getParentNode())) {
                DataShadow ds = (DataShadow)this.getCookie(DataShadow.class);
                if (ds != null) {
                    if (ds.getOriginal().getPrimaryFile().isFolder()) {
                        return this.createActionsForFavoriteFolder(arr);
                    }
                    return this.createActionsForFavoriteFile(arr);
                }
            } else {
                DataObject dObj = (DataObject)this.getCookie(DataObject.class);
                if (dObj != null) {
                    if (dObj.getPrimaryFile().isFolder()) {
                        return this.createActionsForFolder(arr);
                    }
                    return this.createActionsForFile(arr);
                }
            }
            return arr;
        }

        private Action[] createActionsForRoot(Action[] arr) {
            return arr;
        }

        private Action[] createActionsForFavoriteFolder(Action[] arr) {
            boolean added = false;
            ArrayList<Action> newArr = new ArrayList<Action>();
            for (int i = 0; i < arr.length; ++i) {
                if (!added && (arr[i] instanceof CopyAction || arr[i] instanceof CutAction)) {
                    added = true;
                    newArr.add(Actions.remove());
                    newArr.add(null);
                }
                if (arr[i] instanceof DeleteAction) continue;
                newArr.add(arr[i]);
            }
            if (!added) {
                added = true;
                newArr.add(null);
                newArr.add(Actions.remove());
            }
            return newArr.toArray(new Action[newArr.size()]);
        }

        private Action[] createActionsForFavoriteFile(Action[] arr) {
            boolean added = false;
            ArrayList<Action> newArr = new ArrayList<Action>();
            for (int i = 0; i < arr.length; ++i) {
                if (!added && (arr[i] instanceof CopyAction || arr[i] instanceof CutAction)) {
                    added = true;
                    newArr.add(Actions.remove());
                    newArr.add(null);
                }
                if (arr[i] instanceof DeleteAction) continue;
                newArr.add(arr[i]);
            }
            if (!added) {
                added = true;
                newArr.add(null);
                newArr.add(Actions.remove());
            }
            return newArr.toArray(new Action[newArr.size()]);
        }

        private Action[] createActionsForFolder(Action[] arr) {
            boolean added = false;
            ArrayList<Object> newArr = new ArrayList<Object>();
            for (int i = 0; i < arr.length; ++i) {
                if (!added && (arr[i] instanceof CopyAction || arr[i] instanceof CutAction)) {
                    added = true;
                    newArr.add(Actions.add());
                    newArr.add(null);
                }
                newArr.add(arr[i]);
            }
            if (!added) {
                added = true;
                newArr.add(null);
                newArr.add(Actions.add());
            }
            return newArr.toArray(new Action[newArr.size()]);
        }

        private Action[] createActionsForFile(Action[] arr) {
            boolean added = false;
            ArrayList<Object> newArr = new ArrayList<Object>();
            for (int i = 0; i < arr.length; ++i) {
                if (!added && (arr[i] instanceof CopyAction || arr[i] instanceof CutAction)) {
                    added = true;
                    newArr.add(Actions.add());
                    newArr.add(null);
                }
                newArr.add(arr[i]);
            }
            if (!added) {
                added = true;
                newArr.add(null);
                newArr.add(Actions.add());
            }
            return newArr.toArray(new Action[newArr.size()]);
        }
    }

    private static class RootHandle
    implements Node.Handle {
        static final long serialVersionUID = 1907300072945111595L;

        private RootHandle() {
        }

        public Node getNode() {
            return FavoritesNode.getNode();
        }
    }

    static class VisQ
    implements DataFilter.FileBased,
    ChangeableDataFilter,
    ChangeListener {
        public static final VisQ DEFAULT = new VisQ();
        private ChangeListener weak;
        private ChangeSupport support = new ChangeSupport((Object)this);

        VisQ() {
            this.weak = WeakListeners.change((ChangeListener)this, (Object)VisibilityQuery.getDefault());
            VisibilityQuery.getDefault().addChangeListener(this.weak);
        }

        public boolean acceptFileObject(FileObject fo) {
            return VisibilityQuery.getDefault().isVisible(fo);
        }

        public boolean acceptDataObject(DataObject obj) {
            return this.acceptFileObject(obj.getPrimaryFile());
        }

        public void addChangeListener(ChangeListener listener) {
            this.support.addChangeListener(listener);
        }

        public void removeChangeListener(ChangeListener listener) {
            this.support.removeChangeListener(listener);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.support.fireChange();
        }
    }
}

