/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.motion.robot.manager;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.utils.RobotController;

public class RobotControllerPanel
extends JPanel
implements PropertyChangeListener {
    private RobotController myRobotController;
    private JButton btnConnect;
    private JButton btnDisable;
    private JButton btnDisconnect;
    private JButton btnEnable;
    private JButton btnRemove;
    private JButton btnSelect;
    private JButton btnSetDefaultPos;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel lblConnection;
    private JLabel lblEnabled;
    private JLabel lblRobotId;
    private JLabel lblRobotType;
    private JLabel lblSelected;
    private JPanel pnlConnection;
    private JPanel pnlEnabled;
    private JPanel pnlRobotInfo;
    private JPanel pnlSelected;

    public RobotControllerPanel() {
        this.initComponents();
        this.repopulatePanel();
    }

    public void setRobotController(RobotController robotController) {
        if (this.myRobotController != null) {
            this.myRobotController.removePropertyChangeListener((PropertyChangeListener)this);
        }
        this.myRobotController = robotController;
        if (this.myRobotController != null) {
            this.myRobotController.addPropertyChangeListener((PropertyChangeListener)this);
        }
        this.repopulatePanel();
    }

    private Robot getRobot() {
        if (this.myRobotController == null) {
            return null;
        }
        return this.myRobotController.getRobot();
    }

    private void repopulatePanel() {
        this.populateInfo();
        this.populateConnection();
        this.populateEnabled();
        this.populateSelected();
        this.populateDefPos();
    }

    private void populateInfo() {
        Robot r = this.getRobot();
        String id = r == null ? "--" : r.getRobotId().getRobtIdString();
        this.lblRobotId.setText(id);
        String type = r == null ? "--" : r.getClass().getSimpleName();
        this.lblRobotType.setText(type);
    }

    private void populateConnection() {
        Robot r = this.getRobot();
        if (r == null) {
            this.lblConnection.setText("--");
            this.btnConnect.setEnabled(false);
            this.btnDisconnect.setEnabled(false);
        } else if (r.isConnected()) {
            this.lblConnection.setText("Connected");
            this.btnConnect.setEnabled(false);
            this.btnDisconnect.setEnabled(true);
        } else {
            this.lblConnection.setText("Disconnected");
            this.btnConnect.setEnabled(true);
            this.btnDisconnect.setEnabled(false);
        }
        this.populateEnabled();
    }

    private void populateEnabled() {
        Robot r = this.getRobot();
        if (r == null) {
            this.lblEnabled.setText("--");
            this.btnEnable.setEnabled(false);
            this.btnDisable.setEnabled(false);
        } else if (!r.isConnected()) {
            this.lblEnabled.setText("Disabled");
            this.btnEnable.setEnabled(false);
            this.btnDisable.setEnabled(false);
        } else if (r.isEnabled()) {
            this.lblEnabled.setText("Enabled");
            this.btnEnable.setEnabled(false);
            this.btnDisable.setEnabled(true);
        } else {
            this.lblEnabled.setText("Disabled");
            this.btnEnable.setEnabled(true);
            this.btnDisable.setEnabled(false);
        }
        this.populateDefPos();
    }

    private void populateSelected() {
        this.lblSelected.setText("--");
        this.btnSelect.setEnabled(false);
    }

    private void populateDefPos() {
        Robot r = this.getRobot();
        if (r == null) {
            this.btnSetDefaultPos.setEnabled(false);
        } else if (!r.isConnected() || !r.isEnabled()) {
            this.btnSetDefaultPos.setEnabled(false);
        } else {
            this.btnSetDefaultPos.setEnabled(true);
        }
    }

    private void initComponents() {
        this.pnlRobotInfo = new JPanel();
        this.jLabel1 = new JLabel();
        this.lblRobotId = new JLabel();
        this.jLabel2 = new JLabel();
        this.lblRobotType = new JLabel();
        this.pnlConnection = new JPanel();
        this.lblConnection = new JLabel();
        this.btnConnect = new JButton();
        this.btnDisconnect = new JButton();
        this.pnlEnabled = new JPanel();
        this.lblEnabled = new JLabel();
        this.btnEnable = new JButton();
        this.btnDisable = new JButton();
        this.btnSetDefaultPos = new JButton();
        this.pnlSelected = new JPanel();
        this.lblSelected = new JLabel();
        this.btnSelect = new JButton();
        this.btnRemove = new JButton();
        this.jLabel1.setText("Robot Id:");
        this.lblRobotId.setText("robot.id");
        this.jLabel2.setText("Type:");
        this.lblRobotType.setText("Robot");
        GroupLayout pnlRobotInfoLayout = new GroupLayout(this.pnlRobotInfo);
        this.pnlRobotInfo.setLayout(pnlRobotInfoLayout);
        pnlRobotInfoLayout.setHorizontalGroup(pnlRobotInfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlRobotInfoLayout.createSequentialGroup().addGroup(pnlRobotInfoLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel1, GroupLayout.Alignment.LEADING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlRobotInfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblRobotId).addComponent(this.lblRobotType))));
        pnlRobotInfoLayout.setVerticalGroup(pnlRobotInfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlRobotInfoLayout.createSequentialGroup().addGroup(pnlRobotInfoLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.lblRobotId)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlRobotInfoLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.lblRobotType))));
        this.lblConnection.setText("Status");
        this.lblConnection.setMaximumSize(new Dimension(64, 14));
        this.lblConnection.setMinimumSize(new Dimension(64, 14));
        this.lblConnection.setPreferredSize(new Dimension(64, 14));
        this.btnConnect.setText("Connect");
        this.btnConnect.setMaximumSize(new Dimension(85, 23));
        this.btnConnect.setMinimumSize(new Dimension(85, 23));
        this.btnConnect.setPreferredSize(new Dimension(85, 23));
        this.btnConnect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RobotControllerPanel.this.btnConnectActionPerformed(evt);
            }
        });
        this.btnDisconnect.setText("Disconnect");
        this.btnDisconnect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RobotControllerPanel.this.btnDisconnectActionPerformed(evt);
            }
        });
        GroupLayout pnlConnectionLayout = new GroupLayout(this.pnlConnection);
        this.pnlConnection.setLayout(pnlConnectionLayout);
        pnlConnectionLayout.setHorizontalGroup(pnlConnectionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlConnectionLayout.createSequentialGroup().addComponent(this.lblConnection, -2, 64, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnConnect, -2, 85, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnDisconnect, -2, 85, -2)));
        pnlConnectionLayout.setVerticalGroup(pnlConnectionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlConnectionLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblConnection, -2, -1, -2).addComponent(this.btnDisconnect, -2, 23, -2).addComponent(this.btnConnect, -2, -1, -2)));
        this.lblEnabled.setText("Status");
        this.lblEnabled.setMaximumSize(new Dimension(64, 14));
        this.lblEnabled.setMinimumSize(new Dimension(64, 14));
        this.lblEnabled.setPreferredSize(new Dimension(64, 14));
        this.btnEnable.setText("Enable");
        this.btnEnable.setMaximumSize(new Dimension(85, 23));
        this.btnEnable.setMinimumSize(new Dimension(85, 23));
        this.btnEnable.setPreferredSize(new Dimension(85, 23));
        this.btnEnable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RobotControllerPanel.this.btnEnableActionPerformed(evt);
            }
        });
        this.btnDisable.setText("Disable");
        this.btnDisable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RobotControllerPanel.this.btnDisableActionPerformed(evt);
            }
        });
        GroupLayout pnlEnabledLayout = new GroupLayout(this.pnlEnabled);
        this.pnlEnabled.setLayout(pnlEnabledLayout);
        pnlEnabledLayout.setHorizontalGroup(pnlEnabledLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlEnabledLayout.createSequentialGroup().addComponent(this.lblEnabled, -2, 64, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnEnable, -2, 85, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnDisable, -2, 85, -2)));
        pnlEnabledLayout.setVerticalGroup(pnlEnabledLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlEnabledLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblEnabled, -2, -1, -2).addComponent(this.btnDisable, -2, 23, -2).addComponent(this.btnEnable, -2, -1, -2)));
        this.btnSetDefaultPos.setText("Set Default Positions");
        this.btnSetDefaultPos.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RobotControllerPanel.this.btnSetDefaultPosActionPerformed(evt);
            }
        });
        this.lblSelected.setText("Status");
        this.lblSelected.setMaximumSize(new Dimension(64, 14));
        this.lblSelected.setMinimumSize(new Dimension(64, 14));
        this.lblSelected.setPreferredSize(new Dimension(64, 14));
        this.btnSelect.setText("Set Selected");
        this.btnSelect.setMaximumSize(new Dimension(85, 23));
        this.btnSelect.setMinimumSize(new Dimension(85, 23));
        this.btnSelect.setPreferredSize(new Dimension(85, 23));
        this.btnSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RobotControllerPanel.this.btnSelectActionPerformed(evt);
            }
        });
        GroupLayout pnlSelectedLayout = new GroupLayout(this.pnlSelected);
        this.pnlSelected.setLayout(pnlSelectedLayout);
        pnlSelectedLayout.setHorizontalGroup(pnlSelectedLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlSelectedLayout.createSequentialGroup().addComponent(this.lblSelected, -2, 64, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnSelect, -1, 176, Short.MAX_VALUE)));
        pnlSelectedLayout.setVerticalGroup(pnlSelectedLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlSelectedLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblSelected, -2, -1, -2).addComponent(this.btnSelect, -2, -1, -2)));
        this.btnRemove.setText("remove");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.pnlRobotInfo, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 78, Short.MAX_VALUE).addComponent(this.btnRemove)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.btnSetDefaultPos, -2, 176, -2).addGroup(GroupLayout.Alignment.LEADING, layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.pnlSelected, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.pnlEnabled, GroupLayout.Alignment.LEADING, 0, -1, Short.MAX_VALUE).addComponent(this.pnlConnection, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE))).addContainerGap()))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlRobotInfo, -2, -1, -2).addComponent(this.btnRemove)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlConnection, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlEnabled, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlSelected, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnSetDefaultPos, -2, 23, -2)));
    }

    private void btnConnectActionPerformed(ActionEvent evt) {
        if (this.myRobotController == null) {
            this.populateConnection();
            return;
        }
        this.myRobotController.connectRobot();
    }

    private void btnDisconnectActionPerformed(ActionEvent evt) {
        if (this.myRobotController == null) {
            this.populateConnection();
            return;
        }
        this.myRobotController.disconnectRobot();
    }

    private void btnEnableActionPerformed(ActionEvent evt) {
        if (this.myRobotController == null) {
            this.populateEnabled();
            return;
        }
        this.myRobotController.enableRobot();
    }

    private void btnDisableActionPerformed(ActionEvent evt) {
        if (this.myRobotController == null) {
            this.populateEnabled();
            return;
        }
        this.myRobotController.disableRobot();
    }

    private void btnSelectActionPerformed(ActionEvent evt) {
        if (this.myRobotController == null) {
            this.populateSelected();
            return;
        }
        this.myRobotController.selectRobot();
    }

    private void btnSetDefaultPosActionPerformed(ActionEvent evt) {
        if (this.myRobotController == null) {
            this.populateSelected();
            return;
        }
        this.myRobotController.setDefaultPositions();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt == null) {
            return;
        }
        if ("robot".equals(evt.getPropertyName())) {
            this.repopulatePanel();
        } else if ("isConnected".equals(evt.getPropertyName())) {
            this.populateConnection();
        } else if ("isEnabled".equals(evt.getPropertyName())) {
            this.populateEnabled();
        }
    }
}

