/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.motion.dynamixel;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import org.osgi.framework.BundleContext;
import org.robokind.api.common.osgi.OSGiUtils;
import org.robokind.api.common.osgi.ServiceClassListener;
import org.robokind.api.motion.servos.ServoController;
import org.robokind.impl.motion.dynamixel.DynamixelController;
import org.robokind.impl.motion.dynamixel.feedback.DynamixelControlLoop;
import org.robokind.impl.motion.dynamixel.feedback.DynamixelControlSettings;

public class DynamixelControlLoopPanel
extends JPanel {
    private static final Logger theLogger = Logger.getLogger(DynamixelControlLoopPanel.class.getName());
    private DynamixelControlSettings mySettings;
    private DynamixelControlLoop myLoop;
    private DynamixelListener myListener;
    private JButton btnApply;
    private JCheckBox chkCommands;
    private JCheckBox chkMove;
    private JCheckBox chkUpdates;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel pnlLoopFlags;
    private JToggleButton tglRun;
    private JTextField txtCooldownTemp;
    private JTextField txtMaxTemp;
    private JTextField txtReadCount;
    private JTextField txtReturnDelay;
    private JTextField txtWriteLag;

    public DynamixelControlLoopPanel() {
        this.initComponents();
    }

    public void init(DynamixelControlLoop loop) {
        if (loop == null) {
            this.myLoop = null;
            this.mySettings = null;
            this.clearDisplay();
        }
        this.myLoop = loop;
        this.mySettings = this.myLoop.getSettings();
        this.updateDisplay();
    }

    public void updateDisplay() {
        this.tglRun.setSelected(this.mySettings.getRunFlag());
        this.chkUpdates.setSelected(this.mySettings.getUpdateFlag());
        this.chkMove.setSelected(this.mySettings.getMoveFlag());
        this.chkCommands.setSelected(this.mySettings.getCommandFlag());
        this.txtReadCount.setText(this.p(this.mySettings.getReadCount()));
        this.txtReturnDelay.setText(this.p(this.mySettings.getReturnDelay()));
        this.txtWriteLag.setText(this.p(this.mySettings.getCommandSendDelay()));
        this.txtMaxTemp.setText(this.p(this.mySettings.getMaxRunTemperature()));
        this.txtCooldownTemp.setText(this.p(this.mySettings.getCooldownTemperature()));
    }

    public void clearDisplay() {
        this.tglRun.setSelected(false);
        this.chkUpdates.setSelected(false);
        this.chkMove.setSelected(false);
        this.chkCommands.setSelected(false);
        this.txtReadCount.setText("");
        this.txtReturnDelay.setText("");
        this.txtWriteLag.setText("");
        this.txtMaxTemp.setText("");
        this.txtCooldownTemp.setText("");
    }

    public void initialize(BundleContext context) {
        if (context == null || this.myListener != null) {
            return;
        }
        this.myListener = new DynamixelListener(context);
    }

    private String p(Object obj) {
        return obj.toString();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.tglRun = new JToggleButton();
        this.pnlLoopFlags = new JPanel();
        this.chkMove = new JCheckBox();
        this.chkCommands = new JCheckBox();
        this.chkUpdates = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.txtReadCount = new JTextField();
        this.txtReturnDelay = new JTextField();
        this.jLabel3 = new JLabel();
        this.txtWriteLag = new JTextField();
        this.jLabel4 = new JLabel();
        this.txtMaxTemp = new JTextField();
        this.txtCooldownTemp = new JTextField();
        this.jLabel5 = new JLabel();
        this.btnApply = new JButton();
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.tglRun.setText("Run");
        this.tglRun.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DynamixelControlLoopPanel.this.tglRunActionPerformed(evt);
            }
        });
        this.chkMove.setText("Move");
        this.chkMove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DynamixelControlLoopPanel.this.chkMoveActionPerformed(evt);
            }
        });
        this.chkCommands.setText("Commands");
        this.chkCommands.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DynamixelControlLoopPanel.this.chkCommandsActionPerformed(evt);
            }
        });
        this.chkUpdates.setText("Updates");
        this.chkUpdates.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DynamixelControlLoopPanel.this.chkUpdatesActionPerformed(evt);
            }
        });
        GroupLayout pnlLoopFlagsLayout = new GroupLayout(this.pnlLoopFlags);
        this.pnlLoopFlags.setLayout(pnlLoopFlagsLayout);
        pnlLoopFlagsLayout.setHorizontalGroup(pnlLoopFlagsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.chkMove).addComponent(this.chkCommands).addComponent(this.chkUpdates));
        pnlLoopFlagsLayout.setVerticalGroup(pnlLoopFlagsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlLoopFlagsLayout.createSequentialGroup().addComponent(this.chkMove).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkCommands).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkUpdates)));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tglRun, -2, 97, -2).addComponent(this.pnlLoopFlags, -2, -1, -2)).addContainerGap(127, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.tglRun).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.pnlLoopFlags, -2, -1, -2).addContainerGap(15, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel1.setText("Read Count");
        this.jLabel2.setText("Return Delay");
        this.jLabel3.setText("Write Latency");
        this.jLabel4.setText("Max Temp");
        this.jLabel5.setText("Cooldown Temp");
        this.btnApply.setText("Apply Changes");
        this.btnApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DynamixelControlLoopPanel.this.btnApplyActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.jLabel1).addComponent(this.jLabel4).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.txtCooldownTemp, -2, 86, -2).addComponent(this.txtReturnDelay, -2, 86, -2).addComponent(this.txtWriteLag, -2, 86, -2).addComponent(this.txtMaxTemp, -2, 86, -2).addComponent(this.txtReadCount, -2, 86, -2))).addComponent(this.btnApply)).addContainerGap(18, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.txtReadCount, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.txtReturnDelay, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.txtWriteLag, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.txtMaxTemp, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtCooldownTemp, -2, -1, -2).addComponent(this.jLabel5)).addGap(18, 18, 18).addComponent(this.btnApply).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void chkUpdatesActionPerformed(ActionEvent evt) {
        if (this.mySettings == null) {
            return;
        }
        boolean val = this.chkUpdates.isSelected();
        this.mySettings.setUpdateFlag(val);
    }

    private void btnApplyActionPerformed(ActionEvent evt) {
        if (this.mySettings == null) {
            return;
        }
        try {
            int read = Integer.parseInt(this.txtReadCount.getText());
            int returnDelay = Integer.parseInt(this.txtReturnDelay.getText());
            double writeLag = Double.parseDouble(this.txtWriteLag.getText());
            double hot = Double.parseDouble(this.txtMaxTemp.getText());
            double cool = Double.parseDouble(this.txtCooldownTemp.getText());
            if (read != this.mySettings.getReadCount() || returnDelay != this.mySettings.getReturnDelay()) {
                this.mySettings.setReadCount(read);
                this.mySettings.setReturnDelay(returnDelay);
                this.delayChange();
            }
            this.mySettings.setCommandSendDelay(writeLag);
            this.mySettings.setMaxRunTemperature(hot);
            this.mySettings.setCooldownTemperature(cool);
        }
        catch (Exception ex) {
            theLogger.log(Level.WARNING, "Error parsing and setting values.", ex);
        }
    }

    private void chkCommandsActionPerformed(ActionEvent evt) {
        if (this.mySettings == null) {
            return;
        }
        boolean val = this.chkCommands.isSelected();
        this.mySettings.setCommandFlag(val);
    }

    private void chkMoveActionPerformed(ActionEvent evt) {
        if (this.mySettings == null) {
            return;
        }
        boolean val = this.chkMove.isSelected();
        this.mySettings.setMoveFlag(val);
    }

    private void tglRunActionPerformed(ActionEvent evt) {
        if (this.mySettings == null) {
            return;
        }
        boolean val = this.tglRun.isSelected();
        this.mySettings.setRunFlag(val);
    }

    private void delayChange() {
        if (!this.mySettings.getRunFlag()) {
            return;
        }
        boolean update = this.mySettings.getUpdateFlag();
        boolean move = this.mySettings.getMoveFlag();
        boolean cmd = this.mySettings.getCommandFlag();
        this.mySettings.setCommandFlag(true);
        this.mySettings.setMoveFlag(false);
        this.mySettings.setUpdateFlag(false);
        this.mySettings.setCommandFlag(cmd);
        this.mySettings.setMoveFlag(move);
        this.mySettings.setUpdateFlag(update);
    }

    class DynamixelListener {
        private BundleContext myContext;
        private ServiceClassListener<ServoController> myControllerTracker;
        private DynamixelController myController;

        public DynamixelListener(BundleContext context) {
            if (context == null) {
                throw new NullPointerException();
            }
            String filter = OSGiUtils.createFilter((String)"servoControllerVersion", (String)DynamixelController.VERSION.toString());
            this.myControllerTracker = new ServiceClassListener<ServoController>(ServoController.class, context, filter){

                protected void addService(ServoController t) {
                    this.setController();
                }

                protected void removeService(ServoController t) {
                    this.setController();
                }

                private void setController() {
                    ServoController controller = (ServoController)this.getTopService();
                    if (controller == DynamixelListener.this.myController) {
                        return;
                    }
                    if (controller == null || !(controller instanceof DynamixelController)) {
                        DynamixelControlLoopPanel.this.init(null);
                    } else {
                        DynamixelListener.this.myController = (DynamixelController)controller;
                        DynamixelControlLoop loop = DynamixelListener.this.myController.getControlLoop();
                        DynamixelControlLoopPanel.this.init(loop);
                    }
                }
            };
            this.myControllerTracker.start();
            this.myContext = context;
        }
    }
}

