/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.speech.utils;

import java.util.ArrayList;
import java.util.List;
import org.jflux.api.core.Listener;
import org.robokind.api.speech.SpeechEvent;
import org.robokind.api.speech.SpeechEventList;

public class SpeechEventNotifier
implements Listener<SpeechEventList<SpeechEvent>> {
    private List<Listener<SpeechEventList<SpeechEvent>>> mySpeechEventListeners = new ArrayList<Listener<SpeechEventList<SpeechEvent>>>();

    public void handleEvent(SpeechEventList<SpeechEvent> t) {
        if (t == null || t.getSpeechEvents() == null) {
            throw new NullPointerException();
        }
        this.fireSpeechEvent(t);
    }

    public void fireSpeechEvent(SpeechEventList<SpeechEvent> ev) {
        for (Listener<SpeechEventList<SpeechEvent>> listener : this.mySpeechEventListeners) {
            listener.handleEvent(ev);
        }
    }

    public void addSpeechEventListener(Listener<SpeechEventList<SpeechEvent>> listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (!this.mySpeechEventListeners.contains(listener)) {
            this.mySpeechEventListeners.add(listener);
        }
    }

    public void removeSpeechEventListener(Listener<SpeechEventList<SpeechEvent>> listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (this.mySpeechEventListeners.contains(listener)) {
            this.mySpeechEventListeners.remove(listener);
        }
    }
}

