/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.motion.messaging;

import org.jflux.api.core.Adapter;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.messaging.RobotRequestFactory;
import org.robokind.api.motion.protocol.RobotRequest;
import org.robokind.avrogen.motion.RobotRequestRecord;

public class PortableRobotRequest
implements RobotRequest {
    private RobotRequestRecord myRecord;
    private Robot.Id myCachedId;

    public PortableRobotRequest(RobotRequestRecord record) {
        if (record == null) {
            throw new NullPointerException();
        }
        this.myRecord = record;
        this.myCachedId = new Robot.Id(this.myRecord.getRobotId());
    }

    public PortableRobotRequest(RobotRequest request) {
        if (request == null) {
            throw new NullPointerException();
        }
        if (request instanceof PortableRobotRequest) {
            this.myRecord = ((PortableRobotRequest)request).getRecord();
            this.myCachedId = new Robot.Id(this.myRecord.getRobotId());
            return;
        }
        this.myCachedId = request.getRobotId();
        this.myRecord = new RobotRequestRecord();
        this.myRecord.setRobotId(this.myCachedId.getRobtIdString());
        this.myRecord.setRequestSourceId(request.getSourceId());
        this.myRecord.setRequestDestinationId(request.getDestinationId());
        this.myRecord.setRequestType(request.getRequestType());
        this.myRecord.setTimestampMillisecUTC(Long.valueOf(request.getTimestampMillisecUTC()));
    }

    public PortableRobotRequest(Robot.Id robotId, String sourceId, String destId, String requestType, long timestampMillisecUTC, Integer requestIndex) {
        this.myCachedId = robotId;
        this.myRecord = new RobotRequestRecord();
        this.myRecord.setRobotId(this.myCachedId.getRobtIdString());
        this.myRecord.setRequestSourceId(sourceId);
        this.myRecord.setRequestDestinationId(destId);
        this.myRecord.setRequestType(requestType);
        this.myRecord.setTimestampMillisecUTC(Long.valueOf(timestampMillisecUTC));
        this.myRecord.setIntParam(requestIndex);
    }

    public Robot.Id getRobotId() {
        return this.myCachedId;
    }

    public String getSourceId() {
        return this.myRecord.getRequestSourceId();
    }

    public String getDestinationId() {
        return this.myRecord.getRequestDestinationId();
    }

    public String getRequestType() {
        return this.myRecord.getRequestType();
    }

    public long getTimestampMillisecUTC() {
        return this.myRecord.getTimestampMillisecUTC();
    }

    public Integer getRequestIndex() {
        return this.myRecord.getIntParam();
    }

    public RobotRequestRecord getRecord() {
        return this.myRecord;
    }

    public static class RecordMessageAdapter
    implements Adapter<RobotRequestRecord, RobotRequest> {
        public RobotRequest adapt(RobotRequestRecord a) {
            return new PortableRobotRequest(a);
        }
    }

    public static class MessageRecordAdapter
    implements Adapter<RobotRequest, RobotRequestRecord> {
        public RobotRequestRecord adapt(RobotRequest a) {
            if (a == null) {
                throw new NullPointerException();
            }
            return new PortableRobotRequest(a).getRecord();
        }
    }

    public static class Factory
    implements RobotRequestFactory<PortableRobotRequest> {
        public PortableRobotRequest buildRobotRequest(Robot.Id robotId, String sourceId, String destId, String requestType, long timestampMillisecUTC) {
            return new PortableRobotRequest(robotId, sourceId, destId, requestType, timestampMillisecUTC, null);
        }

        public PortableRobotRequest buildJointRequest(Robot.JointId jointId, String sourceId, String destId, String requestType, long timestampMillisecUTC) {
            Robot.Id robotId = jointId.getRobotId();
            Integer jointIdInt = jointId.getJointId().getLogicalJointNumber();
            return new PortableRobotRequest(robotId, sourceId, destId, requestType, timestampMillisecUTC, jointIdInt);
        }
    }
}

