/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.integration.animation_motion.osgi;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.robokind.api.common.osgi.ServiceClassListener;
import org.robokind.api.motion.Robot;
import org.robokind.integration.animation_motion.AnimationMotionUtils;

public class AnimationRobotMonitor
extends ServiceClassListener<Robot> {
    private static final Logger theLogger = Logger.getLogger(AnimationRobotMonitor.class.getName());
    private Map<Robot, ServiceRegistration[]> myRegistrationMap;
    private BundleContext myContext;

    public AnimationRobotMonitor(BundleContext context, String filter) {
        super(Robot.class, context, filter);
        if (context == null) {
            throw new NullPointerException();
        }
        this.myContext = context;
        this.myRegistrationMap = new HashMap<Robot, ServiceRegistration[]>();
    }

    protected void addService(Robot t) {
        ServiceRegistration[] regs = AnimationMotionUtils.registerAnimationEditingComponents(this.myContext, t);
        if (regs == null) {
            return;
        }
        this.myRegistrationMap.put(t, regs);
    }

    protected void removeService(Robot t) {
        ServiceRegistration[] regs = this.myRegistrationMap.remove(t);
        if (regs == null) {
            return;
        }
        for (ServiceRegistration reg : regs) {
            if (reg == null) continue;
            try {
                reg.unregister();
            }
            catch (IllegalStateException ex) {
                theLogger.log(Level.INFO, "Service already unregistered, no need to unregister.");
            }
        }
    }
}

