/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.integration.animation_motion.lifecycle;

import java.util.Map;
import java.util.Properties;
import org.robokind.api.animation.utils.ChannelsParameterSource;
import org.robokind.api.common.lifecycle.AbstractLifecycleProvider;
import org.robokind.api.common.lifecycle.utils.DescriptorListBuilder;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.jointgroup.JointGroup;
import org.robokind.integration.animation_motion.ChannelRobotParameters;

public class RobotChannelsLifecycle
extends AbstractLifecycleProvider<ChannelsParameterSource, ChannelRobotParameters> {
    private static final String theRobot = "robot";
    private static final String theJointGroup = "jointGroup";

    public RobotChannelsLifecycle(Robot.Id robotId) {
        super(new DescriptorListBuilder().dependency(theRobot, Robot.class).with("robotId", robotId.getRobtIdString()).dependency(theJointGroup, JointGroup.class).with("robotId", robotId.getRobtIdString()).optional().getDescriptors());
        if (this.myRegistrationProperties == null) {
            this.myRegistrationProperties = new Properties();
        }
        this.myRegistrationProperties.put("robotId", robotId.getRobtIdString());
    }

    protected ChannelRobotParameters create(Map<String, Object> services) {
        Robot robot = (Robot)services.get(theRobot);
        JointGroup group = (JointGroup)services.get(theJointGroup);
        ChannelRobotParameters params = new ChannelRobotParameters();
        params.setRobot(robot);
        params.setJointGroup(group);
        return params;
    }

    protected void handleChange(String serviceId, Object service, Map<String, Object> dependencies) {
        if (theRobot.equals(serviceId)) {
            ((ChannelRobotParameters)this.myService).setRobot((Robot)service);
        } else if (theJointGroup.equals(serviceId)) {
            ((ChannelRobotParameters)this.myService).setJointGroup((JointGroup)service);
        }
    }

    public Class<ChannelsParameterSource> getServiceClass() {
        return ChannelsParameterSource.class;
    }
}

