/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.integration.animation_motion;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.SubnodeConfiguration;
import org.robokind.api.animation.utils.ChannelsParameter;
import org.robokind.api.animation.utils.ChannelsParameterSource;
import org.robokind.api.common.position.DoubleRange;
import org.robokind.api.common.position.NormalizableRange;
import org.robokind.api.common.position.NormalizedDouble;
import org.robokind.integration.animation_motion.ChannelRobotParameters;

public class RobotParameterReader {
    public static ChannelsParameterSource readChannelsParamsSource(HierarchicalConfiguration config) {
        List nodes = config.configurationsAt("ChannelsParameter");
        if (nodes == null || nodes.isEmpty()) {
            return null;
        }
        ChannelRobotParameters channelParams = new ChannelRobotParameters();
        for (HierarchicalConfiguration node : nodes) {
            ChannelsParameter channelParam = RobotParameterReader.readChannelsParam(node);
            if (channelParam == null) continue;
            channelParams.addChannelParameter(channelParam);
        }
        return channelParams;
    }

    public static ChannelsParameter readChannelsParam(HierarchicalConfiguration config) {
        int channelId = config.getInt("ChannelId");
        String channelName = config.getString("ChannelName");
        NormalizedDouble defaultPosition = new NormalizedDouble(config.getDouble("DefaultPosition"));
        NormalizableRange<Double> range = RobotParameterReader.readNormalizableRange(config);
        Map<String, String> genericParams = RobotParameterReader.readGenericProperties(config);
        ChannelsParameter param = new ChannelsParameter(channelId, channelName, defaultPosition, range);
        for (String key : genericParams.keySet()) {
            param.setParameter(key, genericParams.get(key));
        }
        return param;
    }

    public static Map<String, String> readGenericProperties(HierarchicalConfiguration config) {
        List nodes = config.configurationsAt("GenericParameter");
        if (nodes == null || nodes.isEmpty()) {
            return null;
        }
        HashMap<String, String> genericProperties = new HashMap<String, String>();
        for (HierarchicalConfiguration node : nodes) {
            String key = node.getString("ParameterName");
            String value = node.getString("ParameterValue");
            genericProperties.put(key, value);
        }
        return genericProperties;
    }

    public static NormalizableRange<Double> readNormalizableRange(HierarchicalConfiguration config) {
        SubnodeConfiguration rangeConfig = config.configurationAt("NormalizableRange");
        double min = rangeConfig.getDouble("Minimum");
        double max = rangeConfig.getDouble("Maximum");
        DoubleRange range = new DoubleRange(min, max);
        return range;
    }
}

