/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.integration.animation_motion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;
import org.robokind.api.animation.Animation;
import org.robokind.api.animation.MotionPath;
import org.robokind.api.animation.compiled.CompiledMap;
import org.robokind.api.animation.compiled.CompiledPath;
import org.robokind.api.animation.player.AnimationJob;
import org.robokind.api.animation.player.AnimationJobListener;
import org.robokind.api.animation.player.AnimationPlayer;
import org.robokind.api.animation.protocol.AnimationSignal;
import org.robokind.api.common.playable.AbstractPlayable;
import org.robokind.api.common.playable.PlayState;
import org.robokind.api.common.playable.Playable;
import org.robokind.api.common.position.NormalizedDouble;
import org.robokind.api.common.services.addon.ServiceAddOn;
import org.robokind.api.common.utils.Utils;
import org.robokind.api.interpolation.InterpolatorFactory;
import org.robokind.api.interpolation.linear.LinearInterpolatorFactory;
import org.robokind.api.motion.Joint;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.blending.FrameSource;
import org.robokind.api.motion.protocol.DefaultMotionFrame;
import org.robokind.api.motion.protocol.JointPositionMap;
import org.robokind.api.motion.protocol.MotionFrame;
import org.robokind.api.motion.utils.RobotUtils;
import org.robokind.integration.animation_motion.RampedAnimationPlayer;

public class RampedAnimationJob
extends AbstractPlayable
implements AnimationJob,
FrameSource<Robot.RobotPositionMap> {
    private static final Logger theLogger = Logger.getLogger(RampedAnimationJob.class.getName());
    private BundleContext myContext;
    private Robot.RobotPositionMap myPreviousPositions;
    private Animation myAnimation;
    private CompiledMap myRampedAnimationMap;
    private CompiledMap myAnimationMap;
    private List<AnimationJobListener> myAnimationListeners;
    private AnimationPlayer mySource;
    private Robot.Id myRobotId;
    private long myStepLengthMillisec;
    private long myRampTimeMillisec;
    private long myMaxRampTimeMillisec;
    private boolean myLoopFlag;
    private AnimationSignal.AnimationSignalFactory mySignalFactory;

    RampedAnimationJob(BundleContext context, AnimationPlayer source, Robot.Id robotId, Animation anim, long stepLength, Long start, Long stop, int maxRampMillisec) {
        if (context == null || robotId == null || anim == null) {
            throw new NullPointerException();
        }
        if (stepLength <= 0L) {
            throw new IllegalArgumentException("stepLength must be greater than zero");
        }
        this.myContext = context;
        this.myLoopFlag = false;
        this.myRobotId = robotId;
        this.myAnimationListeners = new ArrayList<AnimationJobListener>();
        this.mySource = source;
        this.myAnimation = anim;
        this.myStepLengthMillisec = stepLength;
        this.myMaxRampTimeMillisec = maxRampMillisec;
        long s = start == null ? -1L : start;
        long e = stop == null ? -1L : stop;
        this.myAnimationMap = anim.compileMap(s, e, this.myStepLengthMillisec);
    }

    private void addRamping(Map<Integer, Double> curPos) {
        this.myRampedAnimationMap = (CompiledMap)this.myAnimationMap.clone();
        double maxDif = this.findMaxDif(curPos);
        maxDif = Utils.bound((double)maxDif, (double)0.0, (double)1.0);
        this.myRampTimeMillisec = (int)(maxDif * (double)this.myMaxRampTimeMillisec);
        LinearInterpolatorFactory linearFact = new LinearInterpolatorFactory();
        for (Map.Entry e : this.myRampedAnimationMap.entrySet()) {
            Double cur;
            CompiledPath path = (CompiledPath)e.getValue();
            int id = (Integer)e.getKey();
            double start = this.getStart(path);
            if (start == -1.0 || (cur = curPos.get(id)) == null) continue;
            MotionPath rampPath = new MotionPath((InterpolatorFactory)linearFact);
            rampPath.addPoint(0.0, cur.doubleValue());
            rampPath.addPoint((double)this.myRampTimeMillisec, start);
            CompiledPath ramp = rampPath.compilePath(0L, this.myRampTimeMillisec, this.myStepLengthMillisec);
            path.addAll(0, (Collection)ramp);
        }
        if (this.myRampTimeMillisec > 0L) {
            this.myRampedAnimationMap.setTimes(this.myRampedAnimationMap.getStartTime(), this.myRampedAnimationMap.getEndTime() + this.myRampTimeMillisec, true);
        }
    }

    private double findMaxDif(Map<Integer, Double> currentPos) {
        double maxDif = 0.0;
        for (Map.Entry e : this.myAnimationMap.entrySet()) {
            double dif;
            Double cur;
            CompiledPath path = (CompiledPath)e.getValue();
            int id = (Integer)e.getKey();
            double start = this.getStart(path);
            if (start == -1.0 || (cur = currentPos.get(id)) == null || !((dif = Math.abs(cur - start)) > maxDif)) continue;
            maxDif = dif;
        }
        return maxDif;
    }

    private double getStart(CompiledPath path) {
        for (Double d : path) {
            if (d == null || d == -1.0) continue;
            return d;
        }
        return -1.0;
    }

    public void setSource(AnimationPlayer source) {
        this.mySource = source;
    }

    public AnimationPlayer getSource() {
        return this.mySource;
    }

    public void addAnimationListener(AnimationJobListener listener) {
        if (this.myAnimationListeners == null) {
            this.myAnimationListeners = new ArrayList<AnimationJobListener>();
        }
        if (!this.myAnimationListeners.contains(listener)) {
            this.myAnimationListeners.add(listener);
        }
    }

    public void removeAnimationListener(AnimationJobListener listener) {
        if (this.myAnimationListeners == null) {
            return;
        }
        this.myAnimationListeners.remove(listener);
    }

    public Animation getAnimation() {
        return this.myAnimation;
    }

    public Long getCurrentTime(long time) {
        Long l = this.getElapsedPlayTime(time) + this.myRampTimeMillisec;
        if (l == null) {
            return null;
        }
        Long s = this.myAnimationMap.getStartTime();
        if (s == null) {
            return l;
        }
        return l + s;
    }

    public Map<Integer, Double> advanceAnimation(long time, long interval) {
        MotionFrame frame = this.getMovements(time, interval);
        if (frame == null) {
            return null;
        }
        return frame.getGoalPositions();
    }

    public MotionFrame getMovements(long time, long interval) {
        if (this.myPlayState != PlayState.RUNNING) {
            return null;
        }
        DefaultMotionFrame frame = new DefaultMotionFrame();
        frame.setTimestampMillisecUTC(time);
        frame.setFrameLengthMillisec(interval);
        this.myPreviousPositions.clear();
        long cur = this.getCurrentTime(time);
        for (Map.Entry e : this.myRampedAnimationMap.entrySet()) {
            CompiledPath path = (CompiledPath)e.getValue();
            Integer id = (Integer)e.getKey();
            double pos = path.estimatePosition(cur);
            if (id == null || !NormalizedDouble.isValid((double)pos)) continue;
            NormalizedDouble val = new NormalizedDouble(pos);
            Joint.Id jId = new Joint.Id(id.intValue());
            Robot.JointId djId = new Robot.JointId(this.myRobotId, jId);
            this.myPreviousPositions.put((Object)djId, (Object)val);
        }
        frame.setPreviousPositions((JointPositionMap)this.myPreviousPositions);
        this.myPreviousPositions.clear();
        long next = this.getCurrentTime(time + interval);
        for (Map.Entry e : this.myRampedAnimationMap.entrySet()) {
            CompiledPath path = (CompiledPath)e.getValue();
            Integer id = (Integer)e.getKey();
            double pos = path.estimatePosition(next);
            if (id == null || !NormalizedDouble.isValid((double)pos)) continue;
            NormalizedDouble val = new NormalizedDouble(pos);
            Joint.Id jId = new Joint.Id(id.intValue());
            Robot.JointId djId = new Robot.JointId(this.myRobotId, jId);
            this.myPreviousPositions.put((Object)djId, (Object)val);
        }
        frame.setGoalPositions((JointPositionMap)this.myPreviousPositions);
        long unrampedTime = cur - this.myRampTimeMillisec;
        if (this.isComplete(unrampedTime)) {
            this.complete(time);
        }
        this.advance(unrampedTime);
        return frame;
    }

    private boolean isComplete(long currentTime) {
        for (Map.Entry e : this.myAnimationMap.entrySet()) {
            CompiledPath path = (CompiledPath)e.getValue();
            if (currentTime >= path.getEndTime()) continue;
            return false;
        }
        return true;
    }

    private void advance(long elapsed) {
        if (this.myAnimationListeners == null) {
            return;
        }
        for (AnimationJobListener listener : this.myAnimationListeners) {
            listener.animationAdvanced(elapsed);
        }
    }

    public boolean start(long time) {
        this.myPreviousPositions = RobotUtils.getCurrentPositions((BundleContext)this.myContext, (Robot.Id)this.myRobotId);
        this.addRamping(RobotUtils.convertMap((Robot.RobotPositionMap)this.myPreviousPositions));
        return super.start(time + this.myRampTimeMillisec);
    }

    public boolean onStart(long time) {
        for (ServiceAddOn addon : this.myAnimation.getAddOns()) {
            Playable p = (Playable)addon.getAddOn();
            p.start(time);
        }
        if (this.myAnimationListeners != null) {
            for (AnimationJobListener listener : this.myAnimationListeners) {
                listener.animationStart(this.myRampedAnimationMap.getStartTime(), Long.valueOf(this.myRampedAnimationMap.getEndTime()));
            }
        }
        if (this.mySource != null && this.mySource instanceof RampedAnimationPlayer && this.mySignalFactory != null) {
            ArrayList<String> props = new ArrayList<String>();
            props.add("RAMPING");
            if (this.myLoopFlag) {
                props.add("LOOP");
            }
            AnimationSignal signal = this.mySignalFactory.createAnimationSignal(this.mySource.getAnimationPlayerId(), "START", this.myAnimation.getVersion().getName(), this.myAnimation.getVersion().getNumber(), this.myAnimation.hashCode(), this.myAnimation.getLength(), props);
            ((RampedAnimationPlayer)this.mySource).notifyListeners(signal);
        }
        return true;
    }

    public Long getAnimationLength() {
        long time = this.myAnimationMap.getEndTime() - this.myAnimationMap.getStartTime();
        return time;
    }

    public Long getRemainingTime(long time) {
        long now = this.getElapsedPlayTime(time);
        long end = this.getAnimationLength();
        return end - now;
    }

    protected boolean onPause(long time) {
        for (ServiceAddOn addon : this.myAnimation.getAddOns()) {
            Playable p = (Playable)addon.getAddOn();
            p.pause(time);
        }
        if (this.mySource != null && this.mySource instanceof RampedAnimationPlayer && this.mySignalFactory != null) {
            ArrayList<String> props = new ArrayList<String>();
            props.add("RAMPING");
            if (this.myLoopFlag) {
                props.add("LOOP");
            }
            AnimationSignal signal = this.mySignalFactory.createAnimationSignal(this.mySource.getAnimationPlayerId(), "PAUSE", this.myAnimation.getVersion().getName(), this.myAnimation.getVersion().getNumber(), this.myAnimation.hashCode(), this.myAnimation.getLength(), props);
            ((RampedAnimationPlayer)this.mySource).notifyListeners(signal);
        }
        return true;
    }

    protected boolean onResume(long time) {
        for (ServiceAddOn addon : this.myAnimation.getAddOns()) {
            Playable p = (Playable)addon.getAddOn();
            p.resume(time);
        }
        if (this.mySource != null && this.mySource instanceof RampedAnimationPlayer && this.mySignalFactory != null) {
            ArrayList<String> props = new ArrayList<String>();
            props.add("RAMPING");
            if (this.myLoopFlag) {
                props.add("LOOP");
            }
            AnimationSignal signal = this.mySignalFactory.createAnimationSignal(this.mySource.getAnimationPlayerId(), "RESUME", this.myAnimation.getVersion().getName(), this.myAnimation.getVersion().getNumber(), this.myAnimation.hashCode(), this.myAnimation.getLength(), props);
            ((RampedAnimationPlayer)this.mySource).notifyListeners(signal);
        }
        return true;
    }

    protected boolean onStop(long time) {
        for (ServiceAddOn addon : this.myAnimation.getAddOns()) {
            Playable p = (Playable)addon.getAddOn();
            p.stop(time);
        }
        if (this.mySource != null && this.mySource instanceof RampedAnimationPlayer && this.mySignalFactory != null) {
            ArrayList<String> props = new ArrayList<String>();
            props.add("RAMPING");
            if (this.myLoopFlag) {
                props.add("LOOP");
            }
            AnimationSignal signal = this.mySignalFactory.createAnimationSignal(this.mySource.getAnimationPlayerId(), "CANCELED", this.myAnimation.getVersion().getName(), this.myAnimation.getVersion().getNumber(), this.myAnimation.hashCode(), this.myAnimation.getLength(), props);
            ((RampedAnimationPlayer)this.mySource).notifyListeners(signal);
        }
        return true;
    }

    protected boolean onComplete(long time) {
        for (ServiceAddOn addon : this.myAnimation.getAddOns()) {
            Playable p = (Playable)addon.getAddOn();
            p.complete(time);
        }
        if (this.mySource != null && this.mySource instanceof RampedAnimationPlayer && this.mySignalFactory != null) {
            ArrayList<String> props = new ArrayList<String>();
            props.add("RAMPING");
            if (this.myLoopFlag) {
                props.add("LOOP");
            }
            AnimationSignal signal = this.mySignalFactory.createAnimationSignal(this.mySource.getAnimationPlayerId(), "COMPLETED", this.myAnimation.getVersion().getName(), this.myAnimation.getVersion().getNumber(), this.myAnimation.hashCode(), this.myAnimation.getLength(), props);
            ((RampedAnimationPlayer)this.mySource).notifyListeners(signal);
        }
        return true;
    }

    protected void afterComplete(long time) {
        if (this.myLoopFlag) {
            this.start(time);
        }
    }

    public void setLoop(boolean loop) {
        this.myLoopFlag = loop;
    }

    public boolean getLoop() {
        return this.myLoopFlag;
    }

    public void setAnimationSignalFactory(AnimationSignal.AnimationSignalFactory factory) {
        this.mySignalFactory = factory;
    }
}

