/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.integration.animation_motion;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.robokind.api.animation.editor.AnimationEditor;
import org.robokind.api.animation.editor.ChannelEditor;
import org.robokind.api.animation.editor.ControlPointEditor;
import org.robokind.api.animation.editor.EditState;
import org.robokind.api.animation.editor.MotionPathEditor;
import org.robokind.api.animation.editor.features.SynchronizedPointGroup;
import org.robokind.api.animation.editor.history.HistoryActionGroup;
import org.robokind.api.animation.editor.history.HistoryStack;
import org.robokind.api.animation.utils.PositionAdder;
import org.robokind.api.common.osgi.ClassTracker;
import org.robokind.api.common.position.NormalizableRange;
import org.robokind.api.common.position.NormalizedDouble;
import org.robokind.api.motion.Joint;
import org.robokind.api.motion.JointProperty;
import org.robokind.api.motion.Robot;

public class JointSnapshot
implements PositionAdder {
    private ClassTracker<Robot> myRobotTracker;
    private Robot.Id myRobotId;
    private BundleContext myContext;

    public JointSnapshot(BundleContext context, Robot.Id robotId) {
        if (context == null || robotId == null) {
            throw new NullPointerException();
        }
        this.myContext = context;
        this.myRobotId = robotId;
    }

    private ClassTracker<Robot> getRobotTracker() {
        if (this.myRobotTracker != null) {
            return this.myRobotTracker;
        }
        this.myRobotTracker = new ClassTracker(this.myContext, Robot.class.getName(), null, null);
        return this.myRobotTracker;
    }

    public Robot getRobot() {
        ClassTracker<Robot> tracker = this.getRobotTracker();
        return tracker == null ? null : (Robot)tracker.getTopService();
    }

    private Map<Integer, Double> getRobotSnapshot() {
        Robot robot = this.getRobot();
        if (robot == null) {
            return Collections.EMPTY_MAP;
        }
        return this.buildSnapshot(robot.getJointList());
    }

    private Map<Integer, Double> getRobotSnapshot(int ... ids) {
        Robot robot = this.getRobot();
        if (robot == null || ids.length == 0) {
            return Collections.EMPTY_MAP;
        }
        ArrayList<Joint> joints = new ArrayList<Joint>(ids.length);
        for (int id : ids) {
            joints.add(robot.getJoint(new Robot.JointId(this.myRobotId, new Joint.Id(id))));
        }
        return this.buildSnapshot(joints);
    }

    private Map<Integer, Double> buildSnapshot(List<Joint> joints) {
        if (joints == null || joints.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        HashMap<Integer, Double> myPositions = new HashMap<Integer, Double>();
        for (Joint joint : joints) {
            NormalizedDouble n;
            int id = joint.getId().getLogicalJointNumber();
            if (joint == null || myPositions.containsKey(id) || (n = this.getJointPosition(joint)) == null) continue;
            double pos = n.getValue();
            myPositions.put(id, pos);
        }
        return myPositions;
    }

    private NormalizedDouble getJointPosition(Joint joint) {
        JointProperty prop = joint.getProperty("currentPosition");
        if (prop == null) {
            return null;
        }
        NormalizableRange range = prop.getNormalizableRange();
        Object val = prop.getValue();
        if (range == null || val == null) {
            return null;
        }
        return range.normalizeValue(val);
    }

    public void addPositions(AnimationEditor editor, double x) {
        Map<Integer, Double> positions = this.getRobotSnapshot();
        this.addSnapshot(editor, x, positions);
    }

    public void addSnapshot(AnimationEditor editor, double x, int ... ids) {
        Map<Integer, Double> positions = this.getRobotSnapshot(ids);
        this.addSnapshot(editor, x, positions);
    }

    private void addSnapshot(AnimationEditor editor, double x, Map<Integer, Double> positions) {
        if (editor == null) {
            return;
        }
        List chans = editor.getChildren();
        if (chans == null || chans.isEmpty()) {
            return;
        }
        ArrayList<ControlPointEditor> points = new ArrayList<ControlPointEditor>();
        HistoryActionGroup addPos = new HistoryActionGroup("Add Positions", true);
        for (ChannelEditor chan : chans) {
            int i;
            ControlPointEditor point;
            MotionPathEditor path;
            int id = chan.getId();
            Double pos = positions.get(id);
            if (pos == null || (path = this.getBestPath(chan, x)) == null || (point = (ControlPointEditor)path.getChild(i = path.addChild((Object)this, (Object)new Point2D.Double(x, pos), (HistoryStack)addPos))) == null) continue;
            points.add(point);
        }
        if (!points.isEmpty()) {
            SynchronizedPointGroup group = new SynchronizedPointGroup(points, editor.getSharedHistory(), addPos);
        }
    }

    private MotionPathEditor getBestPath(ChannelEditor chan, double x) {
        MotionPathEditor path;
        if (chan.hasFlag(EditState.SELECTED) && (path = (MotionPathEditor)chan.getSelected()) != null) {
            return path;
        }
        List paths = chan.getChildren();
        double bestDist = Double.MAX_VALUE;
        MotionPathEditor bestPath = null;
        for (MotionPathEditor path2 : paths) {
            double start = path2.getStart();
            double end = path2.getEnd();
            if (x >= start && x <= end) {
                return path2;
            }
            double d = x < start ? start - x : x - end;
            double dist = d;
            if (!(dist < bestDist)) continue;
            bestDist = dist;
            bestPath = path2;
        }
        return bestPath;
    }
}

