/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.integration.animation_motion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jflux.api.core.Listener;
import org.jflux.api.core.util.DefaultNotifier;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.robokind.api.animation.Animation;
import org.robokind.api.animation.player.AnimationJob;
import org.robokind.api.animation.player.AnimationPlayer;
import org.robokind.api.animation.protocol.AnimationSignal;
import org.robokind.api.common.utils.TimeUtils;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.blending.FrameSource;
import org.robokind.impl.animation.messaging.PortableAnimationSignal;
import org.robokind.integration.animation_motion.AnimationJobFrameSource;

public class DefaultAnimationPlayer
extends DefaultNotifier<AnimationSignal>
implements AnimationPlayer {
    private static final Logger theLogger = Logger.getLogger(DefaultAnimationPlayer.class.getName());
    private static final long theStepLength = 40L;
    private BundleContext myContext;
    private Map<AnimationJob, ServiceRegistration> myRegistry;
    private List<AnimationJob> myAnimationJobs;
    private long myStepLength;
    private Robot.Id myRobotId;
    private static AnimationSignal.AnimationSignalFactory theSignalFactory = new PortableAnimationSignal.Factory();

    public DefaultAnimationPlayer(BundleContext context, Robot.Id robotId) {
        if (context == null || robotId == null) {
            throw new NullPointerException();
        }
        this.myContext = context;
        this.myRobotId = robotId;
        this.myAnimationJobs = new ArrayList<AnimationJob>();
        this.myStepLength = 40L;
        this.myRegistry = new HashMap<AnimationJob, ServiceRegistration>();
    }

    public void setRobotId(Robot.Id robotId) {
        if (robotId == null) {
            throw new NullPointerException();
        }
        this.myRobotId = robotId;
    }

    public Robot.Id getRobotId() {
        return this.myRobotId;
    }

    public String getAnimationPlayerId() {
        return this.myRobotId.getRobtIdString();
    }

    public void setStepLength(long val) {
        this.myStepLength = val;
    }

    public long getStepLength() {
        return this.myStepLength;
    }

    public AnimationJob playAnimation(Animation animation) {
        return this.playAnimation(animation, null, null);
    }

    public List<AnimationJob> getCurrentAnimations() {
        return Collections.unmodifiableList(this.myAnimationJobs);
    }

    public void removeAnimationJob(AnimationJob job) {
        if (job == null) {
            return;
        }
        ServiceRegistration reg = this.myRegistry.remove(job);
        if (reg == null) {
            return;
        }
        try {
            reg.unregister();
        }
        catch (IllegalStateException ex) {
            theLogger.log(Level.WARNING, "Unable to unregister AnimationJob.  Already unregistered.", ex);
        }
        this.myAnimationJobs.remove(job);
    }

    public AnimationJob playAnimation(Animation animation, Long start, Long stop) {
        String[] names = new String[]{AnimationJob.class.getName(), FrameSource.class.getName()};
        AnimationJobFrameSource job = new AnimationJobFrameSource(this, this.myRobotId, animation, this.myStepLength, start, stop);
        Properties props = new Properties();
        ((Dictionary)props).put("robotId", this.myRobotId.toString());
        ServiceRegistration reg = this.myContext.registerService(names, (Object)job, (Dictionary)props);
        job.setAnimationSignalFactory(theSignalFactory);
        this.myAnimationJobs.add(job);
        this.myRegistry.put(job, reg);
        job.start(TimeUtils.now());
        return job;
    }

    public void addAnimationSignalListener(Listener<AnimationSignal> listener) {
        this.myListeners.add(listener);
    }

    public void removeAnimationSignalListener(Listener<AnimationSignal> listener) {
        this.myListeners.remove(listener);
    }
}

