/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.integration.animation_motion;

import java.util.ArrayList;
import java.util.List;
import org.robokind.api.animation.utils.ChannelNode;
import org.robokind.api.animation.utils.ChannelsParameter;
import org.robokind.api.animation.utils.ChannelsParameterSource;
import org.robokind.api.animation.utils.DefaultChannelNode;
import org.robokind.api.common.position.NormalizableRange;
import org.robokind.api.common.position.NormalizedDouble;
import org.robokind.api.motion.Joint;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.jointgroup.JointGroup;

public class ChannelRobotParameters
implements ChannelsParameterSource {
    private Robot myRobot;
    private ChannelNode myNode;
    private List<ChannelsParameter> myChannelParameters;

    public synchronized void setRobot(Robot robot) {
        this.myRobot = robot;
        this.myChannelParameters = new ArrayList<ChannelsParameter>();
        if (robot == null) {
            return;
        }
        List joints = robot.getJointList();
        if (joints == null) {
            return;
        }
        for (Joint joint : joints) {
            int channelId = joint.getId().getLogicalJointNumber();
            String channelName = joint.getName();
            NormalizedDouble defaultPosition = joint.getDefaultPosition();
            NormalizableRange range = joint.getPositionRange();
            ChannelsParameter param = new ChannelsParameter(channelId, channelName, defaultPosition, range);
            this.addChannelParameter(param);
        }
    }

    public synchronized void setJointGroup(JointGroup group) {
        this.myNode = this.buildChannelTree(group);
    }

    public ChannelNode getChannelTree() {
        return this.myNode;
    }

    public ChannelsParameter getChannelParameter(int index) {
        return this.myChannelParameters.get(index);
    }

    public List<ChannelsParameter> getChannelParameters() {
        return this.myChannelParameters;
    }

    public void addChannelParameter(ChannelsParameter param) {
        this.myChannelParameters.add(param);
    }

    private ChannelNode buildChannelTree(JointGroup<?, ?, ?> group) {
        DefaultChannelNode root = new DefaultChannelNode();
        if (group == null) {
            return root;
        }
        root.setName(group.getName());
        for (Joint j : group.getJoints()) {
            if (j == null) continue;
            root.addChannel((ChannelNode.ChannelDefinition)new ChannelNode.DefaultChannelDefinition(j.getId().getLogicalJointNumber(), j.getName(), j.getDefaultPosition()));
        }
        for (JointGroup jg : group.getJointGroups()) {
            root.addGroup(this.buildChannelTree(jg));
        }
        return root;
    }
}

