/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.integration.animation_motion;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.JMSException;
import org.jflux.api.core.Adapter;
import org.jflux.api.core.config.Configuration;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.robokind.api.animation.lifecycle.AnimationPlayerClientLifecycle;
import org.robokind.api.animation.messaging.RemoteAnimationPlayerClient;
import org.robokind.api.animation.player.AnimationPlayer;
import org.robokind.api.animation.protocol.AnimationEvent;
import org.robokind.api.animation.protocol.AnimationSignal;
import org.robokind.api.animation.utils.AnimationEditListener;
import org.robokind.api.animation.utils.PositionAdder;
import org.robokind.api.common.lifecycle.ServiceLifecycleProvider;
import org.robokind.api.common.lifecycle.utils.SimpleLifecycle;
import org.robokind.api.common.osgi.OSGiUtils;
import org.robokind.api.common.osgi.lifecycle.OSGiComponent;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.blending.FrameSource;
import org.robokind.api.motion.messaging.RemoteRobot;
import org.robokind.api.motion.utils.RobotUtils;
import org.robokind.avrogen.animation.AnimationRecord;
import org.robokind.avrogen.animation.AnimationSignallingRecord;
import org.robokind.impl.animation.messaging.PortableAnimationEvent;
import org.robokind.impl.animation.messaging.PortableAnimationSignal;
import org.robokind.impl.messaging.lifecycle.JMSAvroAsyncReceiverLifecycle;
import org.robokind.impl.messaging.lifecycle.JMSAvroMessageSenderLifecycle;
import org.robokind.impl.messaging.utils.ConnectionManager;
import org.robokind.impl.messaging.utils.ConnectionUtils;
import org.robokind.integration.animation_motion.AnimationEditFrameSource;
import org.robokind.integration.animation_motion.JointSnapshot;
import org.robokind.integration.animation_motion.RampedAnimationPlayer;
import org.robokind.integration.animation_motion.lifecycle.RobotChannelsLifecycle;

public class AnimationMotionUtils {
    private static final Logger theLogger = Logger.getLogger(AnimationMotionUtils.class.getName());
    public static final long DEFAULT_BLENDER_INTERVAL = 40L;
    public static final int DEFAULT_MAX_RAMP_TIME_MILLISEC = 800;

    public static ServiceRegistration registerRobotAnimationPlayer(BundleContext context, Robot.Id robotId) {
        Boolean exists = OSGiUtils.serviceExists((BundleContext)context, (String)AnimationPlayer.class.getName(), (String)RobotUtils.getRobotFilter((Robot.Id)robotId));
        if (exists == null || exists.booleanValue()) {
            return null;
        }
        return AnimationMotionUtils.registerAnimationPlayer(context, robotId);
    }

    public static ServiceRegistration[] registerAnimationEditingComponents(BundleContext context, Robot robot) {
        Robot.Id robotId = robot.getRobotId();
        int n = 4;
        ServiceRegistration[] regs = new ServiceRegistration[n];
        regs[0] = AnimationMotionUtils.registerChannelRobotParams(context, robotId);
        regs[1] = AnimationMotionUtils.registerAnimationEditListener(context, robot);
        regs[2] = AnimationMotionUtils.registerJointSnapshotAdder(context, robotId);
        if (!OSGiUtils.serviceExists((BundleContext)context, RemoteAnimationPlayerClient.class, null).booleanValue()) {
            if (!(robot instanceof RemoteRobot)) {
                regs[3] = AnimationMotionUtils.registerAnimationPlayer(context, robotId);
            } else {
                AnimationMotionUtils.registerRemoteAnimPlayer(context, "robotReceiverConnectionConfig");
            }
        }
        return regs;
    }

    private static ServiceRegistration registerAnimationPlayer(BundleContext context, Robot.Id robotId) {
        RampedAnimationPlayer player = new RampedAnimationPlayer(context, robotId, 800);
        Properties props = new Properties();
        String playerId = player.getAnimationPlayerId();
        props.put("robotId", robotId.toString());
        ServiceRegistration reg = OSGiUtils.registerUniqueService((BundleContext)context, (String)AnimationPlayer.class.getName(), (String)"animationPlayerId", (String)playerId, (Object)((Object)player), (Properties)props);
        theLogger.log(Level.INFO, "OSGiAnimationPlayer Service Registered Successfully.");
        return reg;
    }

    private static synchronized void registerRemoteAnimPlayer(BundleContext context, String connectionConfigId) {
        ServiceReference[] confRefs;
        try {
            confRefs = context.getAllServiceReferences(Configuration.class.getName(), OSGiUtils.createFilter((String)"messagingConnectionConfig", (String)connectionConfigId));
        }
        catch (InvalidSyntaxException ex) {
            theLogger.log(Level.WARNING, "Unable to find connection information to create remote animation player");
            return;
        }
        if (confRefs == null || confRefs.length == 0) {
            theLogger.log(Level.WARNING, "Unable to find connection information to create remote animation player");
            return;
        }
        ServiceReference conConfRef = confRefs[0];
        Configuration conConf = (Configuration)OSGiUtils.getService(Configuration.class, (BundleContext)context, (ServiceReference)conConfRef);
        String ip = (String)conConf.getPropertyValue(String.class, (Object)"msgBrokerIp");
        Connection con = ConnectionManager.createConnection((String)"admin", (String)"admin", (String)"client1", (String)"test", (String)("tcp://" + ip + ":5672"));
        try {
            con.start();
        }
        catch (JMSException ex) {
            theLogger.log(Level.WARNING, "Unable to connect to {0}", ip);
            return;
        }
        OSGiComponent myConnectionService = new OSGiComponent(context, (ServiceLifecycleProvider)new SimpleLifecycle((Object)con, Connection.class));
        myConnectionService.start();
        ConnectionUtils.ensureSession((BundleContext)context, (String)"remoteAnimConnection", (Connection)con, null);
        ConnectionUtils.ensureDestinations((BundleContext)context, (Object[])new Object[]{"remoteAnimationRequest", "animationRequest", 1, null});
        JMSAvroMessageSenderLifecycle senderLife = new JMSAvroMessageSenderLifecycle((Adapter)new PortableAnimationEvent.MessageRecordAdapter(), AnimationEvent.class, AnimationRecord.class, "remoteAnimSender", "remoteAnimConnection", "remoteAnimationRequest");
        AnimationMotionUtils.registerEventFactory(context);
        OSGiComponent mySenderService = new OSGiComponent(context, (ServiceLifecycleProvider)senderLife);
        mySenderService.start();
        ConnectionUtils.ensureSession((BundleContext)context, (String)"remoteSignalConnection", (Connection)con, null);
        ConnectionUtils.ensureDestinations((BundleContext)context, (Object[])new Object[]{"remoteAnimationSignal", "animationSignal", 1, null});
        JMSAvroAsyncReceiverLifecycle receiverLife = new JMSAvroAsyncReceiverLifecycle((Adapter)new PortableAnimationSignal.RecordMessageAdapter(), AnimationSignal.class, AnimationSignallingRecord.class, AnimationSignallingRecord.SCHEMA$, "remoteSignalReceiver", "remoteSignalConnection", "remoteAnimationSignal");
        OSGiComponent myReceiverService = new OSGiComponent(context, (ServiceLifecycleProvider)receiverLife);
        myReceiverService.start();
        AnimationPlayerClientLifecycle myLifecycle = new AnimationPlayerClientLifecycle("remotePlayer", "remotePlayer", "remoteAnimSender", "remoteSignalReceiver", context);
        OSGiComponent myPlayerService = new OSGiComponent(context, (ServiceLifecycleProvider)myLifecycle);
        myPlayerService.start();
    }

    private static void registerEventFactory(BundleContext context) {
        if (OSGiUtils.serviceExists((BundleContext)context, AnimationEvent.AnimationEventFactory.class, null).booleanValue()) {
            return;
        }
        new OSGiComponent(context, (ServiceLifecycleProvider)new SimpleLifecycle((Object)new PortableAnimationEvent.Factory(), AnimationEvent.AnimationEventFactory.class)).start();
    }

    private static ServiceRegistration registerChannelRobotParams(BundleContext context, Robot.Id robotId) {
        RobotChannelsLifecycle lifecycle = new RobotChannelsLifecycle(robotId);
        OSGiComponent comp = new OSGiComponent(context, (ServiceLifecycleProvider)lifecycle);
        comp.start();
        return null;
    }

    private static ServiceRegistration registerAnimationEditListener(BundleContext context, Robot robot) {
        AnimationEditFrameSource aefs = new AnimationEditFrameSource(robot);
        String[] classes = new String[]{AnimationEditListener.class.getName(), FrameSource.class.getName()};
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("robotId", robot.getRobotId().toString());
        ServiceRegistration reg = context.registerService(classes, (Object)aefs, props);
        theLogger.log(Level.INFO, "AnimationEditFrameSource Service Registered Successfully.");
        return reg;
    }

    private static ServiceRegistration registerJointSnapshotAdder(BundleContext context, Robot.Id robotId) {
        JointSnapshot js = new JointSnapshot(context, robotId);
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("robotId", robotId.toString());
        ServiceRegistration reg = context.registerService(PositionAdder.class.getName(), (Object)js, props);
        theLogger.log(Level.INFO, "JointSnapshot Service Registered Successfully.");
        return reg;
    }
}

