/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.integration.animation_motion;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.robokind.api.animation.Animation;
import org.robokind.api.animation.Channel;
import org.robokind.api.animation.compiled.CompiledMap;
import org.robokind.api.animation.compiled.CompiledPath;
import org.robokind.api.animation.player.AnimationJob;
import org.robokind.api.animation.player.AnimationJobListener;
import org.robokind.api.animation.player.AnimationPlayer;
import org.robokind.api.animation.protocol.AnimationSignal;
import org.robokind.api.common.playable.AbstractPlayable;
import org.robokind.api.common.playable.PlayState;
import org.robokind.api.common.playable.Playable;
import org.robokind.api.common.position.NormalizedDouble;
import org.robokind.api.common.services.addon.ServiceAddOn;
import org.robokind.api.motion.Joint;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.blending.FrameSource;
import org.robokind.api.motion.protocol.DefaultMotionFrame;
import org.robokind.api.motion.protocol.JointPositionMap;
import org.robokind.api.motion.protocol.MotionFrame;
import org.robokind.integration.animation_motion.DefaultAnimationPlayer;

public class AnimationJobFrameSource
extends AbstractPlayable
implements AnimationJob,
FrameSource<Robot.RobotPositionMap> {
    private static final Logger theLogger = Logger.getLogger(AnimationJobFrameSource.class.getName());
    private Robot.RobotPositionMap myPreviousPositions;
    private Animation myAnimation;
    private CompiledMap myAnimationMap;
    private List<AnimationJobListener> myAnimationListeners;
    private AnimationPlayer mySource;
    private Robot.Id myRobotId;
    private boolean myLoopFlag;
    private AnimationSignal.AnimationSignalFactory mySignalFactory;

    AnimationJobFrameSource(AnimationPlayer source, Robot.Id robotId, Animation anim, long stepLength, Long start, Long stop) {
        if (robotId == null) {
            throw new NullPointerException();
        }
        if (anim == null) {
            throw new NullPointerException();
        }
        if (stepLength <= 0L) {
            throw new IllegalArgumentException("stepLength must be greater than zero");
        }
        this.myLoopFlag = false;
        this.myRobotId = robotId;
        this.myAnimationListeners = new ArrayList<AnimationJobListener>();
        this.mySource = source;
        this.myAnimation = anim;
        long s = start == null ? -1L : start;
        long e = stop == null ? -1L : stop;
        this.myAnimationMap = anim.compileMap(s, e, stepLength);
        List channels = this.myAnimation.getChannels();
        this.myPreviousPositions = new Robot.RobotPositionHashMap(channels.size());
        for (Channel c : channels) {
            CompiledPath path;
            if (c == null || (path = (CompiledPath)this.myAnimationMap.get((Object)c.getId())) == null) continue;
            Integer id = c.getId();
            double v = path.estimatePosition(0L);
            if (id == null || !NormalizedDouble.isValid((double)v)) continue;
            NormalizedDouble val = new NormalizedDouble(v);
            Joint.Id jId = new Joint.Id(id.intValue());
            Robot.JointId djId = new Robot.JointId(this.myRobotId, jId);
            this.myPreviousPositions.put((Object)djId, (Object)val);
        }
    }

    public void setSource(AnimationPlayer source) {
        this.mySource = source;
    }

    public AnimationPlayer getSource() {
        return this.mySource;
    }

    public void addAnimationListener(AnimationJobListener listener) {
        if (this.myAnimationListeners == null) {
            this.myAnimationListeners = new ArrayList<AnimationJobListener>();
        }
        if (!this.myAnimationListeners.contains(listener)) {
            this.myAnimationListeners.add(listener);
        }
    }

    public void removeAnimationListener(AnimationJobListener listener) {
        if (this.myAnimationListeners == null) {
            return;
        }
        this.myAnimationListeners.remove(listener);
    }

    public Animation getAnimation() {
        return this.myAnimation;
    }

    public Long getCurrentTime(long time) {
        Long l = this.getElapsedPlayTime(time);
        if (l == null) {
            return null;
        }
        Long s = this.myAnimationMap.getStartTime();
        if (s == null) {
            return l;
        }
        return l + s;
    }

    public Map<Integer, Double> advanceAnimation(long time, long interval) {
        MotionFrame frame = this.getMovements(time, interval);
        if (frame == null) {
            return null;
        }
        return frame.getGoalPositions();
    }

    public MotionFrame getMovements(long time, long interval) {
        Robot.JointId djId;
        Joint.Id jId;
        NormalizedDouble val;
        double pos;
        Integer id;
        CompiledPath path;
        if (this.myPlayState != PlayState.RUNNING) {
            return null;
        }
        DefaultMotionFrame frame = new DefaultMotionFrame();
        frame.setTimestampMillisecUTC(time);
        frame.setFrameLengthMillisec(interval);
        this.myPreviousPositions.clear();
        long cur = this.getCurrentTime(time);
        for (Map.Entry e : this.myAnimationMap.entrySet()) {
            path = (CompiledPath)e.getValue();
            id = (Integer)e.getKey();
            pos = path.estimatePosition(cur);
            if (id == null || !NormalizedDouble.isValid((double)pos)) continue;
            val = new NormalizedDouble(pos);
            jId = new Joint.Id(id.intValue());
            djId = new Robot.JointId(this.myRobotId, jId);
            this.myPreviousPositions.put((Object)djId, (Object)val);
        }
        frame.setPreviousPositions((JointPositionMap)this.myPreviousPositions);
        this.myPreviousPositions.clear();
        cur = this.getCurrentTime(time + interval);
        for (Map.Entry e : this.myAnimationMap.entrySet()) {
            path = (CompiledPath)e.getValue();
            id = (Integer)e.getKey();
            pos = path.estimatePosition(cur);
            if (id == null || !NormalizedDouble.isValid((double)pos)) continue;
            val = new NormalizedDouble(pos);
            jId = new Joint.Id(id.intValue());
            djId = new Robot.JointId(this.myRobotId, jId);
            this.myPreviousPositions.put((Object)djId, (Object)val);
        }
        frame.setGoalPositions((JointPositionMap)this.myPreviousPositions);
        if (this.isComplete(cur)) {
            this.complete(time);
        }
        this.advance(time);
        return frame;
    }

    private boolean isComplete(long currentTime) {
        for (Map.Entry e : this.myAnimationMap.entrySet()) {
            CompiledPath path = (CompiledPath)e.getValue();
            if (currentTime >= path.getEndTime()) continue;
            return false;
        }
        return true;
    }

    private void advance(long time) {
        if (this.myAnimationListeners == null) {
            return;
        }
        for (AnimationJobListener listener : this.myAnimationListeners) {
            listener.animationAdvanced(this.getCurrentTime(time).longValue());
        }
    }

    public boolean onStart(long time) {
        for (ServiceAddOn addon : this.myAnimation.getAddOns()) {
            Playable p = (Playable)addon.getAddOn();
            p.start(time);
        }
        if (this.myAnimationListeners != null) {
            for (AnimationJobListener listener : this.myAnimationListeners) {
                listener.animationStart(this.myAnimationMap.getStartTime(), Long.valueOf(this.myAnimationMap.getEndTime()));
            }
        }
        if (this.mySource != null && this.mySource instanceof DefaultAnimationPlayer && this.mySignalFactory != null) {
            ArrayList<String> props = new ArrayList<String>();
            if (this.myLoopFlag) {
                props.add("LOOP");
            }
            AnimationSignal signal = this.mySignalFactory.createAnimationSignal(this.mySource.getAnimationPlayerId(), "START", this.myAnimation.getVersion().getName(), this.myAnimation.getVersion().getNumber(), this.myAnimation.hashCode(), this.myAnimation.getLength(), props);
            ((DefaultAnimationPlayer)this.mySource).notifyListeners(signal);
        }
        return true;
    }

    public Long getAnimationLength() {
        return this.myAnimationMap.getEndTime() - this.myAnimationMap.getStartTime();
    }

    public Long getRemainingTime(long time) {
        long now = this.getElapsedPlayTime(time);
        long end = this.getAnimationLength();
        return end - now;
    }

    protected boolean onPause(long time) {
        for (ServiceAddOn addon : this.myAnimation.getAddOns()) {
            Playable p = (Playable)addon.getAddOn();
            p.pause(time);
        }
        if (this.mySource != null && this.mySource instanceof DefaultAnimationPlayer && this.mySignalFactory != null) {
            ArrayList<String> props = new ArrayList<String>();
            if (this.myLoopFlag) {
                props.add("LOOP");
            }
            AnimationSignal signal = this.mySignalFactory.createAnimationSignal(this.mySource.getAnimationPlayerId(), "PAUSE", this.myAnimation.getVersion().getName(), this.myAnimation.getVersion().getNumber(), this.myAnimation.hashCode(), this.myAnimation.getLength(), props);
            ((DefaultAnimationPlayer)this.mySource).notifyListeners(signal);
        }
        return true;
    }

    protected boolean onResume(long time) {
        for (ServiceAddOn addon : this.myAnimation.getAddOns()) {
            Playable p = (Playable)addon.getAddOn();
            p.resume(time);
        }
        if (this.mySource != null && this.mySource instanceof DefaultAnimationPlayer) {
            ArrayList<String> props = new ArrayList<String>();
            if (this.myLoopFlag) {
                props.add("LOOP");
            }
            AnimationSignal signal = this.mySignalFactory.createAnimationSignal(this.mySource.getAnimationPlayerId(), "RESUME", this.myAnimation.getVersion().getName(), this.myAnimation.getVersion().getNumber(), this.myAnimation.hashCode(), this.myAnimation.getLength(), props);
            ((DefaultAnimationPlayer)this.mySource).notifyListeners(signal);
        }
        return true;
    }

    protected boolean onStop(long time) {
        for (ServiceAddOn addon : this.myAnimation.getAddOns()) {
            Playable p = (Playable)addon.getAddOn();
            p.stop(time);
        }
        if (this.mySource != null && this.mySource instanceof DefaultAnimationPlayer && this.mySignalFactory != null) {
            ArrayList<String> props = new ArrayList<String>();
            if (this.myLoopFlag) {
                props.add("LOOP");
            }
            AnimationSignal signal = this.mySignalFactory.createAnimationSignal(this.mySource.getAnimationPlayerId(), "CANCELED", this.myAnimation.getVersion().getName(), this.myAnimation.getVersion().getNumber(), this.myAnimation.hashCode(), this.myAnimation.getLength(), props);
            ((DefaultAnimationPlayer)this.mySource).notifyListeners(signal);
        }
        return true;
    }

    protected boolean onComplete(long time) {
        for (ServiceAddOn addon : this.myAnimation.getAddOns()) {
            Playable p = (Playable)addon.getAddOn();
            p.complete(time);
        }
        if (this.mySource != null && this.mySource instanceof DefaultAnimationPlayer && this.mySignalFactory != null) {
            ArrayList<String> props = new ArrayList<String>();
            if (this.myLoopFlag) {
                props.add("LOOP");
            }
            AnimationSignal signal = this.mySignalFactory.createAnimationSignal(this.mySource.getAnimationPlayerId(), "COMPLETED", this.myAnimation.getVersion().getName(), this.myAnimation.getVersion().getNumber(), this.myAnimation.hashCode(), this.myAnimation.getLength(), props);
            ((DefaultAnimationPlayer)this.mySource).notifyListeners(signal);
        }
        return true;
    }

    protected void afterComplete(long time) {
        if (this.myLoopFlag) {
            this.start(time);
        }
    }

    public void setLoop(boolean loop) {
        this.myLoopFlag = loop;
    }

    public boolean getLoop() {
        return this.myLoopFlag;
    }

    public void setAnimationSignalFactory(AnimationSignal.AnimationSignalFactory factory) {
        this.mySignalFactory = factory;
    }
}

