/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.integration.animation_motion;

import java.util.Map;
import org.robokind.api.animation.utils.AnimationEditListener;
import org.robokind.api.common.position.NormalizedDouble;
import org.robokind.api.motion.Joint;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.utils.PositionTargetFrameSource;

public class AnimationEditFrameSource
extends PositionTargetFrameSource
implements AnimationEditListener {
    public AnimationEditFrameSource(Robot robot) {
        super(0.001, null);
        this.setRobot(robot);
        this.setStopOnGoal(true);
    }

    public void handlePositions(long x, Map<Integer, Double> positions) {
        Robot r = this.getRobot();
        if (r == null) {
            return;
        }
        Robot.RobotPositionHashMap posMap = new Robot.RobotPositionHashMap(positions.size());
        for (Map.Entry<Integer, Double> e : positions.entrySet()) {
            Integer id = e.getKey();
            Double rawPos = e.getValue();
            if (id == null || rawPos == null || !NormalizedDouble.isValid((double)rawPos)) continue;
            NormalizedDouble val = new NormalizedDouble(rawPos.doubleValue());
            Joint.Id jId = new Joint.Id(id.intValue());
            Robot.JointId djId = new Robot.JointId(r.getRobotId(), jId);
            posMap.put((Object)djId, (Object)val);
        }
        this.putPositions((Robot.RobotPositionMap)posMap);
    }

    public void setEditEnabled(boolean val) {
        this.setEnabled(val);
    }
}

