/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.spi.multiview;

import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.core.multiview.MultiViewCloneableTopComponent;
import org.netbeans.core.multiview.MultiViewTopComponent;
import org.netbeans.core.spi.multiview.CloseOperationHandler;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewDescription;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.openide.awt.UndoRedo;
import org.openide.util.Lookup;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.TopComponent;

public final class MultiViewFactory {
    public static final MultiViewElement BLANK_ELEMENT = new Blank();
    public static final Action NOOP_CLOSE_ACTION = new NoopAction();

    private MultiViewFactory() {
    }

    public static TopComponent createMultiView(MultiViewDescription[] descriptions, MultiViewDescription defaultDesc) {
        return MultiViewFactory.createMultiView(descriptions, defaultDesc, MultiViewFactory.createDefaultCloseOpHandler());
    }

    public static TopComponent createMultiView(MultiViewDescription[] descriptions, MultiViewDescription defaultDesc, CloseOperationHandler closeHandler) {
        if (descriptions == null) {
            return null;
        }
        if (closeHandler == null) {
            closeHandler = MultiViewFactory.createDefaultCloseOpHandler();
        }
        MultiViewTopComponent tc = new MultiViewTopComponent();
        tc.setMultiViewDescriptions(descriptions, defaultDesc);
        tc.setCloseOperationHandler(closeHandler);
        return tc;
    }

    public static CloneableTopComponent createCloneableMultiView(MultiViewDescription[] descriptions, MultiViewDescription defaultDesc) {
        return MultiViewFactory.createCloneableMultiView(descriptions, defaultDesc, MultiViewFactory.createDefaultCloseOpHandler());
    }

    public static CloneableTopComponent createCloneableMultiView(MultiViewDescription[] descriptions, MultiViewDescription defaultDesc, CloseOperationHandler closeHandler) {
        if (descriptions == null) {
            return null;
        }
        if (closeHandler == null) {
            closeHandler = MultiViewFactory.createDefaultCloseOpHandler();
        }
        MultiViewCloneableTopComponent tc = new MultiViewCloneableTopComponent();
        tc.setMultiViewDescriptions(descriptions, defaultDesc);
        tc.setCloseOperationHandler(closeHandler);
        return tc;
    }

    static CloseOperationState createSafeCloseState() {
        return new CloseOperationState(true, "ID_CLOSE_OK", NOOP_CLOSE_ACTION, NOOP_CLOSE_ACTION);
    }

    public static CloseOperationState createUnsafeCloseState(String warningId, Action proceedAction, Action discardAction) {
        return new CloseOperationState(false, warningId == null ? "" : warningId, proceedAction == null ? NOOP_CLOSE_ACTION : proceedAction, discardAction == null ? NOOP_CLOSE_ACTION : discardAction);
    }

    static CloseOperationHandler createDefaultCloseOpHandler() {
        return new DefaultCloseHandler();
    }

    private static final class Blank
    implements MultiViewElement,
    Serializable {
        private JPanel panel = new JPanel();
        private JPanel bar = new JPanel();

        Blank() {
        }

        @Override
        public void componentActivated() {
        }

        @Override
        public void componentClosed() {
        }

        @Override
        public void componentDeactivated() {
        }

        @Override
        public void componentHidden() {
        }

        @Override
        public void componentOpened() {
        }

        @Override
        public void componentShowing() {
        }

        @Override
        public Action[] getActions() {
            return new Action[0];
        }

        @Override
        public Lookup getLookup() {
            return Lookup.EMPTY;
        }

        @Override
        public JComponent getToolbarRepresentation() {
            return this.bar;
        }

        @Override
        public JComponent getVisualRepresentation() {
            return this.panel;
        }

        @Override
        public void setMultiViewCallback(MultiViewElementCallback callback) {
        }

        @Override
        public UndoRedo getUndoRedo() {
            return null;
        }

        @Override
        public CloseOperationState canCloseElement() {
            return CloseOperationState.STATE_OK;
        }
    }

    private static final class DefaultCloseHandler
    implements CloseOperationHandler,
    Serializable {
        private static final long serialVersionUID = -3126744916624172427L;

        private DefaultCloseHandler() {
        }

        @Override
        public boolean resolveCloseOperation(CloseOperationState[] elements) {
            if (elements != null) {
                boolean canBeClosed = true;
                ArrayList<CloseOperationState> badOnes = new ArrayList<CloseOperationState>();
                for (int i = 0; i < elements.length; ++i) {
                    if (elements[i].canClose()) continue;
                    badOnes.add(elements[i]);
                    canBeClosed = false;
                }
                if (!canBeClosed) {
                    throw new IllegalStateException("Cannot close component. Some of the elements require close operation handling. See MultiViewFactory.createMultiView()");
                }
            }
            return true;
        }
    }

    private static final class NoopAction
    extends AbstractAction {
        private NoopAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }
}

