/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.multiview;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Map;
import javax.swing.Action;
import org.netbeans.core.multiview.MultiViewElementCallbackDelegate;
import org.netbeans.core.multiview.MultiViewHandlerDelegate;
import org.netbeans.core.multiview.MultiViewModel;
import org.netbeans.core.multiview.MultiViewPeer;
import org.netbeans.core.multiview.SpiAccessor;
import org.netbeans.core.spi.multiview.CloseOperationHandler;
import org.netbeans.core.spi.multiview.MultiViewDescription;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.openide.awt.UndoRedo;
import org.openide.util.HelpCtx;
import org.openide.windows.TopComponent;

public final class MultiViewTopComponent
extends TopComponent
implements MultiViewModel.ActionRequestObserverFactory {
    MultiViewPeer peer = new MultiViewPeer(this, this);
    private Action[] superActions4Tests = null;

    public MultiViewTopComponent() {
        this.peer.initComponents();
        this.associateLookup(this.peer.getLookup());
        this.setName("");
        this.setFocusCycleRoot(false);
    }

    public void setMultiViewDescriptions(MultiViewDescription[] descriptions, MultiViewDescription defaultDesc) {
        this.peer.setMultiViewDescriptions(descriptions, defaultDesc);
    }

    public void setCloseOperationHandler(CloseOperationHandler handler) {
        this.peer.setCloseOperationHandler(handler);
    }

    private void setDeserializedMultiViewDescriptions(MultiViewDescription[] descriptions, MultiViewDescription defaultDesc, Map existingElements) {
        this.peer.setDeserializedMultiViewDescriptions(descriptions, defaultDesc, existingElements);
    }

    MultiViewModel getModel() {
        return this.peer.getModel();
    }

    protected void componentClosed() {
        super.componentClosed();
        this.peer.peerComponentClosed();
    }

    protected void componentShowing() {
        super.componentShowing();
        this.peer.peerComponentShowing();
    }

    protected void componentHidden() {
        super.componentHidden();
        this.peer.peerComponentHidden();
    }

    protected void componentDeactivated() {
        super.componentDeactivated();
        this.peer.peerComponentDeactivated();
    }

    protected void componentActivated() {
        super.componentActivated();
        this.peer.peerComponentActivated();
    }

    protected void componentOpened() {
        super.componentOpened();
        this.peer.peerComponentOpened();
    }

    public Action[] getActions() {
        Action[] superActions = this.superActions4Tests == null ? super.getActions() : this.superActions4Tests;
        Action[] acts = this.peer.peerGetActions(superActions);
        return acts;
    }

    void setSuperActions(Action[] acts) {
        this.superActions4Tests = acts;
    }

    public MultiViewHandlerDelegate getMultiViewHandlerDelegate() {
        return this.peer.getMultiViewHandlerDelegate();
    }

    public int getPersistenceType() {
        return this.peer.getPersistenceType();
    }

    protected String preferredID() {
        return this.peer.preferredID();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        this.peer.peerWriteExternal(out);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.peer.peerReadExternal(in);
    }

    Action[] getDefaultTCActions() {
        return super.getActions();
    }

    @Override
    public MultiViewElementCallback createElementCallback(MultiViewDescription desc) {
        return SpiAccessor.DEFAULT.createCallback(new ActReqObserver(desc));
    }

    public HelpCtx getHelpCtx() {
        return this.peer.getHelpCtx();
    }

    public String toString() {
        return "MultiViewTopComponent[name=" + this.getDisplayName() + ", peer=" + this.peer + "]";
    }

    public UndoRedo getUndoRedo() {
        UndoRedo retValue = this.peer.peerGetUndoRedo();
        if (retValue == null) {
            retValue = super.getUndoRedo();
        }
        return retValue;
    }

    public boolean canClose() {
        return this.peer.canClose();
    }

    public boolean requestFocusInWindow() {
        return this.peer.requestFocusInWindow();
    }

    public void requestFocus() {
        this.peer.requestFocus();
    }

    class ActReqObserver
    implements Serializable,
    MultiViewElementCallbackDelegate {
        private static final long serialVersionUID = -3126744916624172415L;
        private MultiViewDescription description;

        ActReqObserver(MultiViewDescription desc) {
            this.description = desc;
        }

        @Override
        public void requestActive() {
            boolean activated = MultiViewTopComponent.this.peer.isActivated();
            if (!activated) {
                MultiViewTopComponent.this.requestActive();
            }
            if (MultiViewTopComponent.this.peer.model.getActiveDescription() != this.description) {
                MultiViewTopComponent.this.peer.tabs.changeActiveManually(this.description);
                if (activated) {
                    MultiViewTopComponent.this.peer.model.getActiveElement().componentActivated();
                }
            }
        }

        @Override
        public void requestVisible() {
            MultiViewTopComponent.this.peer.tabs.changeVisibleManually(this.description);
        }

        @Override
        public Action[] createDefaultActions() {
            return MultiViewTopComponent.this.getDefaultTCActions();
        }

        @Override
        public void updateTitle(String title) {
            MultiViewTopComponent.this.setDisplayName(title);
        }

        public Object writeReplace() throws ObjectStreamException {
            return null;
        }

        public Object readResolve() throws ObjectStreamException {
            return null;
        }

        @Override
        public boolean isSelectedElement() {
            return this.description.equals(MultiViewTopComponent.this.peer.model.getActiveDescription());
        }

        @Override
        public TopComponent getTopComponent() {
            return MultiViewTopComponent.this;
        }
    }
}

