/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.vision.messaging;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jflux.api.core.Listener;
import org.robokind.api.common.playable.PlayState;
import org.robokind.api.common.utils.EventRepeater;
import org.robokind.api.common.utils.TimeUtils;
import org.robokind.api.messaging.MessageAsyncReceiver;
import org.robokind.api.messaging.MessageSender;
import org.robokind.api.messaging.services.DefaultServiceClient;
import org.robokind.api.messaging.services.ServiceCommand;
import org.robokind.api.messaging.services.ServiceCommandFactory;
import org.robokind.api.messaging.services.ServiceError;
import org.robokind.api.vision.ImageRegionList;
import org.robokind.api.vision.ImageRegionService;
import org.robokind.api.vision.messaging.RemoteImageServiceClient;

public class RemoteImageRegionServiceClient<Conf>
extends DefaultServiceClient<Conf>
implements ImageRegionService {
    private static final Logger theLogger = Logger.getLogger(RemoteImageServiceClient.class.getName());
    private String myImageRegionsServiceId;
    private MessageAsyncReceiver<ImageRegionList> myRegionsReceiver;
    private EventRepeater<ImageRegionList> myRegionsEventRepeater;

    public RemoteImageRegionServiceClient(Class<Conf> configClass, String imageRegionsServiceId, String remoteId, MessageSender<ServiceCommand> commandSender, MessageSender<Conf> configSender, MessageAsyncReceiver<ServiceError> errorReceiver, ServiceCommandFactory commandFactory, MessageAsyncReceiver<ImageRegionList> regionsReceiver) {
        super(imageRegionsServiceId, remoteId, commandSender, configSender, errorReceiver, commandFactory);
        if (imageRegionsServiceId == null) {
            throw new NullPointerException();
        }
        this.myImageRegionsServiceId = imageRegionsServiceId;
        this.myRegionsReceiver = regionsReceiver;
        this.myRegionsEventRepeater = new EventRepeater();
    }

    @Override
    public String getImageServiceId() {
        return this.myImageRegionsServiceId;
    }

    @Override
    public void start() {
        super.start(TimeUtils.now());
    }

    @Override
    public void stop() {
        super.stop(TimeUtils.now());
    }

    public boolean onComplete(long time) {
        return this.playStateChange(super.onComplete(time), PlayState.COMPLETED);
    }

    public boolean onPause(long time) {
        return this.playStateChange(super.onPause(time), PlayState.PAUSED);
    }

    public boolean onResume(long time) {
        return this.playStateChange(super.onResume(time), PlayState.RUNNING);
    }

    public boolean onStart(long time) {
        return this.playStateChange(super.onStart(time), PlayState.RUNNING);
    }

    public boolean onStop(long time) {
        return this.playStateChange(super.onStop(time), PlayState.STOPPED);
    }

    private boolean playStateChange(boolean attempt, PlayState state) {
        if (!attempt) {
            return false;
        }
        if (this.myRegionsReceiver == null) {
            theLogger.log(Level.INFO, "PlayState changed to {0}, but ImageReceiver is null.", state);
            return true;
        }
        if (state == PlayState.RUNNING) {
            theLogger.log(Level.INFO, "PlayState changed to {0}, adding repeater to ImageReceiver.", state);
            this.myRegionsReceiver.addListener(this.myRegionsEventRepeater);
        } else {
            theLogger.log(Level.INFO, "PlayState changed to {0}, removing repeater from ImageReceiver.", state);
            this.myRegionsReceiver.removeListener(this.myRegionsEventRepeater);
        }
        return true;
    }

    public void setImageRegionsReceiver(MessageAsyncReceiver<ImageRegionList> receiver) {
        if (this.myRegionsReceiver != null) {
            this.myRegionsReceiver.removeListener(this.myRegionsEventRepeater);
        }
        this.myRegionsReceiver = receiver;
        if (this.myRegionsReceiver != null && PlayState.RUNNING == this.getPlayState()) {
            this.myRegionsReceiver.addListener(this.myRegionsEventRepeater);
        }
    }

    @Override
    public void addImageRegionsListener(Listener<ImageRegionList> listener) {
        this.myRegionsEventRepeater.addListener(listener);
    }

    @Override
    public void removeImageRegionsListener(Listener<ImageRegionList> listener) {
        this.myRegionsEventRepeater.removeListener(listener);
    }
}

