/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.integration.netbeans;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.robokind.api.common.config.FileSystemAdapter;
import org.robokind.api.common.lifecycle.utils.ManagedServiceFactory;
import org.robokind.api.common.osgi.lifecycle.OSGiComponentFactory;
import org.robokind.api.common.utils.RKConstants;
import org.robokind.api.motion.Robot;
import org.robokind.extern.utils.apache_commons_configuration.ConfigUtils;
import org.robokind.integration.motion_speech.VisemeMotionUtils;
import org.rwshop.integration.netbeans.NetBeansRelativeFileAdapter;
import org.rwshop.swing.common.utils.SettingsRepository;

public class Activator
implements BundleActivator {
    private static final Logger theLogger = Logger.getLogger(Activator.class.getName());

    public void start(BundleContext context) throws Exception {
        Logger.getLogger("org.netbeans.core.netigso.Netigso").setLevel(Level.WARNING);
        theLogger.log(Level.INFO, "Activating NetBeans Adapter Bundle");
        this.setFileSystem(context);
        this.initSettings();
        this.startVisemes(context);
        theLogger.log(Level.INFO, "NetBeans Adapter Bundle Activation Complete");
    }

    public void stop(BundleContext context) throws Exception {
    }

    private void setFileSystem(BundleContext context) {
        String cluster = "robokind";
        NetBeansRelativeFileAdapter fs = new NetBeansRelativeFileAdapter(this.getRoot() + "/" + cluster + "/");
        ConfigUtils.setFileSystemAdapter((FileSystemAdapter)fs);
    }

    private String getRoot() {
        String dir;
        String dir2;
        String brandingToken = "robokindcontroller";
        File f = new File(".");
        String path = f.getAbsolutePath();
        theLogger.info(path);
        int len = path.length();
        if (len >= 5 && (dir2 = path.substring(len - 5, len - 2).toLowerCase()).equals("bin")) {
            return "..";
        }
        int blen = brandingToken.length() + 2;
        if (len >= blen && (dir = path.substring(len - blen, len - 2).toLowerCase()).equals(brandingToken)) {
            return ".";
        }
        return "./target/" + brandingToken;
    }

    private void startVisemes(BundleContext context) {
        OSGiComponentFactory fact = new OSGiComponentFactory(context);
        String speechServiceId = RKConstants.DEFAULT_SPEECH_ID;
        String path = this.getRoot() + "/robokind/resources/VisemeConf.json";
        VisemeMotionUtils.startVisemeFrameSourceGroup((ManagedServiceFactory)fact, (Robot.Id)new Robot.Id(RKConstants.PHYSICAL_R50_ID), (String)speechServiceId, (String)path);
    }

    private void initSettings() {
        SettingsRepository.initSettings();
    }
}

