/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.NotSerializableException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.openide.text.Installer;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.UndoRedo;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.NbDocument;
import org.openide.text.QuietEditorPane;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.UserQuestionException;
import org.openide.util.Utilities;
import org.openide.windows.CloneableOpenSupport;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class CloneableEditor
extends CloneableTopComponent
implements CloneableEditorSupport.Pane {
    private static final String HELP_ID = "editing.editorwindow";
    static final long serialVersionUID = -185739563792410059L;
    private static final RequestProcessor RP = new RequestProcessor("org.openide.text Editor Initialization");
    private static final RequestProcessor RPPostprocessing = new RequestProcessor("org.openide.text Document Postprocessing");
    protected JEditorPane pane;
    private CloneableEditorSupport support;
    private boolean initialized;
    private boolean initVisualFinished;
    private static boolean waitingOnInitVisual;
    private static boolean isModalDialog;
    private boolean isDocLoadingCanceled = false;
    private boolean isComponentOpened = false;
    private int cursorPosition = -1;
    private final boolean[] CLOSE_LAST_LOCK = new boolean[1];
    private static List<AWTQuery> tbdList;
    private static List<AWTQuery> finishedList;
    private Component customComponent;
    private JToolBar customToolbar;
    private DoInitialize doInitialize;
    private static final Logger LOG;
    static final Logger TIMER;

    public CloneableEditor() {
        this(null);
    }

    public CloneableEditor(CloneableEditorSupport support) {
        this.support = support;
        this.updateName();
        this._setCloseOperation();
        this.setMinimumSize(new Dimension(10, 10));
    }

    private void _setCloseOperation() {
        this.setCloseOperation(0);
    }

    protected CloneableEditorSupport cloneableEditorSupport() {
        return this.support;
    }

    public int getPersistenceType() {
        return 1;
    }

    public HelpCtx getHelpCtx() {
        HelpCtx fromKit;
        EditorKit kit = this.support.cesKit();
        HelpCtx helpCtx = fromKit = kit == null ? null : HelpCtx.findHelp((Object)kit);
        if (fromKit != null) {
            return fromKit;
        }
        return new HelpCtx(HELP_ID);
    }

    public boolean canClose() {
        boolean result = super.canClose();
        return result;
    }

    protected void componentShowing() {
        super.componentShowing();
        this.initialize();
    }

    private void initialize() {
        if (this.initialized || this.discard()) {
            return;
        }
        QuietEditorPane tmp = new QuietEditorPane();
        tmp.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CloneableEditor.class, (String)"ACS_CloneableEditor_QuietEditorPane", (Object)this.getName()));
        tmp.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CloneableEditor.class, (String)"ACSD_CloneableEditor_QuietEditorPane", (Object)this.getAccessibleContext().getAccessibleDescription()));
        this.pane = tmp;
        this.initialized = true;
        this.isComponentOpened = true;
        this.doInitialize = new DoInitialize(tmp);
    }

    final boolean newInitialize() {
        if (Boolean.getBoolean("org.openide.text.CloneableEditor.oldInitialize")) {
            return false;
        }
        return !Boolean.TRUE.equals(this.getClientProperty("oldInitialize"));
    }

    protected CloneableTopComponent createClonedObject() {
        return this.support.createCloneableTopComponent();
    }

    protected void componentOpened() {
        super.componentOpened();
        CloneableEditorSupport ces = this.cloneableEditorSupport();
        if (ces != null) {
            ces.firePropertyChange("openedPanes", null, null);
            StyledDocument d = ces.getDocument();
            if (d != null) {
                String mimeType = (String)d.getProperty("mimeType");
                Installer.add(mimeType);
            }
        }
    }

    protected void componentClosed() {
        if (this.pane != null) {
            this.pane.setEditorKit(null);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CloneableEditor.this.removeAll();
            }
        });
        this.customComponent = null;
        this.customToolbar = null;
        this.pane = null;
        this.initialized = false;
        this.initVisualFinished = false;
        this.isComponentOpened = false;
        super.componentClosed();
        CloneableEditorSupport ces = this.cloneableEditorSupport();
        if (ces != null) {
            ces.firePropertyChange("openedPanes", null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean closeLast() {
        if (!this.support.canClose()) {
            return false;
        }
        boolean[] blArray = this.CLOSE_LAST_LOCK;
        synchronized (this.CLOSE_LAST_LOCK) {
            if (this.CLOSE_LAST_LOCK[0]) {
                this.CLOSE_LAST_LOCK[0] = false;
            } else {
                this.support.notifyClosed();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (this.support.getLastSelected() == this) {
                this.support.setLastSelected(null);
            }
            return true;
        }
    }

    public UndoRedo getUndoRedo() {
        return this.support.getUndoRedo();
    }

    public Action[] getActions() {
        ArrayList<Action> actions = new ArrayList<Action>(Arrays.asList(super.getActions()));
        actions.add(null);
        actions.addAll(Utilities.actionsForPath((String)"Editors/TabActions"));
        return actions.toArray(new Action[actions.size()]);
    }

    @Deprecated
    public void requestFocus() {
        super.requestFocus();
        if (this.pane != null) {
            if (this.customComponent != null && !SwingUtilities.isDescendingFrom(this.pane, this.customComponent)) {
                this.customComponent.requestFocus();
            } else {
                this.pane.requestFocus();
            }
        }
    }

    @Deprecated
    public boolean requestFocusInWindow() {
        super.requestFocusInWindow();
        if (this.pane != null) {
            if (this.customComponent != null && !SwingUtilities.isDescendingFrom(this.pane, this.customComponent)) {
                return this.customComponent.requestFocusInWindow();
            }
            return this.pane.requestFocusInWindow();
        }
        return false;
    }

    @Deprecated
    public boolean requestDefaultFocus() {
        if (this.customComponent != null && !SwingUtilities.isDescendingFrom(this.pane, this.customComponent)) {
            return this.customComponent.requestFocusInWindow();
        }
        if (this.pane != null) {
            return this.pane.requestFocusInWindow();
        }
        return false;
    }

    public Dimension getPreferredSize() {
        Rectangle bounds = WindowManager.getDefault().getCurrentWorkspace().getBounds();
        return new Dimension(bounds.width / 2, bounds.height / 2);
    }

    public void open() {
        boolean wasNull = this.getClientProperty("TopComponentAllowDockAnywhere") == null;
        super.open();
        if (wasNull) {
            this.putClientProperty("TopComponentAllowDockAnywhere", null);
        }
    }

    private Action getAction(String key) {
        if (key == null) {
            return null;
        }
        EditorKit kit = this.support.cesKit();
        if (kit == null) {
            return null;
        }
        Action[] actions = kit.getActions();
        for (int i = 0; i < actions.length; ++i) {
            if (!key.equals(actions[i].getValue("Name"))) continue;
            return actions[i];
        }
        return null;
    }

    protected void componentActivated() {
        this.support.setLastSelected(this);
    }

    @Override
    public void updateName() {
        final CloneableEditorSupport ces = this.cloneableEditorSupport();
        if (ces != null) {
            Mutex.EVENT.writeAccess(new Runnable(){

                @Override
                public void run() {
                    String name = ces.messageHtmlName();
                    CloneableEditor.this.setHtmlDisplayName(name);
                    name = ces.messageName();
                    CloneableEditor.this.setDisplayName(name);
                    CloneableEditor.this.setName(name);
                    CloneableEditor.this.setToolTipText(ces.messageToolTip());
                }
            });
        }
    }

    protected String preferredID() {
        CloneableEditorSupport ces = this.cloneableEditorSupport();
        if (ces != null) {
            return ces.documentID();
        }
        return "";
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.support != null ? this.support.cesEnv() : null);
        int pos = 0;
        JEditorPane p = this.pane;
        if (p != null) {
            Caret caret = p.getCaret();
            if (caret != null) {
                pos = caret.getDot();
            } else if (p instanceof QuietEditorPane) {
                int lastPos = ((QuietEditorPane)p).getLastPosition();
                if (lastPos == -1) {
                    Logger.getLogger(CloneableEditor.class.getName()).log(Level.WARNING, null, new IllegalStateException("Pane=" + p + "was not initialized yet!"));
                } else {
                    pos = lastPos;
                }
            } else {
                StyledDocument doc;
                StyledDocument styledDocument = doc = this.support != null ? this.support.getDocument() : null;
                if (doc != null) {
                    Logger.getLogger(CloneableEditor.class.getName()).log(Level.WARNING, null, new IllegalStateException("Caret is null in editor pane=" + p + "\nsupport=" + (Object)((Object)this.support) + "\ndoc=" + doc));
                }
            }
        }
        out.writeObject(new Integer(pos));
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        Object firstObject = in.readObject();
        if (firstObject instanceof CloneableOpenSupport.Env) {
            CloneableOpenSupport.Env env = (CloneableOpenSupport.Env)firstObject;
            CloneableOpenSupport os = env.findCloneableOpenSupport();
            this.support = (CloneableEditorSupport)os;
        }
        int offset = (Integer)in.readObject();
        if (!this.discard()) {
            this.cursorPosition = offset;
        }
        this.updateName();
        this.isComponentOpened = true;
    }

    protected Object writeReplace() throws ObjectStreamException {
        if (this.discard()) {
            throw new NotSerializableException("Serializing component is invalid: " + this);
        }
        return super.writeReplace();
    }

    protected Object readResolve() throws ObjectStreamException {
        if (this.discard()) {
            throw new InvalidObjectException("Deserialized component is invalid: " + this);
        }
        this.support.initializeCloneableEditor(this);
        return this;
    }

    private boolean discard() {
        return this.support == null || !this.support.cesEnv().isValid();
    }

    @Override
    public CloneableTopComponent getComponent() {
        return this;
    }

    boolean isEditorPaneReady() {
        assert (SwingUtilities.isEventDispatchThread());
        return this.initVisualFinished;
    }

    boolean isEditorPaneReadyTest() {
        return this.initVisualFinished;
    }

    @Override
    public JEditorPane getEditorPane() {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.isDocLoadingCanceled || !this.isComponentOpened) {
            return null;
        }
        if (isModalDialog) {
            LOG.log(Level.WARNING, "AWT is blocked by modal dialog. Return null from CloneableEditor.getEditorPane. Please report this to IZ.");
            LOG.log(Level.WARNING, "support:" + ((Object)((Object)this.support)).getClass().getName());
            Exception ex = new Exception();
            StringWriter sw = new StringWriter(500);
            PrintWriter pw = new PrintWriter(sw);
            ex.printStackTrace(pw);
            LOG.log(Level.WARNING, sw.toString());
            return null;
        }
        this.initialize();
        DoInitialize d = this.doInitialize;
        if (d != null && !Thread.holdsLock(this.support.getLock())) {
            waitingOnInitVisual = true;
            d.initVisual();
            waitingOnInitVisual = false;
        }
        return this.pane;
    }

    @Override
    public void ensureVisible() {
        this.open();
        this.requestVisible();
    }

    static /* synthetic */ boolean access$502(CloneableEditor x0, boolean x1) {
        x0.isDocLoadingCanceled = x1;
        return x0.isDocLoadingCanceled;
    }

    static /* synthetic */ boolean access$700() {
        return waitingOnInitVisual;
    }

    static /* synthetic */ boolean access$1102(CloneableEditor x0, boolean x1) {
        x0.isComponentOpened = x1;
        return x0.isComponentOpened;
    }

    static /* synthetic */ Action access$1200(CloneableEditor x0, String x1) {
        return x0.getAction(x1);
    }

    static {
        tbdList = Collections.synchronizedList(new ArrayList());
        finishedList = Collections.synchronizedList(new ArrayList());
        LOG = Logger.getLogger("org.openide.text.CloneableEditor");
        TIMER = Logger.getLogger("TIMER");
    }

    class AWTQuery
    implements Runnable {
        private UserQuestionException ex;
        private boolean isConfirmed;

        public AWTQuery(UserQuestionException ex) {
            this.ex = ex;
        }

        public boolean confirmed() {
            return this.isConfirmed;
        }

        @Override
        public void run() {
            NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)this.ex.getLocalizedMessage(), 0);
            nd.setOptions(new Object[]{NotifyDescriptor.YES_OPTION, NotifyDescriptor.NO_OPTION});
            isModalDialog = true;
            Object res = DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            isModalDialog = false;
            this.isConfirmed = NotifyDescriptor.OK_OPTION.equals(res);
        }

        static /* synthetic */ boolean access$1000(AWTQuery x0) {
            return x0.isConfirmed;
        }
    }

    class DoInitialize
    implements Runnable,
    ActionListener {
        private final QuietEditorPane tmp;
        private Document doc;
        private RequestProcessor.Task task;
        private int phase;
        private EditorKit kit;
        private JComponent tmpComp;
        private boolean initialized = false;
        private boolean isInInitVisual = false;
        private boolean confirmed = false;

        public DoInitialize(QuietEditorPane tmp) {
            this.tmp = tmp;
            this.tmpComp = this.initLoading();
            new Timer(1000, this).start();
            if (CloneableEditor.this.newInitialize()) {
                this.task = RP.create((Runnable)this);
                this.task.setPriority(3);
                this.task.schedule(0);
            } else {
                this.run();
            }
        }

        private JComponent initLoading() {
            CloneableEditor.this.setLayout(new BorderLayout());
            JLabel loadingLbl = new JLabel(NbBundle.getMessage(CloneableEditor.class, (String)"LBL_EditorLoading"));
            loadingLbl.setOpaque(true);
            loadingLbl.setHorizontalAlignment(0);
            loadingLbl.setBorder(new EmptyBorder(new Insets(11, 11, 11, 11)));
            loadingLbl.setVisible(false);
            CloneableEditor.this.add(loadingLbl, "Center");
            return loadingLbl;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.tmpComp.setVisible(true);
            Timer t = (Timer)e.getSource();
            t.stop();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long now = System.currentTimeMillis();
            int phaseNow = this.phase;
            switch (this.phase++) {
                case 0: {
                    boolean[] blArray = CloneableEditor.this.CLOSE_LAST_LOCK;
                    synchronized (blArray) {
                        ((CloneableEditor)CloneableEditor.this).CLOSE_LAST_LOCK[0] = true;
                    }
                    this.phase = this.initNonVisual(this.phase);
                    blArray = CloneableEditor.this.CLOSE_LAST_LOCK;
                    synchronized (blArray) {
                        if (!CloneableEditor.this.CLOSE_LAST_LOCK[0]) {
                            CloneableEditor.this.support.notifyClosed();
                            this.phase = Integer.MAX_VALUE;
                        }
                        ((CloneableEditor)CloneableEditor.this).CLOSE_LAST_LOCK[0] = false;
                    }
                    if (this.phase == Integer.MAX_VALUE) break;
                    if (CloneableEditor.this.newInitialize()) {
                        WindowManager.getDefault().invokeWhenUIReady((Runnable)this);
                        break;
                    }
                }
                case 1: {
                    if (CloneableEditor.this.pane != this.tmp) {
                        this.phase = Integer.MAX_VALUE;
                        break;
                    }
                    if (CloneableEditor.this.support.getDocument() == null || CloneableEditor.this.support.cesKit() == null) {
                        this.phase = Integer.MAX_VALUE;
                        break;
                    }
                    this.initVisual();
                    if (CloneableEditor.this.newInitialize()) {
                        this.task.schedule(1000);
                        break;
                    }
                }
                case 2: {
                    this.initRest();
                    break;
                }
                default: {
                    throw new IllegalStateException("Wrong phase: " + this.phase + " for " + (Object)((Object)CloneableEditor.this.support));
                }
            }
            long howLong = System.currentTimeMillis() - now;
            if (TIMER.isLoggable(Level.FINE)) {
                Object who;
                String thread = SwingUtilities.isEventDispatchThread() ? "AWT" : "RP";
                Document d = this.doc;
                Object object = who = d == null ? null : d.getProperty("stream");
                if (who == null) {
                    who = CloneableEditor.this.support.messageName();
                }
                TIMER.log(Level.FINE, "Open Editor, phase " + phaseNow + ", " + thread + " [ms]", new Object[]{who, howLong});
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private int initNonVisual(int phase) {
            block39: {
                block38: {
                    if (CloneableEditor.access$400().isLoggable(Level.FINE)) {
                        CloneableEditor.access$400().log(Level.FINE, "DoInitialize.initNonVisual Enter Time:" + System.currentTimeMillis() + " Thread:" + Thread.currentThread().getName() + " ce:[" + Integer.toHexString(System.identityHashCode(CloneableEditor.this)) + "]" + " support:[" + Integer.toHexString(System.identityHashCode((Object)CloneableEditor.access$300(CloneableEditor.this))) + "]" + " Name:" + CloneableEditor.this.getName());
                    }
                    prepareTask = CloneableEditor.access$300(CloneableEditor.this).prepareDocument();
                    if (!DoInitialize.$assertionsDisabled && prepareTask == null) {
                        throw new AssertionError((Object)"Failed to get prepareTask");
                    }
                    prepareTask.waitFinished();
                    ex = CloneableEditor.access$300(CloneableEditor.this).getPrepareDocumentRuntimeException();
                    if (ex == null) {
                        CloneableEditor.access$502(CloneableEditor.this, false);
                    }
                    if (!CloneableEditor.access$300(CloneableEditor.this).asynchronousOpen()) break block38;
                    if (ex instanceof CloneableEditorSupport.DelegateIOExc && ex.getCause() instanceof UserQuestionException) {
                        if (CloneableEditor.access$700()) {
                            e /* !! */  = (UserQuestionException)ex.getCause();
                            query /* !! */  = new AWTQuery(e /* !! */ );
                            CloneableEditor.access$800().add(query /* !! */ );
                            var6_9 = this;
                            synchronized (var6_9) {
                                this.notifyAll();
                                try {
                                    while (CloneableEditor.access$900().isEmpty() || !CloneableEditor.access$900().remove(query /* !! */ )) {
                                        this.wait();
                                    }
                                }
                                catch (InterruptedException exc) {
                                    Exceptions.printStackTrace((Throwable)exc);
                                }
                                ** if (!AWTQuery.access$1000((AWTQuery)query /* !! */ )) goto lbl35
                            }
lbl-1000:
                            // 1 sources

                            {
                                this.confirmed = true;
                                try {
                                    e /* !! */ .confirmed();
                                }
                                catch (IOException ex1) {
                                    Exceptions.printStackTrace((Throwable)ex1);
                                }
                            }
lbl35:
                            // 2 sources

                        } else {
                            query = new 1Query();
                            try {
                                SwingUtilities.invokeLater(query);
                                if (query.awaitAWT()) {
                                    query.waitRest();
                                } else {
                                    this.confirmed = true;
                                }
                                query /* !! */  = query;
                                synchronized (query /* !! */ ) {
                                    query.finished = true;
                                }
                            }
                            catch (InterruptedException exc) {
                                Exceptions.printStackTrace((Throwable)exc);
                            }
                        }
                        if (!this.confirmed) {
                            CloneableEditor.access$502(CloneableEditor.this, true);
                            e /* !! */  = this;
                            synchronized (e /* !! */ ) {
                                this.notifyAll();
                            }
                            CloneableEditor.access$1102(CloneableEditor.this, false);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    CloneableEditor.this.close();
                                }
                            });
                            return 0x7FFFFFFF;
                        }
                        CloneableEditor.access$502(CloneableEditor.this, false);
                        e /* !! */  = (UserQuestionException)ex.getCause();
                        try {
                            e /* !! */ .confirmed();
                        }
                        catch (IOException ex1) {
                            Exceptions.printStackTrace((Throwable)ex1);
                        }
                        prepareTask = CloneableEditor.access$300(CloneableEditor.this).prepareDocument();
                        if (!DoInitialize.$assertionsDisabled && prepareTask == null) {
                            throw new AssertionError((Object)"Failed to get prepareTask");
                        }
                        prepareTask.waitFinished();
                    }
                    break block39;
                }
                if (ex instanceof CloneableEditorSupport.DelegateIOExc && ex.getCause() instanceof UserQuestionException) {
                    e /* !! */  = (UserQuestionException)ex.getCause();
                    try {
                        e /* !! */ .confirmed();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    prepareTask = CloneableEditor.access$300(CloneableEditor.this).prepareDocument();
                    if (!DoInitialize.$assertionsDisabled && prepareTask == null) {
                        throw new AssertionError((Object)"Failed to get prepareTask");
                    }
                    prepareTask.waitFinished();
                }
            }
            am = CloneableEditor.this.getActionMap();
            paneMap = this.tmp.getActionMap();
            am.setParent(paneMap);
            paneMap.put("cut-to-clipboard", CloneableEditor.access$1200(CloneableEditor.this, "cut-to-clipboard"));
            paneMap.put("copy-to-clipboard", CloneableEditor.access$1200(CloneableEditor.this, "copy-to-clipboard"));
            paneMap.put("delete", CloneableEditor.access$1200(CloneableEditor.this, "delete-next"));
            paneMap.put("paste-from-clipboard", CloneableEditor.access$1200(CloneableEditor.this, "paste-from-clipboard"));
            k = CloneableEditor.access$300(CloneableEditor.this).cesKit();
            if (CloneableEditor.this.newInitialize() && k instanceof Callable) {
                try {
                    ((Callable)k).call();
                }
                catch (Exception e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
            }
            var7_13 = this;
            synchronized (var7_13) {
                this.doc = CloneableEditor.access$300(CloneableEditor.this).getDocument();
                if (this.doc == null && CloneableEditor.access$400().isLoggable(Level.FINE)) {
                    CloneableEditor.access$400().log(Level.FINE, "DoInitialize.initNonVisual CANNOT set kit because doc is null! Time:" + System.currentTimeMillis() + " Thread:" + Thread.currentThread().getName() + " ce:[" + Integer.toHexString(System.identityHashCode(CloneableEditor.this)) + "]" + " this:[" + Integer.toHexString(System.identityHashCode(this)) + "]" + " support:[" + Integer.toHexString(System.identityHashCode((Object)CloneableEditor.access$300(CloneableEditor.this))) + "]" + " Name:" + CloneableEditor.this.getName() + " kit:" + this.kit);
                }
                if (!DoInitialize.$assertionsDisabled && this.doc == null) {
                    throw new AssertionError();
                }
                this.kit = k;
                this.initialized = true;
                if (CloneableEditor.access$400().isLoggable(Level.FINE)) {
                    CloneableEditor.access$400().log(Level.FINE, "DoInitialize.initNonVisual doc and kit are set Time:" + System.currentTimeMillis() + " Thread:" + Thread.currentThread().getName() + " ce:[" + Integer.toHexString(System.identityHashCode(CloneableEditor.this)) + "]" + " this:[" + Integer.toHexString(System.identityHashCode(this)) + "]" + " support:[" + Integer.toHexString(System.identityHashCode((Object)CloneableEditor.access$300(CloneableEditor.this))) + "]" + " Name:" + CloneableEditor.this.getName() + " doc:" + this.doc + " kit:" + this.kit);
                    CloneableEditor.access$400().log(Level.FINE, "DoInitialize.initNonVisual Call notifyAll Time:" + System.currentTimeMillis() + " Thread:" + Thread.currentThread().getName() + " [" + Integer.toHexString(System.identityHashCode(CloneableEditor.this)) + "]" + " Name:" + CloneableEditor.this.getName());
                }
                this.notifyAll();
                return phase;
            }
        }

        private void initCustomEditor() {
            if (this.doc instanceof NbDocument.CustomEditor) {
                NbDocument.CustomEditor ce = (NbDocument.CustomEditor)this.doc;
                CloneableEditor.this.customComponent = ce.createEditor(this.tmp);
                if (CloneableEditor.this.customComponent == null) {
                    throw new IllegalStateException("Document:" + this.doc + " implementing NbDocument.CustomEditor may not" + " return null component");
                }
            }
        }

        private void initDecoration() {
            if (this.doc instanceof NbDocument.CustomToolbar) {
                NbDocument.CustomToolbar ce = (NbDocument.CustomToolbar)this.doc;
                CloneableEditor.this.customToolbar = ce.createToolbar(this.tmp);
                if (CloneableEditor.this.customToolbar == null) {
                    throw new IllegalStateException("Document:" + this.doc + " implementing NbDocument.CustomToolbar may not" + " return null toolbar");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean initDocument() {
            DoInitialize doInitialize = this;
            synchronized (doInitialize) {
                while (true) {
                    if (!tbdList.isEmpty()) {
                        while (!tbdList.isEmpty()) {
                            AWTQuery query = (AWTQuery)tbdList.remove(0);
                            query.run();
                            finishedList.add(query);
                        }
                        this.notifyAll();
                    }
                    Document d = this.doc;
                    EditorKit k = this.kit;
                    if (this.initialized) {
                        // MONITOREXIT @DISABLED, blocks:[2, 4, 8] lbl15 : MonitorExitStatement: MONITOREXIT : var3_1
                        if (this.tmp.getDocument() == d) break;
                        this.tmp.setEditorKit(k);
                        this.tmp.setWorking(1);
                        this.tmp.setDocument(d);
                        return true;
                    }
                    if (CloneableEditor.this.isDocLoadingCanceled) {
                        CloneableEditor.this.pane = null;
                        return false;
                    }
                    try {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.log(Level.FINE, "DoInitialize.initDocument Starting wait Time:" + System.currentTimeMillis() + " Thread:" + Thread.currentThread().getName() + " ce:[" + Integer.toHexString(System.identityHashCode(CloneableEditor.this)) + "]" + " this:[" + Integer.toHexString(System.identityHashCode(this)) + "]" + " support:[" + Integer.toHexString(System.identityHashCode((Object)CloneableEditor.this.support)) + "]" + " Name:" + CloneableEditor.this.getName() + " doc:" + d + " kit:" + k);
                        }
                        this.wait();
                        if (!LOG.isLoggable(Level.FINE)) continue;
                        LOG.log(Level.FINE, "DoInitialize.initDocument Wait finished Thread:" + Thread.currentThread().getName() + " ce:[" + Integer.toHexString(System.identityHashCode(CloneableEditor.this)) + "]" + " this:[" + Integer.toHexString(System.identityHashCode(this)) + "]" + " support:[" + Integer.toHexString(System.identityHashCode((Object)CloneableEditor.this.support)) + "]" + " Name:" + CloneableEditor.this.getName() + " doc:" + d + " kit:" + k);
                    }
                    catch (InterruptedException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
            return false;
        }

        final void initVisual() {
            Caret caret;
            if (CloneableEditor.this.isDocLoadingCanceled) {
                return;
            }
            if (this.isInInitVisual) {
                return;
            }
            this.isInInitVisual = true;
            if (!this.initDocument()) {
                this.isInInitVisual = false;
                return;
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "DoInitialize.initVisual Enter Time:" + System.currentTimeMillis() + " Thread:" + Thread.currentThread().getName() + " ce:[" + Integer.toHexString(System.identityHashCode(CloneableEditor.this)) + "]" + " this:[" + Integer.toHexString(System.identityHashCode(this)) + "]" + " support:[" + Integer.toHexString(System.identityHashCode((Object)CloneableEditor.this.support)) + "]" + " Name:" + CloneableEditor.this.getName());
            }
            this.initCustomEditor();
            if (CloneableEditor.this.customComponent != null) {
                CloneableEditor.this.add(CloneableEditor.this.support.wrapEditorComponent(CloneableEditor.this.customComponent), "Center");
            } else {
                JScrollPane noBorderPane = new JScrollPane(this.tmp);
                this.tmp.setBorder(null);
                CloneableEditor.this.add(CloneableEditor.this.support.wrapEditorComponent(noBorderPane), "Center");
            }
            this.initDecoration();
            if (CloneableEditor.this.customToolbar != null) {
                Border b = (Border)UIManager.get("Nb.Editor.Toolbar.border");
                CloneableEditor.this.customToolbar.setBorder(b);
                CloneableEditor.this.add(CloneableEditor.this.customToolbar, "North");
            }
            CloneableEditor.this.remove(this.tmpComp);
            this.tmp.setWorking(3);
            if (CloneableEditor.this.cursorPosition != -1 && (caret = this.tmp.getCaret()) != null) {
                caret.setDot(CloneableEditor.this.cursorPosition);
            }
            ActionMap p = CloneableEditor.this.getActionMap().getParent();
            CloneableEditor.this.getActionMap().setParent(null);
            CloneableEditor.this.getActionMap().setParent(p);
            if (CloneableEditor.this.equals(TopComponent.getRegistry().getActivated())) {
                CloneableEditor.this.requestFocusInWindow();
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CloneableEditor.this.revalidate();
                }
            });
            this.isInInitVisual = false;
            CloneableEditor.this.initVisualFinished = true;
            CloneableEditorSupport ces = CloneableEditor.this.cloneableEditorSupport();
            if (ces != null) {
                ces.firePropertyChange("openedPanes", null, null);
            }
        }

        private void initRest() {
            RPPostprocessing.post(new Runnable(){

                @Override
                public void run() {
                    CloneableEditor.this.support.ensureAnnotationsLoaded();
                }
            });
        }
    }
}

