/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.vision;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jflux.api.core.Listener;
import org.robokind.api.vision.ImageEvent;
import org.robokind.api.vision.ImageRegion;
import org.robokind.api.vision.ImageRegionList;
import org.robokind.impl.vision.PortableImageUtils;

public class VideoPanel
extends JPanel {
    private static final double IMAGE_WIDTH = 320.0;
    private static final double IMAGE_HEIGHT = 240.0;
    private Image myImage;
    private ImageRegionList<ImageRegion> myImageRegions;
    private Runnable myRepaint;
    private ImageCache myImageCache;
    private ImageRegionListCache myImageRegionListCache;

    public VideoPanel() {
        this.initComponents();
        this.myRepaint = new Runnable(){

            @Override
            public void run() {
                VideoPanel.this.repaint();
            }
        };
        this.myImageCache = new ImageCache();
        this.myImageRegionListCache = new ImageRegionListCache();
    }

    public Listener<ImageEvent> getImageEventListener() {
        return this.myImageCache;
    }

    public Listener<ImageRegionList> getImageRegionListListener() {
        return this.myImageRegionListCache;
    }

    @Override
    public void paint(Graphics g) {
        if (this.myImage != null) {
            g.drawImage(this.myImage, 0, 0, this.getWidth(), this.getHeight(), null);
        }
        if (this.myImageRegions != null && this.myImageRegions.getRegions() != null) {
            g.setColor(Color.red);
            double width = this.getWidth();
            double height = this.getHeight();
            double wRatio = width / 320.0;
            double hRatio = height / 240.0;
            for (ImageRegion r : this.myImageRegions.getRegions()) {
                int x = (int)((double)r.getX().intValue() * wRatio);
                int y = (int)((double)r.getY().intValue() * hRatio);
                int w = (int)((double)r.getWidth().intValue() * wRatio);
                int h = (int)((double)r.getHeight().intValue() * hRatio);
                g.drawRect(x, y, w, h);
            }
        }
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    class ImageRegionListCache
    implements Listener<ImageRegionList> {
        ImageRegionListCache() {
        }

        public void handleEvent(ImageRegionList event) {
            if (event == null) {
                return;
            }
            VideoPanel.this.myImageRegions = event;
        }
    }

    class ImageCache
    implements Listener<ImageEvent> {
        ImageCache() {
        }

        public void handleEvent(ImageEvent event) {
            if (event == null) {
                return;
            }
            BufferedImage img = PortableImageUtils.unpackImage((ImageEvent)event);
            if (img == null) {
                return;
            }
            VideoPanel.this.myImage = img;
            SwingUtilities.invokeLater(VideoPanel.this.myRepaint);
        }
    }
}

