/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.vision;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URISyntaxException;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.apache.qpid.client.AMQConnectionFactory;
import org.apache.qpid.client.AMQQueue;
import org.apache.qpid.client.AMQTopic;
import org.jflux.api.core.Adapter;
import org.jflux.api.core.util.EmptyAdapter;
import org.robokind.api.common.playable.Playable;
import org.robokind.api.messaging.MessageAsyncReceiver;
import org.robokind.api.messaging.MessageSender;
import org.robokind.api.messaging.services.ServiceCommandFactory;
import org.robokind.api.vision.config.CameraServiceConfig;
import org.robokind.api.vision.config.FaceDetectServiceConfig;
import org.robokind.api.vision.messaging.RemoteImageRegionServiceClient;
import org.robokind.api.vision.messaging.RemoteImageServiceClient;
import org.robokind.avrogen.messaging.ServiceErrorRecord;
import org.robokind.avrogen.vision.ImageRecord;
import org.robokind.avrogen.vision.ImageRegionListRecord;
import org.robokind.impl.messaging.JMSAvroMessageAsyncReceiver;
import org.robokind.impl.messaging.JMSAvroMessageSender;
import org.robokind.impl.messaging.services.PortableServiceCommand;
import org.rwshop.swing.common.PlayControlPanel;
import org.rwshop.swing.vision.VideoPanel;

public class VideoControlPanel
extends JPanel {
    private VideoPanel myVideoPanel;
    private JButton btnConnect;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel3;
    private PlayControlPanel myFaceDetectControl;
    private PlayControlPanel myVideoControl;
    private JPanel pnlConnect;
    private JPanel pnlControl;
    private JTextField txtBrokerAddress;

    public VideoControlPanel() {
        this.initComponents();
    }

    public void setVideoPanel(VideoPanel panel) {
        this.myVideoPanel = panel;
    }

    private void initComponents() {
        this.pnlConnect = new JPanel();
        this.txtBrokerAddress = new JTextField();
        this.btnConnect = new JButton();
        this.pnlControl = new JPanel();
        this.jPanel1 = new JPanel();
        this.myVideoControl = new PlayControlPanel();
        this.jLabel1 = new JLabel();
        this.jPanel3 = new JPanel();
        this.myFaceDetectControl = new PlayControlPanel();
        this.jLabel3 = new JLabel();
        this.txtBrokerAddress.setText("127.0.0.1:5672");
        this.btnConnect.setText("Connect");
        this.btnConnect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VideoControlPanel.this.btnConnectActionPerformed(evt);
            }
        });
        GroupLayout pnlConnectLayout = new GroupLayout(this.pnlConnect);
        this.pnlConnect.setLayout(pnlConnectLayout);
        pnlConnectLayout.setHorizontalGroup(pnlConnectLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlConnectLayout.createSequentialGroup().addComponent(this.btnConnect).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtBrokerAddress, -2, 175, -2)));
        pnlConnectLayout.setVerticalGroup(pnlConnectLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlConnectLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnConnect).addComponent(this.txtBrokerAddress, -2, -1, -2)));
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel1.setText("Video");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent((Component)this.myVideoControl, -2, -1, -2)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.myVideoControl, -2, -1, -2).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1)));
        this.jPanel3.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel3.setText("Face Detection");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent((Component)this.myFaceDetectControl, -2, -1, -2)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.myFaceDetectControl, -2, -1, -2).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel3)));
        GroupLayout pnlControlLayout = new GroupLayout(this.pnlControl);
        this.pnlControl.setLayout(pnlControlLayout);
        pnlControlLayout.setHorizontalGroup(pnlControlLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlControlLayout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, -1, -2)));
        pnlControlLayout.setVerticalGroup(pnlControlLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel3, 0, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.pnlConnect, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlControl, -2, -1, -2)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlConnect, -2, -1, -2).addComponent(this.pnlControl, -2, -1, -2));
    }

    private void btnConnectActionPerformed(ActionEvent evt) {
        String addr = this.txtBrokerAddress.getText();
        String con = "amqp://admin:admin@clientid/test?brokerlist='tcp://" + addr + "'";
        try {
            RemoteImageServiceClient videoService = this.imageClient(con);
            RemoteImageRegionServiceClient faceService = this.imageRegionClient(con);
            this.myVideoControl.setPlayable((Playable)videoService);
            this.myFaceDetectControl.setPlayable((Playable)faceService);
            videoService.addImageListener(this.myVideoPanel.getImageEventListener());
            faceService.addImageRegionsListener(this.myVideoPanel.getImageRegionListListener());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private RemoteImageServiceClient imageClient(String con) throws URISyntaxException, JMSException, Exception {
        AMQConnectionFactory cf = new AMQConnectionFactory(con);
        Connection connection = cf.createConnection();
        Session session = connection.createSession(false, 2);
        connection.start();
        AMQQueue cmdDest = new AMQQueue("camera0Command; {create: always, node: {type: queue}}");
        AMQTopic errDest = new AMQTopic("camera0Error; {create: always, node: {type: topic}}");
        AMQTopic imgDest = new AMQTopic("camera0Event; {create: always, node: {type: topic}}");
        JMSAvroMessageSender cmdSender = new JMSAvroMessageSender(session, (Destination)cmdDest);
        JMSAvroMessageSender configSender = new JMSAvroMessageSender(session, (Destination)cmdDest);
        JMSAvroMessageAsyncReceiver errorReceiver = new JMSAvroMessageAsyncReceiver(session, (Destination)errDest, ServiceErrorRecord.class, ServiceErrorRecord.SCHEMA$);
        PortableServiceCommand.Factory cmdFactory = new PortableServiceCommand.Factory();
        JMSAvroMessageAsyncReceiver imageReceiver = new JMSAvroMessageAsyncReceiver(session, (Destination)imgDest, ImageRecord.class, ImageRecord.SCHEMA$);
        RemoteImageServiceClient service = new RemoteImageServiceClient(CameraServiceConfig.class, "imageService", "remoteId", (MessageSender)cmdSender, (MessageSender)configSender, (MessageAsyncReceiver)errorReceiver, (ServiceCommandFactory)cmdFactory, (MessageAsyncReceiver)imageReceiver);
        cmdSender.setAdapter((Adapter)new EmptyAdapter());
        cmdSender.setDefaultContentType("application/service-command");
        cmdSender.start();
        errorReceiver.setAdapter((Adapter)new EmptyAdapter());
        errorReceiver.start();
        imageReceiver.setAdapter((Adapter)new EmptyAdapter());
        imageReceiver.start();
        return service;
    }

    private RemoteImageRegionServiceClient imageRegionClient(String con) throws URISyntaxException, JMSException, Exception {
        AMQConnectionFactory cf = new AMQConnectionFactory(con);
        Connection connection = cf.createConnection();
        Session session = connection.createSession(false, 2);
        connection.start();
        AMQQueue cmdDest = new AMQQueue("visionproc0Command; {create: always, node: {type: queue}}");
        AMQTopic errDest = new AMQTopic("visionproc0Error; {create: always, node: {type: topic}}");
        AMQTopic imgRgnDest = new AMQTopic("visionproc0Event; {create: always, node: {type: topic}}");
        JMSAvroMessageSender cmdSender = new JMSAvroMessageSender(session, (Destination)cmdDest);
        JMSAvroMessageSender configSender = new JMSAvroMessageSender(session, (Destination)cmdDest);
        JMSAvroMessageAsyncReceiver errorReceiver = new JMSAvroMessageAsyncReceiver(session, (Destination)errDest, ServiceErrorRecord.class, ServiceErrorRecord.SCHEMA$);
        PortableServiceCommand.Factory cmdFactory = new PortableServiceCommand.Factory();
        JMSAvroMessageAsyncReceiver imageRgnReceiver = new JMSAvroMessageAsyncReceiver(session, (Destination)imgRgnDest, ImageRegionListRecord.class, ImageRegionListRecord.SCHEMA$);
        RemoteImageRegionServiceClient service = new RemoteImageRegionServiceClient(FaceDetectServiceConfig.class, "imageService", "remoteId", (MessageSender)cmdSender, (MessageSender)configSender, (MessageAsyncReceiver)errorReceiver, (ServiceCommandFactory)cmdFactory, (MessageAsyncReceiver)imageRgnReceiver);
        cmdSender.setAdapter((Adapter)new EmptyAdapter());
        cmdSender.setDefaultContentType("application/service-command");
        cmdSender.start();
        errorReceiver.setAdapter((Adapter)new EmptyAdapter());
        errorReceiver.start();
        imageRgnReceiver.setAdapter((Adapter)new EmptyAdapter());
        imageRgnReceiver.start();
        return service;
    }
}

