/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.messaging.player;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.jms.Destination;
import javax.jms.Session;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.io.DatumReader;
import org.apache.avro.specific.SpecificDatumReader;
import org.robokind.api.common.utils.TimeUtils;
import org.robokind.impl.messaging.JMSAvroRecordSender;
import org.robokind.impl.messaging.JMSBytesMessageSender;
import org.rwshop.swing.messaging.monitor.TimestampComparator;
import org.rwshop.swing.messaging.player.EditorListPanel;

public class PlayerPanel
extends JPanel {
    private Session mySession;
    private Destination myDestination;
    private Schema mySchema;
    private EditorListPanel myEditorList;
    private JButton jButton1;
    private JButton jButton2;

    public PlayerPanel() {
        this.initComponents();
    }

    public void setSession(Session session) {
        this.mySession = session;
    }

    public void setDestination(Destination destination) {
        this.myDestination = destination;
    }

    public void setSchema(Schema schema) {
        this.mySchema = schema;
    }

    public void setEditorList(EditorListPanel editorList) {
        this.myEditorList = editorList;
    }

    public void activate() {
        this.jButton1.setEnabled(true);
        if (this.myEditorList.getRecords().size() > 0) {
            this.jButton2.setEnabled(true);
        }
    }

    public void deactivate() {
        this.jButton1.setEnabled(false);
        this.jButton2.setEnabled(false);
    }

    private void loadMessages() {
        JFileChooser fc = new JFileChooser();
        int retVal = fc.showOpenDialog(this);
        ArrayList<Object> records = new ArrayList<Object>();
        if (retVal == 0) {
            File file = fc.getSelectedFile();
            SpecificDatumReader reader = new SpecificDatumReader(this.mySchema);
            try {
                DataFileReader fileReader = new DataFileReader(file, (DatumReader)reader);
                while (fileReader.hasNext()) {
                    records.add(fileReader.next());
                }
                fileReader.close();
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, "Error: " + ex.getMessage(), "Failure", 0);
            }
            this.myEditorList.clear();
            for (IndexedRecord indexedRecord : records) {
                this.myEditorList.addRecord(indexedRecord);
            }
            JOptionPane.showMessageDialog(this, "Records loaded.", "Success", 1);
        }
    }

    private void playMessages() {
        List<IndexedRecord> records = this.myEditorList.getRecords();
        JMSBytesMessageSender msgSender = new JMSBytesMessageSender();
        msgSender.setSession(this.mySession);
        msgSender.setDestination(this.myDestination);
        msgSender.openProducer();
        JMSAvroRecordSender sender = new JMSAvroRecordSender(msgSender);
        TimestampComparator cmp = new TimestampComparator();
        int timestampIndex = -1;
        long timeline = 0L;
        for (int i = 0; i < this.mySchema.getFields().size(); ++i) {
            if (!((Schema.Field)this.mySchema.getFields().get(i)).name().equals("timestampMillisecUTC")) continue;
            timestampIndex = i;
            break;
        }
        if (timestampIndex < 0) {
            msgSender.closeProducer();
            JOptionPane.showMessageDialog(this, "Error: no timestamp information present.", "Failure", 0);
            return;
        }
        Collections.sort(records, cmp);
        Long firstTimestamp = (Long)records.get(0).get(timestampIndex);
        for (IndexedRecord record : records) {
            Long totalDelay = (Long)record.get(timestampIndex) - firstTimestamp;
            Long delay = totalDelay - timeline;
            if (delay > 0L) {
                TimeUtils.sleep((long)delay);
            }
            timeline += delay.longValue();
            sender.sendRecord(record);
        }
        msgSender.closeProducer();
        JOptionPane.showMessageDialog(this, "Records loaded.", "Success", 1);
    }

    private void initComponents() {
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jButton1.setText("Load");
        this.jButton1.setEnabled(false);
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlayerPanel.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setText("Play");
        this.jButton2.setEnabled(false);
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlayerPanel.this.jButton2ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 277, Short.MAX_VALUE).addComponent(this.jButton2)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1).addComponent(this.jButton2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.loadMessages();
        this.jButton2.setEnabled(true);
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.playMessages();
    }
}

