/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.messaging.player;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.avro.generic.IndexedRecord;
import org.rwshop.swing.messaging.player.EditorPanel;

public class ListEditorPanel
extends JPanel {
    private IndexedRecord myRecord;
    private int myIndex;
    private List myList;

    public ListEditorPanel(IndexedRecord record, int index) {
        this.initComponents();
        this.setLayout(new BoxLayout(this, 3));
        this.myRecord = record;
        this.myIndex = index;
        this.myList = (List)this.myRecord.get(this.myIndex);
        for (int i = 0; i < this.myList.size(); ++i) {
            this.addItem(i);
        }
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    private void addItem(int i) {
        Object o = this.myList.get(i);
        if (IndexedRecord.class.isAssignableFrom(o.getClass())) {
            this.addEditorPanel(o);
        } else {
            this.addEditor(i);
        }
    }

    private void pushValue(String val, int i) {
        Class<?> cls = ((List)this.myRecord.get(this.myIndex)).get(i).getClass();
        try {
            Object parsedVal = this.parseValue(cls, val);
            ((List)this.myRecord.get(this.myIndex)).set(i, parsedVal);
        }
        catch (Exception ex) {
            String message = "Failed to set " + val + " on index " + i;
            String longMessage = message + ":\n\n" + ex.getMessage();
            JOptionPane.showMessageDialog(this, longMessage, "Error", 0);
        }
    }

    private Object parseValue(Class cls, String val) {
        if (Integer.class.isAssignableFrom(cls)) {
            return Integer.parseInt(val);
        }
        if (Long.class.isAssignableFrom(cls)) {
            return Long.parseLong(val);
        }
        if (Short.class.isAssignableFrom(cls)) {
            return Short.parseShort(val);
        }
        if (Byte.class.isAssignableFrom(cls)) {
            return Byte.parseByte(val);
        }
        if (Float.class.isAssignableFrom(cls)) {
            return Float.valueOf(Float.parseFloat(val));
        }
        if (Double.class.isAssignableFrom(cls)) {
            return Double.parseDouble(val);
        }
        if (String.class.isAssignableFrom(cls)) {
            return val;
        }
        throw new IllegalArgumentException(val);
    }

    private void addEditorPanel(Object o) {
        EditorPanel panel = new EditorPanel();
        panel.setRecord((IndexedRecord)o);
        this.add(panel);
    }

    private void addEditor(final int i) {
        Object o = this.myList.get(i);
        final JTextField editor = new JTextField(o.toString());
        editor.setDropTarget(null);
        editor.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                if (evt.getKeyCode() == 10) {
                    String val = editor.getText();
                    ListEditorPanel.this.pushValue(val, i);
                }
            }
        });
        editor.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent evt) {
                String val = editor.getText();
                ListEditorPanel.this.pushValue(val, i);
            }

            @Override
            public void focusGained(FocusEvent evt) {
            }
        });
        this.add(editor);
    }
}

