/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.messaging.player;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.rwshop.swing.messaging.player.ListEditorPanel;

public class EditorPanel
extends JPanel {
    private IndexedRecord myRecord;
    private GridBagConstraints myConstraints;

    public EditorPanel() {
        this.initComponents();
        this.myConstraints = new GridBagConstraints();
        this.myConstraints.fill = 2;
    }

    public void setRecord(IndexedRecord record) {
        this.myRecord = record;
        Schema schema = this.myRecord.getSchema();
        this.removeAll();
        this.myConstraints.gridx = 0;
        this.myConstraints.gridy = 0;
        this.myConstraints.weightx = 0.0;
        this.myConstraints.gridwidth = 1;
        this.setLayout(new GridBagLayout());
        List fields = schema.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            Schema.Field field = (Schema.Field)fields.get(i);
            Class<?> cls = this.myRecord.get(i).getClass();
            JLabel label = new JLabel(field.name());
            this.myConstraints.gridx = 0;
            this.myConstraints.weightx = 0.0;
            this.add((Component)label, this.myConstraints);
            this.myConstraints.gridx = 1;
            this.myConstraints.weightx = 1.0;
            if (IndexedRecord.class.isAssignableFrom(cls)) {
                this.addEditorPanel(i);
            } else if (List.class.isAssignableFrom(cls)) {
                this.addList(i);
            } else {
                this.addEditor(field, i);
            }
            ++this.myConstraints.gridy;
        }
        this.revalidate();
    }

    private void addEditorPanel(int i) {
        IndexedRecord record = (IndexedRecord)this.myRecord.get(i);
        EditorPanel panel = new EditorPanel();
        panel.setRecord(record);
        this.add((Component)panel, this.myConstraints);
    }

    private void addList(int i) {
        ListEditorPanel panel = new ListEditorPanel(this.myRecord, i);
        this.add((Component)panel, this.myConstraints);
    }

    private void addEditor(final Schema.Field field, final int i) {
        final JTextField editor = new JTextField(this.myRecord.get(i).toString());
        editor.setDropTarget(null);
        editor.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                if (evt.getKeyCode() == 10) {
                    String val = editor.getText();
                    EditorPanel.this.pushValue(val, field, i);
                }
            }
        });
        editor.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent evt) {
                String val = editor.getText();
                EditorPanel.this.pushValue(val, field, i);
            }

            @Override
            public void focusGained(FocusEvent evt) {
            }
        });
        this.add((Component)editor, this.myConstraints);
    }

    private void pushValue(String val, Schema.Field field, int i) {
        Class<?> cls = this.myRecord.get(i).getClass();
        try {
            Object parsedVal = this.parseValue(cls, val);
            this.myRecord.put(i, parsedVal);
        }
        catch (Exception ex) {
            String message = "Failed to set " + val + " on " + field.name();
            String longMessage = message + ":\n\n" + ex.getMessage();
            JOptionPane.showMessageDialog(this, longMessage, "Error", 0);
        }
    }

    private Object parseValue(Class cls, String val) {
        if (Integer.class.isAssignableFrom(cls)) {
            return Integer.parseInt(val);
        }
        if (Long.class.isAssignableFrom(cls)) {
            return Long.parseLong(val);
        }
        if (Short.class.isAssignableFrom(cls)) {
            return Short.parseShort(val);
        }
        if (Byte.class.isAssignableFrom(cls)) {
            return Byte.parseByte(val);
        }
        if (Float.class.isAssignableFrom(cls)) {
            return Float.valueOf(Float.parseFloat(val));
        }
        if (Double.class.isAssignableFrom(cls)) {
            return Double.parseDouble(val);
        }
        if (String.class.isAssignableFrom(cls)) {
            return val;
        }
        throw new IllegalArgumentException(val);
    }

    public IndexedRecord getRecord() {
        return this.myRecord;
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }
}

